/*
 * Decompiled with CFR 0.152.
 */
package ui;

import java.awt.image.RenderedImage;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.DateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.function.Function;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.embed.swing.SwingFXUtils;
import javafx.fxml.FXML;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.RadioButton;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import javafx.scene.media.AudioClip;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.util.Duration;
import javafx.util.StringConverter;
import javafx.util.converter.IntegerStringConverter;
import javax.imageio.ImageIO;
import libsidplay.C64;
import libsidplay.common.CPUClock;
import libsidplay.common.ChipModel;
import libsidplay.common.Emulation;
import libsidplay.common.Engine;
import libsidplay.common.Event;
import libsidplay.common.EventScheduler;
import libsidplay.common.SamplingMethod;
import libsidplay.common.SamplingRate;
import libsidplay.components.c1530.Datasette;
import libsidplay.components.c1541.C1541;
import libsidplay.components.c1541.ExtendImagePolicy;
import libsidplay.components.c1541.IExtendImageListener;
import libsidplay.components.cart.CartridgeType;
import libsidplay.sidtune.SidTune;
import libsidplay.sidtune.SidTuneError;
import libsidplay.sidtune.SidTuneInfo;
import libsidutils.PathUtils;
import libsidutils.WebUtils;
import libsidutils.sidid.SidIdInfo;
import netsiddev_builder.NetSIDDevConnection;
import sidplay.Player;
import sidplay.audio.Audio;
import sidplay.audio.JavaSound;
import sidplay.player.PlayList;
import sidplay.player.State;
import ui.JSidPlay2Main;
import ui.about.About;
import ui.asm.Asm;
import ui.common.C64Window;
import ui.common.Convenience;
import ui.common.EnumToString;
import ui.common.TimeToStringConverter;
import ui.common.UIPart;
import ui.common.dialog.AlertDialog;
import ui.common.dialog.YesNoDialog;
import ui.console.Console;
import ui.disassembler.Disassembler;
import ui.diskcollection.DiskCollection;
import ui.diskcollection.DiskCollectionType;
import ui.emulationsettings.EmulationSettings;
import ui.entities.config.AudioSection;
import ui.entities.config.C1541Section;
import ui.entities.config.Configuration;
import ui.entities.config.EmulationSection;
import ui.entities.config.PrinterSection;
import ui.entities.config.SidPlay2Section;
import ui.entities.config.ViewEntity;
import ui.favorites.Favorites;
import ui.favorites.PlaybackType;
import ui.filefilter.CartFileExtensions;
import ui.filefilter.DiskFileExtensions;
import ui.filefilter.TapeFileExtensions;
import ui.filefilter.TuneFileExtensions;
import ui.gamebase.GameBase;
import ui.joysticksettings.JoystickSettings;
import ui.musiccollection.MusicCollection;
import ui.musiccollection.MusicCollectionType;
import ui.oscilloscope.Oscilloscope;
import ui.printer.Printer;
import ui.proxysettings.ProxySettings;
import ui.siddump.SidDump;
import ui.sidreg.SidReg;
import ui.update.Update;
import ui.videoscreen.Video;
import ui.webview.WebView;
import ui.webview.WebViewType;

public class JSidPlay2
extends C64Window
implements IExtendImageListener,
Function<SidTune, String> {
    private static final AudioClip MOTORSOUND_AUDIOCLIP = new AudioClip(JSidPlay2.class.getResource("/ui/sounds/motor.wav").toString());
    private static final AudioClip TRACKSOUND_AUDIOCLIP = new AudioClip(JSidPlay2.class.getResource("/ui/sounds/track.wav").toString());
    private static final String CELL_VALUE_OK = "cellValueOk";
    private static final String CELL_VALUE_ERROR = "cellValueError";
    private static String DATE = "unknown";
    private static final String NUVIE_PLAYER_PRG = "/libsidplay/roms/nuvieplayer-v1.0.prg";
    private static byte[] NUVIE_PLAYER;
    private static final String EMPTY_D64 = "/libsidplay/components/c1541/empty.d64";
    private static byte[] EMPTY_DISK;
    @FXML
    protected CheckMenuItem pauseContinue;
    @FXML
    protected CheckMenuItem driveOn;
    @FXML
    protected CheckMenuItem driveSoundOn;
    @FXML
    protected CheckMenuItem parCable;
    @FXML
    protected CheckMenuItem installJiffyDos;
    @FXML
    protected CheckMenuItem expand2000;
    @FXML
    protected CheckMenuItem expand4000;
    @FXML
    protected CheckMenuItem expand6000;
    @FXML
    protected CheckMenuItem expand8000;
    @FXML
    protected CheckMenuItem expandA000;
    @FXML
    protected CheckMenuItem turnPrinterOn;
    @FXML
    protected RadioMenuItem fastForward;
    @FXML
    protected RadioMenuItem normalSpeed;
    @FXML
    protected RadioMenuItem c1541;
    @FXML
    protected RadioMenuItem c1541_II;
    @FXML
    protected RadioMenuItem neverExtend;
    @FXML
    protected RadioMenuItem askExtend;
    @FXML
    protected RadioMenuItem accessExtend;
    @FXML
    protected MenuItem previous;
    @FXML
    protected MenuItem next;
    @FXML
    private ComboBox<SamplingMethod> samplingBox;
    @FXML
    private ComboBox<CPUClock> videoStandardBox;
    @FXML
    private ComboBox<Integer> hardsid6581Box;
    @FXML
    private ComboBox<Integer> hardsid8580Box;
    @FXML
    private ComboBox<SamplingRate> samplingRateBox;
    @FXML
    private ComboBox<Audio> audioBox;
    @FXML
    private ComboBox<JavaSound.Device> devicesBox;
    @FXML
    private ComboBox<Engine> engineBox;
    @FXML
    private CheckBox enableSldb;
    @FXML
    private CheckBox singleSong;
    @FXML
    private TextField defaultTime;
    @FXML
    private TextField hostname;
    @FXML
    private TextField port;
    @FXML
    private ToggleButton pauseContinue2;
    @FXML
    private ToggleButton fastForward2;
    @FXML
    protected RadioButton playMP3;
    @FXML
    protected RadioButton playEmulation;
    @FXML
    ToggleGroup playSourceGroup;
    @FXML
    protected Button previous2;
    @FXML
    protected Button next2;
    @FXML
    protected Button nextFavorite;
    @FXML
    protected Button volumeButton;
    @FXML
    protected Button mp3Browse;
    @FXML
    protected Tooltip previous2ToolTip;
    @FXML
    protected Tooltip next2ToolTip;
    @FXML
    protected TabPane tabbedPane;
    @FXML
    private Label tracks;
    @FXML
    private Label status;
    @FXML
    private Label hostnameLabel;
    @FXML
    private Label portLabel;
    @FXML
    private Label hardsid6581Label;
    @FXML
    private Label hardsid8580Label;
    @FXML
    protected ProgressBar progress;
    private Scene scene;
    private Timeline timer;
    private int oldHalfTrack;
    private int hardcopyCounter;
    private boolean duringInitialization;
    private boolean oldMotorOn;
    private StringBuilder playerId;
    private StringBuilder playerinfos;
    private BooleanProperty nextFavoriteDisabledState;
    private Tooltip statusTooltip;
    private StateChangeListener nextTuneListener;

    public JSidPlay2(Stage primaryStage, Player player) {
        super(primaryStage, player);
    }

    @FXML
    private void initialize() {
        this.duringInitialization = true;
        this.getStage().setTitle(this.util.getBundle().getString("TITLE") + String.format(", %s: %s", this.util.getBundle().getString("RELEASE"), DATE));
        ResourceBundle bundle = this.util.getBundle();
        Configuration config = this.util.getConfig();
        SidPlay2Section sidplay2Section = config.getSidplay2Section();
        AudioSection audioSection = config.getAudioSection();
        EmulationSection emulationSection = config.getEmulationSection();
        C1541Section c1541Section = config.getC1541Section();
        PrinterSection printer = config.getPrinterSection();
        this.playerId = new StringBuilder();
        this.playerinfos = new StringBuilder();
        this.scene = this.tabbedPane.getScene();
        this.statusTooltip = new Tooltip();
        this.nextTuneListener = new StateChangeListener();
        this.status.setOnMouseClicked(e -> {
            if (this.status.getUserData() != null) {
                WebUtils.browse(this.status.getUserData().toString());
            }
        });
        this.util.getPlayer().setRecordingFilenameProvider(this);
        this.util.getPlayer().setExtendImagePolicy(this);
        this.util.getPlayer().stateProperty().addListener((ChangeListener)this.nextTuneListener);
        this.audioBox.setConverter(new EnumToString(bundle));
        this.audioBox.setItems(FXCollections.observableArrayList((Object[])new Audio[]{Audio.SOUNDCARD, Audio.LIVE_WAV, Audio.LIVE_MP3, Audio.COMPARE_MP3}));
        this.audioBox.valueProperty().addListener((obj, o, n) -> {
            this.mp3Browse.setDisable(!Audio.COMPARE_MP3.equals(n));
            this.playMP3.setDisable(!Audio.COMPARE_MP3.equals(n));
            this.playEmulation.setDisable(!Audio.COMPARE_MP3.equals(n));
        });
        this.audioBox.valueProperty().bindBidirectional(audioSection.audioProperty());
        this.devicesBox.setItems(JavaSound.getDevices());
        this.devicesBox.getSelectionModel().select(Math.min(audioSection.getDevice(), this.devicesBox.getItems().size() - 1));
        this.samplingBox.setConverter(new EnumToString(bundle));
        this.samplingBox.setItems(FXCollections.observableArrayList((Object[])SamplingMethod.values()));
        this.samplingBox.valueProperty().bindBidirectional(audioSection.samplingProperty());
        this.samplingRateBox.setConverter(new EnumToString(bundle));
        this.samplingRateBox.setItems(FXCollections.observableArrayList((Object[])SamplingRate.values()));
        this.samplingRateBox.valueProperty().bindBidirectional(audioSection.samplingRateProperty());
        this.videoStandardBox.setConverter(new EnumToString(bundle));
        this.videoStandardBox.valueProperty().bindBidirectional(emulationSection.defaultClockSpeedProperty());
        this.videoStandardBox.setItems(FXCollections.observableArrayList((Object[])CPUClock.values()));
        this.hardsid6581Box.valueProperty().bindBidirectional(emulationSection.hardsid6581Property());
        this.hardsid8580Box.valueProperty().bindBidirectional(emulationSection.hardsid8580Property());
        this.engineBox.setConverter(new EnumToString(bundle));
        this.engineBox.setItems(FXCollections.observableArrayList((Object[])Engine.values()));
        this.engineBox.valueProperty().addListener((obj, o, n) -> {
            this.hardsid6581Box.setDisable(!Engine.HARDSID.equals(n));
            this.hardsid8580Box.setDisable(!Engine.HARDSID.equals(n));
            this.hardsid6581Label.setDisable(!Engine.HARDSID.equals(n));
            this.hardsid8580Label.setDisable(!Engine.HARDSID.equals(n));
            this.hostnameLabel.setDisable(!Engine.NETSID.equals(n));
            this.hostname.setDisable(!Engine.NETSID.equals(n));
            this.portLabel.setDisable(!Engine.NETSID.equals(n));
            this.port.setDisable(!Engine.NETSID.equals(n));
        });
        this.engineBox.valueProperty().bindBidirectional(emulationSection.engineProperty());
        Bindings.bindBidirectional((Property)this.defaultTime.textProperty(), (Property)sidplay2Section.defaultPlayLengthProperty(), (StringConverter)new TimeToStringConverter());
        sidplay2Section.defaultPlayLengthProperty().addListener((obj, o, n) -> {
            Tooltip tooltip = new Tooltip();
            this.defaultTime.getStyleClass().removeAll((Object[])new String[]{CELL_VALUE_OK, CELL_VALUE_ERROR});
            if (n.intValue() != -1) {
                this.util.getPlayer().getTimer().updateEnd();
                tooltip.setText(this.util.getBundle().getString("DEFAULT_LENGTH_TIP"));
                this.defaultTime.setTooltip(tooltip);
                this.defaultTime.getStyleClass().add((Object)CELL_VALUE_OK);
            } else {
                tooltip.setText(this.util.getBundle().getString("DEFAULT_LENGTH_FORMAT"));
                this.defaultTime.setTooltip(tooltip);
                this.defaultTime.getStyleClass().add((Object)CELL_VALUE_ERROR);
            }
        });
        this.hostname.textProperty().bindBidirectional((Property)emulationSection.netSidDevHostProperty());
        Bindings.bindBidirectional((Property)this.port.textProperty(), emulationSection.netSidDevPortProperty(), (StringConverter)new IntegerStringConverter());
        this.enableSldb.selectedProperty().bindBidirectional((Property)sidplay2Section.enableDatabaseProperty());
        this.singleSong.selectedProperty().bindBidirectional((Property)sidplay2Section.singleProperty());
        this.playEmulation.selectedProperty().set(!audioSection.isPlayOriginal());
        this.playMP3.selectedProperty().addListener((obj, o, n) -> this.playEmulation.selectedProperty().set(n == false));
        this.playMP3.selectedProperty().bindBidirectional((Property)audioSection.playOriginalProperty());
        this.updatePlayerButtons(this.util.getPlayer().getPlayList());
        this.pauseContinue.selectedProperty().bindBidirectional((Property)this.pauseContinue2.selectedProperty());
        this.fastForward2.selectedProperty().bindBidirectional((Property)this.fastForward.selectedProperty());
        this.nextFavoriteDisabledState = new SimpleBooleanProperty(true);
        this.nextFavorite.disableProperty().bind((ObservableValue)this.nextFavoriteDisabledState);
        this.driveOn.selectedProperty().bindBidirectional((Property)c1541Section.driveOnProperty());
        this.parCable.selectedProperty().bindBidirectional((Property)c1541Section.parallelCableProperty());
        this.installJiffyDos.selectedProperty().bindBidirectional((Property)c1541Section.jiffyDosInstalledProperty());
        this.driveSoundOn.selectedProperty().bindBidirectional((Property)c1541Section.driveSoundOnProperty());
        this.turnPrinterOn.selectedProperty().bindBidirectional((Property)printer.printerOnProperty());
        C1541.FloppyType floppyType = c1541Section.getFloppyType();
        (floppyType == C1541.FloppyType.C1541 ? this.c1541 : this.c1541_II).setSelected(true);
        ExtendImagePolicy extendImagePolicy = c1541Section.getExtendImagePolicy();
        (extendImagePolicy == ExtendImagePolicy.EXTEND_NEVER ? this.neverExtend : (extendImagePolicy == ExtendImagePolicy.EXTEND_ASK ? this.askExtend : this.accessExtend)).setSelected(true);
        this.expand2000.selectedProperty().bindBidirectional((Property)c1541Section.ramExpansionEnabled0Property());
        this.expand4000.selectedProperty().bindBidirectional((Property)c1541Section.ramExpansionEnabled1Property());
        this.expand6000.selectedProperty().bindBidirectional((Property)c1541Section.ramExpansionEnabled2Property());
        this.expand8000.selectedProperty().bindBidirectional((Property)c1541Section.ramExpansionEnabled3Property());
        this.expandA000.selectedProperty().bindBidirectional((Property)c1541Section.ramExpansionEnabled4Property());
        for (ViewEntity view : config.getViews()) {
            Platform.runLater(() -> this.addView(view.getFxId()));
        }
        this.duringInitialization = false;
        Duration duration = Duration.millis((double)1000.0);
        KeyFrame frame = new KeyFrame(duration, evt -> this.setStatusLine(), new KeyValue[0]);
        this.timer = new Timeline(new KeyFrame[]{frame});
        this.timer.setCycleCount(-1);
        this.timer.playFromStart();
        Platform.runLater(() -> {
            this.scene.setOnDragOver(event -> {
                Dragboard db = event.getDragboard();
                if (db.hasFiles()) {
                    event.acceptTransferModes(new TransferMode[]{TransferMode.COPY});
                } else {
                    event.consume();
                }
            });
            this.scene.setOnDragDropped(event -> {
                Dragboard db = event.getDragboard();
                boolean success = false;
                if (db.hasFiles()) {
                    success = true;
                    List files = db.getFiles();
                    try {
                        this.video();
                        this.util.setPlayingTab(this.tabbedPane.getTabs().stream().filter(tab -> tab.getId().equals("VIDEO")).findFirst().get());
                        new Convenience(this.util.getPlayer()).autostart((File)files.get(0), Convenience.LEXICALLY_FIRST_MEDIA, null);
                    }
                    catch (IOException | URISyntaxException | SidTuneError e) {
                        this.openErrorDialog(String.format(this.util.getBundle().getString("ERR_IO_ERROR"), e.getMessage()));
                    }
                }
                event.setDropCompleted(success);
                event.consume();
            });
            this.tabbedPane.requestFocus();
            this.util.getPlayer().startC64();
        });
    }

    @Override
    public void doClose() {
        this.util.getPlayer().stateProperty().removeListener((ChangeListener)this.nextTuneListener);
        this.timer.stop();
        this.stopSong();
        Platform.exit();
    }

    @FXML
    private void load() {
        FileChooser fileDialog = new FileChooser();
        fileDialog.setInitialDirectory(this.util.getConfig().getSidplay2Section().getLastDirectoryFolder());
        fileDialog.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("C64 Tunes", TuneFileExtensions.EXTENSIONS));
        File file = fileDialog.showOpenDialog(this.scene.getWindow());
        if (file != null) {
            this.util.getConfig().getSidplay2Section().setLastDirectory(file.getParent());
            try {
                this.playTune(SidTune.load(file));
            }
            catch (IOException | SidTuneError e) {
                this.openErrorDialog(String.format(this.util.getBundle().getString("ERR_IO_ERROR"), e.getMessage()));
            }
        }
    }

    @FXML
    private void playVideo() {
        FileChooser fileDialog = new FileChooser();
        fileDialog.setInitialDirectory(this.util.getConfig().getSidplay2Section().getLastDirectoryFolder());
        fileDialog.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("C64 Cartridges", CartFileExtensions.EXTENSIONS));
        File file = fileDialog.showOpenDialog(this.scene.getWindow());
        if (file != null) {
            File tmpFile = new File(this.util.getConfig().getSidplay2Section().getTmpDir(), "nuvieplayer-v1.0.prg");
            tmpFile.deleteOnExit();
            try (DataOutputStream os = new DataOutputStream(new FileOutputStream(tmpFile));){
                os.write(NUVIE_PLAYER);
                this.util.getPlayer().insertCartridge(CartridgeType.REU, file);
                this.util.getPlayer().play(SidTune.load(tmpFile));
            }
            catch (IOException | SidTuneError e) {
                this.openErrorDialog(String.format(this.util.getBundle().getString("ERR_IO_ERROR"), e.getMessage()));
            }
        }
    }

    @FXML
    private void reset() {
        if (!this.duringInitialization) {
            this.playTune(SidTune.RESET);
        }
    }

    @FXML
    private void quit() {
        this.close();
    }

    @FXML
    private void pause() {
        this.util.getPlayer().pauseContinue();
    }

    @FXML
    private void previousSong() {
        this.util.getPlayer().previousSong();
    }

    @FXML
    private void nextSong() {
        this.util.getPlayer().nextSong();
    }

    @FXML
    private void playNormalSpeed() {
        this.util.getPlayer().configureMixer(mixer -> mixer.normalSpeed());
    }

    @FXML
    private void playFastForward() {
        this.util.getPlayer().configureMixer(mixer -> mixer.fastForward());
    }

    @FXML
    private void fastForward() {
        if (this.util.getPlayer().getMixerInfo(mixer -> mixer.isFastForward(), false).booleanValue()) {
            this.util.getPlayer().configureMixer(mixer -> mixer.normalSpeed());
            this.normalSpeed.setSelected(true);
        } else {
            this.util.getPlayer().configureMixer(mixer -> mixer.fastForward());
            this.fastForward.setSelected(true);
        }
    }

    @FXML
    private void nextFavorite() {
        C64 c64 = this.util.getPlayer().getC64();
        EventScheduler ctx = c64.getEventScheduler();
        ctx.scheduleThreadSafe(new Event("Timer End To Play Next Favorite!"){

            @Override
            public void event() {
                if (JSidPlay2.this.util.getPlayer().stateProperty().get() == State.PLAY) {
                    JSidPlay2.this.util.getPlayer().getTimer().end();
                }
            }
        });
    }

    @FXML
    private void stopSong() {
        this.util.getPlayer().quit();
    }

    @FXML
    private void doHardcopyGif() {
        this.createHardCopy("gif");
    }

    @FXML
    private void doHardcopyJpg() {
        this.createHardCopy("jpg");
    }

    @FXML
    private void doHardcopyPng() {
        this.createHardCopy("png");
    }

    @FXML
    private void setVideoStandard() {
        this.restart();
    }

    @FXML
    private void proxySettings() {
        new ProxySettings(this.util.getPlayer()).open();
    }

    @FXML
    private void emulationSettings() {
        new EmulationSettings(this.util.getPlayer()).open();
    }

    @FXML
    private void joystickSettings() {
        new JoystickSettings(this.util.getPlayer()).open();
    }

    @FXML
    private void record() {
        this.util.getPlayer().getDatasette().control(Datasette.Control.RECORD);
    }

    @FXML
    private void play() {
        this.util.getPlayer().getDatasette().control(Datasette.Control.START);
    }

    @FXML
    private void rewind() {
        this.util.getPlayer().getDatasette().control(Datasette.Control.REWIND);
    }

    @FXML
    private void forward() {
        this.util.getPlayer().getDatasette().control(Datasette.Control.FORWARD);
    }

    @FXML
    private void stop() {
        this.util.getPlayer().getDatasette().control(Datasette.Control.STOP);
    }

    @FXML
    private void resetCounter() {
        this.util.getPlayer().getDatasette().control(Datasette.Control.RESET_COUNTER);
    }

    @FXML
    private void insertTape() {
        FileChooser fileDialog = new FileChooser();
        fileDialog.setInitialDirectory(this.util.getConfig().getSidplay2Section().getLastDirectoryFolder());
        fileDialog.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Tape Image (TAP, T64, PRG, P00, GZ or ZIP)", TapeFileExtensions.EXTENSIONS));
        fileDialog.setTitle(this.util.getBundle().getString("INSERT_TAPE"));
        File file = fileDialog.showOpenDialog(this.scene.getWindow());
        if (file != null) {
            try {
                this.util.getPlayer().insertTape(file);
            }
            catch (IOException | SidTuneError e) {
                System.err.println(String.format("Cannot insert media file '%s'.", file.getAbsolutePath()));
            }
        }
    }

    @FXML
    private void ejectTape() {
        try {
            this.util.getPlayer().getDatasette().ejectTape();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @FXML
    private void turnDriveOn() {
        this.util.getPlayer().enableFloppyDiskDrives(this.util.getConfig().getC1541Section().isDriveOn());
    }

    @FXML
    private void parallelCable() {
        this.util.getPlayer().connectC64AndC1541WithParallelCable(this.util.getConfig().getC1541Section().isParallelCable());
    }

    @FXML
    private void installJiffyDos() {
        this.reset();
    }

    @FXML
    private void floppyTypeC1541() {
        this.getFirstFloppy().setFloppyType(C1541.FloppyType.C1541);
        this.util.getConfig().getC1541Section().setFloppyType(C1541.FloppyType.C1541);
    }

    @FXML
    private void floppyTypeC1541_II() {
        this.getFirstFloppy().setFloppyType(C1541.FloppyType.C1541_II);
        this.util.getConfig().getC1541Section().setFloppyType(C1541.FloppyType.C1541_II);
    }

    @FXML
    private void extendNever() {
        this.util.getConfig().getC1541Section().setExtendImagePolicy(ExtendImagePolicy.EXTEND_NEVER);
    }

    @FXML
    private void extendAsk() {
        this.util.getConfig().getC1541Section().setExtendImagePolicy(ExtendImagePolicy.EXTEND_ASK);
    }

    @FXML
    private void extendAccess() {
        this.util.getConfig().getC1541Section().setExtendImagePolicy(ExtendImagePolicy.EXTEND_ACCESS);
    }

    @FXML
    private void expansion0x2000() {
        this.getFirstFloppy().setRamExpansion(0, this.util.getConfig().getC1541Section().isRamExpansionEnabled0());
    }

    @FXML
    private void expansion0x4000() {
        this.getFirstFloppy().setRamExpansion(1, this.util.getConfig().getC1541Section().isRamExpansionEnabled1());
    }

    @FXML
    private void expansion0x6000() {
        this.getFirstFloppy().setRamExpansion(2, this.util.getConfig().getC1541Section().isRamExpansionEnabled2());
    }

    @FXML
    private void expansion0x8000() {
        this.getFirstFloppy().setRamExpansion(3, this.util.getConfig().getC1541Section().isRamExpansionEnabled3());
    }

    @FXML
    private void expansion0xA000() {
        this.getFirstFloppy().setRamExpansion(4, this.util.getConfig().getC1541Section().isRamExpansionEnabled4());
    }

    @FXML
    private void insertDisk() {
        FileChooser fileDialog = new FileChooser();
        fileDialog.setInitialDirectory(this.util.getConfig().getSidplay2Section().getLastDirectoryFolder());
        fileDialog.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Disk Image (D64, G64, NIB, GZ or ZIP)", DiskFileExtensions.EXTENSIONS));
        fileDialog.setTitle(this.util.getBundle().getString("INSERT_DISK"));
        File file = fileDialog.showOpenDialog(this.scene.getWindow());
        if (file != null) {
            try {
                this.util.getPlayer().insertDisk(file);
            }
            catch (IOException | SidTuneError e) {
                System.err.println(String.format("Cannot insert media file '%s'.", file.getAbsolutePath()));
            }
        }
    }

    @FXML
    private void ejectDisk() {
        try {
            this.getFirstFloppy().getDiskController().ejectDisk();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    @FXML
    private void resetDrive() {
        this.getFirstFloppy().reset();
    }

    @FXML
    private void insertEmptyDisk() {
        FileChooser fileDialog = new FileChooser();
        fileDialog.setInitialDirectory(this.util.getConfig().getSidplay2Section().getLastDirectoryFolder());
        fileDialog.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Disk Image (D64)", new String[]{"*.d64"}));
        fileDialog.setTitle(this.util.getBundle().getString("INSERT_EMPTY_DISK"));
        File file = fileDialog.showSaveDialog(this.scene.getWindow());
        if (file != null) {
            this.util.getConfig().getSidplay2Section().setLastDirectory(file.getParent());
            File target = new File(file.getParentFile(), PathUtils.getFilenameWithoutSuffix(file.getName()) + ".d64");
            try (DataOutputStream os = new DataOutputStream(new FileOutputStream(target));){
                os.write(EMPTY_DISK);
            }
            catch (IOException e) {
                this.openErrorDialog(String.format(this.util.getBundle().getString("ERR_IO_WRITE_ERROR"), e.getMessage()));
            }
            this.video();
            try {
                this.util.getPlayer().insertDisk(target);
            }
            catch (IOException | SidTuneError e) {
                System.err.println(String.format("Cannot insert media file '%s'.", target.getAbsolutePath()));
            }
        }
    }

    @FXML
    private void printerOn() {
        this.util.getPlayer().enablePrinter(this.util.getConfig().getPrinterSection().isPrinterOn());
    }

    @FXML
    private void insertCartridge() {
        this.chooseCartridge(CartridgeType.CRT);
    }

    @FXML
    private void insertGeoRAM() {
        this.chooseCartridge(CartridgeType.GEORAM);
    }

    @FXML
    private void insertGeoRAM64() {
        this.insertCartridge(CartridgeType.GEORAM, 64);
    }

    @FXML
    private void insertGeoRAM128() {
        this.insertCartridge(CartridgeType.GEORAM, 128);
    }

    @FXML
    private void insertGeoRAM256() {
        this.insertCartridge(CartridgeType.GEORAM, 256);
    }

    @FXML
    private void insertGeoRAM512() {
        this.insertCartridge(CartridgeType.GEORAM, 512);
    }

    @FXML
    private void insertGeoRAM1024() {
        this.insertCartridge(CartridgeType.GEORAM, 1024);
    }

    @FXML
    private void insertGeoRAM2048() {
        this.insertCartridge(CartridgeType.GEORAM, 2048);
    }

    @FXML
    private void insertREU() {
        this.chooseCartridge(CartridgeType.REU);
    }

    @FXML
    private void insertREU128() {
        this.insertCartridge(CartridgeType.REU, 128);
    }

    @FXML
    private void insertREU256() {
        this.insertCartridge(CartridgeType.REU, 256);
    }

    @FXML
    private void insertREU512() {
        this.insertCartridge(CartridgeType.REU, 512);
    }

    @FXML
    private void insertREU2048() {
        this.insertCartridge(CartridgeType.REU, 2048);
    }

    @FXML
    private void insertREU16384() {
        this.insertCartridge(CartridgeType.REU, 16384);
    }

    @FXML
    private void ejectCartridge() {
        this.util.getPlayer().getC64().ejectCartridge();
        this.reset();
    }

    @FXML
    private void freezeCartridge() {
        this.util.getPlayer().getC64().getCartridge().freeze();
    }

    @FXML
    private void setAudio() {
        this.restart();
    }

    @FXML
    public void setDevice() {
        int deviceIndex = this.devicesBox.getSelectionModel().getSelectedIndex();
        this.util.getConfig().getAudioSection().setDevice(deviceIndex);
        this.restart();
    }

    @FXML
    private void setSampling() {
        this.restart();
    }

    @FXML
    private void setSamplingRate() {
        this.restart();
    }

    @FXML
    private void setEngine() {
        this.restart();
    }

    @FXML
    private void setSid6581() {
        this.restart();
    }

    @FXML
    private void setSid8580() {
        this.restart();
    }

    @FXML
    private void setHostname() {
        NetSIDDevConnection.getInstance().invalidate();
        this.restart();
    }

    @FXML
    private void setPort() {
        NetSIDDevConnection.getInstance().invalidate();
        this.restart();
    }

    @FXML
    private void doEnableSldb() {
        C64 c64 = this.util.getPlayer().getC64();
        EventScheduler ctx = c64.getEventScheduler();
        ctx.scheduleThreadSafe(new Event("Update Play Timer!"){

            @Override
            public void event() {
                JSidPlay2.this.util.getPlayer().getTimer().updateEnd();
            }
        });
    }

    @FXML
    private void doBrowse() {
        FileChooser fileDialog = new FileChooser();
        FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("MP3 file (*.mp3)", new String[]{"*.mp3"});
        fileDialog.getExtensionFilters().add((Object)extFilter);
        File file = fileDialog.showOpenDialog(this.scene.getWindow());
        if (file != null) {
            this.util.getConfig().getAudioSection().setMp3File(file.getAbsolutePath());
            this.restart();
        }
    }

    @FXML
    private void showVolume() {
        String OS = System.getProperty("os.name").toLowerCase();
        if (OS.indexOf("win") >= 0) {
            SidPlay2Section section = this.util.getConfig().getSidplay2Section();
            int x = section.getFrameX() + section.getFrameWidth() / 2;
            try {
                Runtime.getRuntime().exec("sndvol -f " + x);
            }
            catch (IOException e) {
                try {
                    Runtime.getRuntime().exec("sndvol32");
                }
                catch (IOException e1) {
                    String toolTip = "For Windows: sndvol or sndvol32 not found!";
                    this.volumeButton.setDisable(true);
                    this.volumeButton.setTooltip(new Tooltip(toolTip));
                    System.err.println(toolTip);
                }
            }
        } else if (OS.indexOf("nux") >= 0) {
            try {
                Runtime.getRuntime().exec("pavucontrol");
            }
            catch (IOException e2) {
                try {
                    Runtime.getRuntime().exec("kmix");
                }
                catch (IOException e3) {
                    String toolTip = "For Linux: pavucontrol(PulseAudio) or kmix(ALSA) not found!";
                    this.volumeButton.setDisable(true);
                    this.volumeButton.setTooltip(new Tooltip(toolTip));
                    System.err.println(toolTip);
                }
            }
        } else if (OS.indexOf("mac") >= 0) {
            String toolTip = "For OSX: N.Y.I!";
            this.volumeButton.setDisable(true);
            this.volumeButton.setTooltip(new Tooltip(toolTip));
            System.err.println(toolTip);
        }
    }

    @FXML
    private void video() {
        if (!this.tabAlreadyOpen("VIDEO")) {
            this.addTab(new Video(this, this.util.getPlayer()));
        }
    }

    @FXML
    private void oscilloscope() {
        if (!this.tabAlreadyOpen("OSCILLOSCOPE")) {
            this.addTab(new Oscilloscope(this, this.util.getPlayer()));
        }
    }

    @FXML
    private void hvsc() {
        if (!this.tabAlreadyOpen("HVSC")) {
            MusicCollection tab = new MusicCollection(this, this.util.getPlayer());
            tab.setType(MusicCollectionType.HVSC);
            this.addTab(tab);
        }
    }

    @FXML
    private void cgsc() {
        if (!this.tabAlreadyOpen("CGSC")) {
            MusicCollection tab = new MusicCollection(this, this.util.getPlayer());
            tab.setType(MusicCollectionType.CGSC);
            this.addTab(tab);
        }
    }

    @FXML
    private void hvmec() {
        if (!this.tabAlreadyOpen("HVMEC")) {
            DiskCollection tab = new DiskCollection(this, this.util.getPlayer());
            tab.setType(DiskCollectionType.HVMEC);
            this.addTab(tab);
        }
    }

    @FXML
    private void demos() {
        if (!this.tabAlreadyOpen("DEMOS")) {
            DiskCollection tab = new DiskCollection(this, this.util.getPlayer());
            tab.setType(DiskCollectionType.DEMOS);
            this.addTab(tab);
        }
    }

    @FXML
    private void mags() {
        if (!this.tabAlreadyOpen("MAGS")) {
            DiskCollection tab = new DiskCollection(this, this.util.getPlayer());
            tab.setType(DiskCollectionType.MAGS);
            this.addTab(tab);
        }
    }

    @FXML
    private void favorites() {
        if (!this.tabAlreadyOpen("FAVORITES")) {
            this.addTab(new Favorites(this, this.util.getPlayer()));
        }
    }

    @FXML
    private void gamebase() {
        if (!this.tabAlreadyOpen("GAMEBASE")) {
            this.addTab(new GameBase(this, this.util.getPlayer()));
        }
    }

    @FXML
    private void asm() {
        if (!this.tabAlreadyOpen("ASM")) {
            this.addTab(new Asm(this, this.util.getPlayer()));
        }
    }

    @FXML
    private void printer() {
        if (!this.tabAlreadyOpen("PRINTER")) {
            this.addTab(new Printer(this, this.util.getPlayer()));
        }
    }

    @FXML
    private void console() {
        if (!this.tabAlreadyOpen("CONSOLE")) {
            this.addTab(new Console(this, this.util.getPlayer()));
        }
    }

    @FXML
    private void sidDump() {
        if (!this.tabAlreadyOpen("SIDDUMP")) {
            this.addTab(new SidDump(this, this.util.getPlayer()));
        }
    }

    @FXML
    private void sidRegisters() {
        if (!this.tabAlreadyOpen("SIDREGISTERS")) {
            this.addTab(new SidReg(this, this.util.getPlayer()));
        }
    }

    @FXML
    private void disassembler() {
        if (!this.tabAlreadyOpen("DISASSEMBLER")) {
            this.addTab(new Disassembler(this, this.util.getPlayer()));
        }
    }

    @FXML
    private void csdb() {
        if (!this.tabAlreadyOpen(WebViewType.CSDB.name())) {
            WebView tab = new WebView(this, this.util.getPlayer());
            tab.setType(WebViewType.CSDB);
            this.addTab(tab);
        }
    }

    @FXML
    private void codebase64() {
        if (!this.tabAlreadyOpen(WebViewType.CODEBASE64.name())) {
            WebView tab = new WebView(this, this.util.getPlayer());
            tab.setType(WebViewType.CODEBASE64);
            this.addTab(tab);
        }
    }

    @FXML
    private void remixKweqOrg() {
        if (!this.tabAlreadyOpen(WebViewType.REMIX_KWED_ORG.name())) {
            WebView tab = new WebView(this, this.util.getPlayer());
            tab.setType(WebViewType.REMIX_KWED_ORG);
            this.addTab(tab);
        }
    }

    @FXML
    private void sidOth4Com() {
        if (!this.tabAlreadyOpen(WebViewType.SID_OTH4_COM.name())) {
            WebView tab = new WebView(this, this.util.getPlayer());
            tab.setType(WebViewType.SID_OTH4_COM);
            this.addTab(tab);
        }
    }

    @FXML
    private void c64() {
        if (!this.tabAlreadyOpen(WebViewType.C64_SK.name())) {
            WebView tab = new WebView(this, this.util.getPlayer());
            tab.setType(WebViewType.C64_SK);
            this.addTab(tab);
        }
    }

    @FXML
    private void forum64() {
        if (!this.tabAlreadyOpen(WebViewType.FORUM64_DE.name())) {
            WebView tab = new WebView(this, this.util.getPlayer());
            tab.setType(WebViewType.FORUM64_DE);
            this.addTab(tab);
        }
    }

    @FXML
    private void lemon64() {
        if (!this.tabAlreadyOpen(WebViewType.LEMON64_COM.name())) {
            WebView tab = new WebView(this, this.util.getPlayer());
            tab.setType(WebViewType.LEMON64_COM);
            this.addTab(tab);
        }
    }

    @FXML
    private void jsidplay2() {
        if (!this.tabAlreadyOpen(WebViewType.JSIDPLAY2.name())) {
            WebView tab = new WebView(this, this.util.getPlayer());
            tab.setType(WebViewType.JSIDPLAY2);
            this.addTab(tab);
        }
    }

    @FXML
    private void updateCheck() {
        new Update(this.util.getPlayer()).open();
    }

    @FXML
    private void about() {
        new About(this.util.getPlayer()).open();
    }

    private void addView(String id) {
        if ("VIDEO".equals(id)) {
            this.video();
        } else if ("ASM".equals(id)) {
            this.asm();
        } else if ("OSCILLOSCOPE".equals(id)) {
            this.oscilloscope();
        } else if ("HVSC".equals(id)) {
            this.hvsc();
        } else if ("CGSC".equals(id)) {
            this.cgsc();
        } else if ("HVMEC".equals(id)) {
            this.hvmec();
        } else if ("DEMOS".equals(id)) {
            this.demos();
        } else if ("MAGS".equals(id)) {
            this.mags();
        } else if ("GAMEBASE".equals(id)) {
            this.gamebase();
        } else if ("FAVORITES".equals(id)) {
            this.favorites();
        } else if ("PRINTER".equals(id)) {
            this.printer();
        } else if ("CONSOLE".equals(id)) {
            this.console();
        } else if ("SIDDUMP".equals(id)) {
            this.sidDump();
        } else if ("SIDREGISTERS".equals(id)) {
            this.sidRegisters();
        } else if ("DISASSEMBLER".equals(id)) {
            this.disassembler();
        } else if (WebViewType.CSDB.name().equals(id)) {
            this.csdb();
        } else if (WebViewType.CODEBASE64.name().equals(id)) {
            this.codebase64();
        } else if (WebViewType.REMIX_KWED_ORG.name().equals(id)) {
            this.remixKweqOrg();
        } else if (WebViewType.SID_OTH4_COM.name().equals(id)) {
            this.sidOth4Com();
        } else if (WebViewType.C64_SK.name().equals(id)) {
            this.c64();
        } else if (WebViewType.FORUM64_DE.name().equals(id)) {
            this.forum64();
        } else if (WebViewType.LEMON64_COM.name().equals(id)) {
            this.lemon64();
        } else if (WebViewType.JSIDPLAY2.name().equals(id)) {
            this.jsidplay2();
        }
    }

    private void updatePlayerButtons(PlayList playList) {
        this.pauseContinue.setSelected(false);
        this.normalSpeed.setSelected(true);
        this.previous.setDisable(!playList.hasPrevious());
        this.previous2.setDisable(this.previous.isDisable());
        this.next.setDisable(!playList.hasNext());
        this.next2.setDisable(this.next.isDisable());
        this.previous.setText(String.format(this.util.getBundle().getString("PREVIOUS2") + " (%d/%d)", playList.getPrevious(), playList.getLength()));
        this.previous2ToolTip.setText(this.previous.getText());
        this.next.setText(String.format(this.util.getBundle().getString("NEXT2") + " (%d/%d)", playList.getNext(), playList.getLength()));
        this.next2ToolTip.setText(this.next.getText());
    }

    private void addTab(Tab tab) {
        List<ViewEntity> views = this.util.getConfig().getViews();
        if (!views.stream().anyMatch(tool -> tool.getFxId().equals(tab.getId()))) {
            views.add(new ViewEntity(tab.getId()));
        }
        tab.setOnClosed(evt -> {
            this.close((UIPart)tab);
            views.removeIf(view -> view.getFxId().equals(tab.getId()));
        });
        this.tabbedPane.getTabs().add((Object)tab);
        this.tabbedPane.getSelectionModel().select((Object)tab);
    }

    private boolean tabAlreadyOpen(String fxId) {
        Optional<Tab> alreadyOpened = this.tabbedPane.getTabs().stream().filter(tab -> tab.getId().equals(fxId)).findFirst();
        if (alreadyOpened.isPresent()) {
            this.tabbedPane.getSelectionModel().select((Object)alreadyOpened.get());
        }
        return alreadyOpened.isPresent();
    }

    private void chooseCartridge(CartridgeType type) {
        FileChooser fileDialog = new FileChooser();
        fileDialog.setInitialDirectory(this.util.getConfig().getSidplay2Section().getLastDirectoryFolder());
        fileDialog.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("C64 Cartridges", CartFileExtensions.EXTENSIONS));
        fileDialog.setTitle(this.util.getBundle().getString("INSERT_CARTRIDGE"));
        File file = fileDialog.showOpenDialog(this.scene.getWindow());
        if (file != null) {
            try {
                this.util.getPlayer().insertCartridge(type, file);
                this.util.getPlayer().play(SidTune.RESET);
            }
            catch (IOException | SidTuneError e) {
                System.err.println(String.format("Cannot insert file '%s' as cartridge of type '%s'.", file.getAbsolutePath(), type.name()));
            }
        }
    }

    private void insertCartridge(CartridgeType type, int sizeKB) {
        try {
            this.util.getPlayer().insertCartridge(type, sizeKB);
            this.util.getPlayer().play(SidTune.RESET);
        }
        catch (IOException | SidTuneError ex) {
            System.err.println(String.format("Cannot insert cartridge of type '%s' and size '%d'KB.", type.name(), sizeKB));
        }
    }

    private void playTune(SidTune tune) {
        this.video();
        this.util.setPlayingTab(this.tabbedPane.getTabs().stream().filter(tab -> tab.getId().equals("VIDEO")).findFirst().get());
        this.util.getPlayer().play(tune);
    }

    private void playNextRandomHVSC() {
        SidPlay2Section sidPlay2Section = this.util.getConfig().getSidplay2Section();
        String rndPath = this.util.getPlayer().getSidDatabaseInfo(db -> db.getRandomPath(), null);
        if (rndPath != null) {
            File file = PathUtils.getFile(rndPath, sidPlay2Section.getHvscFile(), sidPlay2Section.getCgscFile());
            this.hvsc();
            this.util.setPlayingTab(this.tabbedPane.getTabs().stream().filter(tab -> tab.getId().equals("HVSC")).findFirst().get());
            try {
                this.util.getPlayer().play(SidTune.load(file));
            }
            catch (IOException | SidTuneError e) {
                this.openErrorDialog(String.format(this.util.getBundle().getString("ERR_IO_ERROR"), e.getMessage()));
            }
        }
    }

    protected void setStatusLine() {
        boolean motorOn;
        ReadOnlyObjectProperty<State> state = this.util.getPlayer().stateProperty();
        if (!((State)((Object)state.get())).equals((Object)State.PLAY) && !((State)((Object)state.get())).equals((Object)State.PAUSE)) {
            return;
        }
        C1541 c1541 = this.getFirstFloppy();
        boolean bl = motorOn = this.util.getConfig().getC1541Section().isDriveSoundOn() && c1541.getDiskController().isMotorOn();
        if (!this.oldMotorOn && motorOn) {
            MOTORSOUND_AUDIOCLIP.play();
        } else if (this.oldMotorOn && !motorOn) {
            MOTORSOUND_AUDIOCLIP.stop();
        }
        this.oldMotorOn = motorOn;
        int halfTrack = c1541.getDiskController().getHalfTrack();
        if (this.oldHalfTrack != halfTrack && motorOn) {
            TRACKSOUND_AUDIOCLIP.play();
        }
        this.oldHalfTrack = halfTrack;
        Datasette datasette = this.util.getPlayer().getDatasette();
        if (datasette.getMotor()) {
            this.progress.setProgress((double)datasette.getProgress());
        }
        StringBuilder line = new StringBuilder();
        line.append(this.determineVideoNorm());
        line.append(this.determineEmulation());
        line.append(this.determineChipModel());
        line.append((CharSequence)this.playerId);
        double tuneSpeed = this.util.getPlayer().getC64().determineTuneSpeed();
        if (tuneSpeed > 0.0) {
            line.append(String.format("%s: %.1fx, ", this.util.getBundle().getString("SPEED"), tuneSpeed));
        }
        line.append(this.determineSong());
        if (datasette.getMotor()) {
            line.append(String.format("%s: %03d, ", this.util.getBundle().getString("DATASETTE_COUNTER"), datasette.getCounter()));
        }
        if (c1541.getDiskController().isMotorOn()) {
            line.append(String.format("%s: %02d, ", this.util.getBundle().getString("FLOPPY_TRACK"), halfTrack >> 1));
        }
        line.append(String.format("%s: %s%s", this.util.getBundle().getString("TIME"), this.determinePlayTime(), this.determineSongLength()));
        this.status.setText(line.toString());
        this.status.setTooltip(this.playerinfos.length() > 0 ? this.statusTooltip : null);
        this.statusTooltip.setText(this.playerinfos.toString());
    }

    private String determineChipModel() {
        EmulationSection emulation = this.util.getConfig().getEmulationSection();
        StringBuilder line = new StringBuilder();
        ChipModel chipModel = ChipModel.getChipModel(emulation, this.util.getPlayer().getTune(), 0);
        line.append(String.format("%s", new Object[]{chipModel}));
        if (SidTune.isSIDUsed(emulation, this.util.getPlayer().getTune(), 1)) {
            ChipModel stereoModel = ChipModel.getChipModel(emulation, this.util.getPlayer().getTune(), 1);
            int dualSidBase = SidTune.getSIDAddress(emulation, this.util.getPlayer().getTune(), 1);
            line.append(String.format("+%s(at 0x%4x)", new Object[]{stereoModel, dualSidBase}));
            if (SidTune.isSIDUsed(emulation, this.util.getPlayer().getTune(), 2)) {
                ChipModel thirdModel = ChipModel.getChipModel(emulation, this.util.getPlayer().getTune(), 2);
                int thirdSidBase = SidTune.getSIDAddress(emulation, this.util.getPlayer().getTune(), 2);
                line.append(String.format("+%s(at 0x%4x)", new Object[]{thirdModel, thirdSidBase}));
            }
        }
        line.append(", ");
        return line.toString();
    }

    private String determineEmulation() {
        EmulationSection emulation = this.util.getConfig().getEmulationSection();
        StringBuilder line = new StringBuilder();
        switch (emulation.getEngine()) {
            case EMULATION: {
                line.append(String.format("%s", Emulation.getEmulation(emulation, this.util.getPlayer().getTune(), 0).name()));
                if (!SidTune.isSIDUsed(emulation, this.util.getPlayer().getTune(), 1)) break;
                String stereoEmulation = Emulation.getEmulation(emulation, this.util.getPlayer().getTune(), 1).name();
                line.append(String.format("+%s", stereoEmulation));
                if (!SidTune.isSIDUsed(emulation, this.util.getPlayer().getTune(), 2)) break;
                String thirdEmulation = Emulation.getEmulation(emulation, this.util.getPlayer().getTune(), 2).name();
                line.append(String.format("+%s", thirdEmulation));
                break;
            }
            case NETSID: 
            case HARDSID: {
                line.append(String.format("%s", emulation.getEngine().name()));
                if (!SidTune.isSIDUsed(emulation, this.util.getPlayer().getTune(), 1)) break;
                line.append(String.format("+%s", emulation.getEngine().name()));
                if (!SidTune.isSIDUsed(emulation, this.util.getPlayer().getTune(), 2)) break;
                line.append(String.format("+%s", emulation.getEngine().name()));
                break;
            }
        }
        line.append(", ");
        return line.toString();
    }

    private String determineVideoNorm() {
        return String.format("%s, ", CPUClock.getCPUClock(this.util.getConfig().getEmulationSection(), this.util.getPlayer().getTune()).name());
    }

    private String determineSong() {
        SidTuneInfo info;
        SidTune tune = this.util.getPlayer().getTune();
        if (tune != null && (info = tune.getInfo()).getSongs() > 1) {
            return String.format("%s: %d/%d, ", this.util.getBundle().getString("SONG"), info.getCurrentSong(), info.getSongs());
        }
        return "";
    }

    private String determinePlayTime() {
        int time = this.util.getPlayer().time();
        return String.format("%02d:%02d", time / 60 % 100, time % 60);
    }

    private String determineSongLength() {
        int songLength;
        SidTune tune = this.util.getPlayer().getTune();
        int n = songLength = tune != null ? this.util.getPlayer().getSidDatabaseInfo(db -> db.getSongLength(tune), 0) : 0;
        if (songLength > 0) {
            return String.format("/%02d:%02d", songLength / 60 % 100, songLength % 60);
        }
        return "";
    }

    private void createHardCopy(String format) {
        this.video();
        try {
            Video videoScreen = (Video)this.tabbedPane.getTabs().stream().filter(tab -> tab.getId().equals("VIDEO")).findFirst().get();
            Image vicImage = videoScreen.getVicImage();
            if (vicImage != null) {
                ImageIO.write((RenderedImage)SwingFXUtils.fromFXImage((Image)vicImage, null), format, new File(this.util.getConfig().getSidplay2Section().getTmpDir(), "screenshot" + ++this.hardcopyCounter + "." + format));
            } else {
                System.err.println("Screenshot not possible, there is currently no frame!");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private C1541 getFirstFloppy() {
        return this.util.getPlayer().getFloppies()[0];
    }

    private void restart() {
        if (!this.duringInitialization) {
            this.util.getPlayer().play(this.util.getPlayer().getTune());
        }
    }

    @Override
    public boolean isAllowed() {
        if (this.util.getConfig().getC1541Section().getExtendImagePolicy() == ExtendImagePolicy.EXTEND_ASK) {
            YesNoDialog dialog = new YesNoDialog(this.util.getPlayer());
            dialog.getStage().setTitle(this.util.getBundle().getString("EXTEND_DISK_IMAGE"));
            dialog.setText(this.util.getBundle().getString("EXTEND_DISK_IMAGE_TO_40_TRACKS"));
            dialog.open();
            return dialog.getConfirmed().get();
        }
        return this.util.getConfig().getC1541Section().getExtendImagePolicy() == ExtendImagePolicy.EXTEND_ACCESS;
    }

    @Override
    public String apply(SidTune tune) {
        String defaultName = "jsidplay2";
        if (tune == SidTune.RESET) {
            return new File(this.util.getConfig().getSidplay2Section().getTmpDir(), defaultName).getAbsolutePath();
        }
        SidTuneInfo info = tune.getInfo();
        Iterator<String> infos = info.getInfoString().iterator();
        String name = infos.hasNext() ? infos.next().replaceAll("[:\\\\/*?|<>]", "_") : defaultName;
        String filename = new File(this.util.getConfig().getSidplay2Section().getTmpDir(), PathUtils.getFilenameWithoutSuffix(name)).getAbsolutePath();
        if (info.getSongs() > 1) {
            filename = filename + String.format("-%02d", info.getCurrentSong());
        }
        return filename;
    }

    private void openErrorDialog(String msg) {
        AlertDialog alertDialog = new AlertDialog(this.util.getPlayer());
        alertDialog.getStage().setTitle(this.util.getBundle().getString("ALERT_TITLE"));
        alertDialog.setText(msg);
        alertDialog.setWait(true);
        alertDialog.open();
    }

    static {
        try (DataInputStream is = new DataInputStream(JSidPlay2.class.getResourceAsStream(NUVIE_PLAYER_PRG));
             DataInputStream is2 = new DataInputStream(JSidPlay2.class.getResourceAsStream(EMPTY_D64));){
            URL us = JSidPlay2Main.class.getResource("/" + JSidPlay2.class.getName().replace('.', '/') + ".class");
            Date date = new Date(us.openConnection().getLastModified());
            DATE = DateFormat.getDateInstance(2).format(date);
            URL us2 = JSidPlay2Main.class.getResource(NUVIE_PLAYER_PRG);
            NUVIE_PLAYER = new byte[us2.openConnection().getContentLength()];
            is.readFully(NUVIE_PLAYER);
            URL us3 = JSidPlay2Main.class.getResource(EMPTY_D64);
            EMPTY_DISK = new byte[us3.openConnection().getContentLength()];
            is2.readFully(EMPTY_DISK);
            MOTORSOUND_AUDIOCLIP.setCycleCount(-1);
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private class StateChangeListener
    implements ChangeListener<State> {
        private StateChangeListener() {
        }

        public void changed(ObservableValue<? extends State> observable, State oldValue, State newValue) {
            SidTune sidTune = JSidPlay2.this.util.getPlayer().getTune();
            Platform.runLater(() -> {
                JSidPlay2.this.nextFavoriteDisabledState.set(sidTune == SidTune.RESET || newValue == State.QUIT);
                if (newValue == State.START) {
                    boolean doNotSwitch;
                    this.setCurrentTrack(sidTune);
                    this.setPlayerIdAndInfos(sidTune);
                    JSidPlay2.this.updatePlayerButtons(JSidPlay2.this.util.getPlayer().getPlayList());
                    Tab selectedItem = (Tab)JSidPlay2.this.tabbedPane.getSelectionModel().getSelectedItem();
                    boolean bl = doNotSwitch = selectedItem != null && (MusicCollection.class.isAssignableFrom(selectedItem.getClass()) || Favorites.class.isAssignableFrom(selectedItem.getClass()));
                    if (sidTune == SidTune.RESET || sidTune.getInfo().getPlayAddr() == 0 && !doNotSwitch) {
                        JSidPlay2.this.video();
                    }
                } else if (newValue.equals((Object)State.END)) {
                    SidPlay2Section sidplay2Section = JSidPlay2.this.util.getConfig().getSidplay2Section();
                    PlaybackType pt = sidplay2Section.getPlaybackType();
                    if (!sidplay2Section.isLoop() && pt == PlaybackType.RANDOM_HVSC) {
                        JSidPlay2.this.playNextRandomHVSC();
                    }
                }
            });
        }

        private void setCurrentTrack(SidTune sidTune) {
            if (sidTune != SidTune.RESET) {
                JSidPlay2.this.tracks.setText(String.format("%2d/%2d", sidTune.getInfo().getCurrentSong(), sidTune.getInfo().getSongs()));
            } else {
                JSidPlay2.this.tracks.setText("");
            }
        }

        private void setPlayerIdAndInfos(SidTune sidTune) {
            block2: {
                Iterator<String> iterator;
                JSidPlay2.this.playerId.setLength(0);
                JSidPlay2.this.playerinfos.setLength(0);
                if (sidTune == SidTune.RESET || !(iterator = sidTune.identify().iterator()).hasNext()) break block2;
                String id = iterator.next();
                JSidPlay2.this.playerId.append(JSidPlay2.this.util.getBundle().getString("PLAYER_ID")).append(": ").append(id);
                SidIdInfo.PlayerInfoSection playerInfo = sidTune.getPlayerInfo(id);
                JSidPlay2.this.status.setUserData(null);
                if (playerInfo != null) {
                    JSidPlay2.this.playerinfos.append(playerInfo.toString()).append("\n");
                    JSidPlay2.this.status.setUserData((Object)playerInfo.getReference());
                }
                JSidPlay2.this.playerId.setLength(JSidPlay2.this.playerId.length() - (id.length() - Math.min(id.length(), 14)));
                if (id.length() > 14) {
                    JSidPlay2.this.playerId.append("...");
                }
                JSidPlay2.this.playerId.append(", ");
            }
        }
    }
}

