/*
 * Decompiled with CFR 0.152.
 */
package sidplay.player;

import libsidplay.common.Event;
import libsidplay.common.EventScheduler;
import libsidplay.config.IConfig;
import libsidplay.sidtune.MP3Tune;
import libsidplay.sidtune.SidTune;
import sidplay.Player;

public abstract class Timer {
    private Event startTimeEvent = new Event("Timer Start"){

        @Override
        public void event() throws InterruptedException {
            Timer.this.start();
        }
    };
    private Event endTimeEvent = new Event("Timer End"){

        @Override
        public void event() throws InterruptedException {
            Timer.this.end();
        }
    };
    private Event fadeInStartTimeEvent = new Event("Fade-in Start"){

        @Override
        public void event() throws InterruptedException {
            Timer.this.fadeInStart(Timer.this.fadeIn);
        }
    };
    private Event fadeOutStartTimeEvent = new Event("Fade-out Start"){

        @Override
        public void event() throws InterruptedException {
            Timer.this.fadeOutStart(Timer.this.fadeOut);
        }
    };
    private long start;
    private long end;
    private int fadeIn;
    private int fadeOut;
    private final Player player;

    public Timer(Player player) {
        this.player = player;
    }

    public final void setStart(int start) {
        this.start = start;
    }

    public final void reset() {
        IConfig config = this.player.getConfig();
        this.fadeIn = config.getSidplay2Section().getFadeInTime();
        this.fadeOut = config.getSidplay2Section().getFadeOutTime();
        this.schedule(this.start, this.startTimeEvent);
        if (this.fadeIn != 0) {
            this.schedule(this.start, this.fadeInStartTimeEvent);
        }
        this.updateEnd();
    }

    public final void updateEnd() {
        int songLength;
        IConfig config = this.player.getConfig();
        SidTune tune = this.player.getTune();
        this.cancel(this.endTimeEvent);
        if (this.fadeOut != 0) {
            this.cancel(this.fadeOutStartTimeEvent);
        }
        if (tune instanceof MP3Tune) {
            return;
        }
        if (tune != SidTune.RESET && config.getSidplay2Section().isEnableDatabase() && (songLength = this.player.getSidDatabaseInfo(db -> db.getSongLength(tune), 0).intValue()) > 0) {
            this.end = this.schedule(songLength, this.endTimeEvent);
            if (this.fadeOut != 0) {
                this.schedule(this.end - (long)this.fadeOut, this.fadeOutStartTimeEvent);
            }
            return;
        }
        this.end = config.getSidplay2Section().getDefaultPlayLength();
        if (this.end > 0L) {
            this.end = this.schedule(this.start + this.end, this.endTimeEvent);
            if (this.fadeOut != 0) {
                this.schedule(this.start + this.end - (long)this.fadeOut, this.fadeOutStartTimeEvent);
            }
        }
    }

    private long schedule(long seconds, Event event) {
        EventScheduler eventScheduler = this.player.getC64().getEventScheduler();
        double cyclesPerSecond = eventScheduler.getCyclesPerSecond();
        long absoluteCycles = (long)((double)seconds * cyclesPerSecond);
        if (absoluteCycles < eventScheduler.getTime(Event.Phase.PHI1)) {
            eventScheduler.scheduleAbsolute(event, 0L, Event.Phase.PHI1);
        } else {
            eventScheduler.scheduleAbsolute(event, absoluteCycles, Event.Phase.PHI1);
        }
        return seconds;
    }

    private void cancel(Event event) {
        this.player.getC64().getEventScheduler().cancel(event);
    }

    public final long getEnd() {
        return this.end;
    }

    public abstract void start();

    public abstract void end();

    public abstract void fadeInStart(int var1);

    public abstract void fadeOutStart(int var1);
}

