/*
 * Decompiled with CFR 0.152.
 */
package sidplay.player;

import libsidplay.config.IConfig;
import libsidplay.sidtune.SidTune;

public class PlayList {
    private IConfig config;
    private SidTune tune;
    private int first;
    private int length;
    private int current;
    private static final PlayList NONE;
    private static PlayList singleton;

    private PlayList() {
    }

    private PlayList(IConfig config, SidTune tune) {
        this.config = config;
        this.tune = tune;
        this.current = tune.getInfo().getSelectedSong();
        this.length = tune.getInfo().getSongs();
        this.first = this.current;
    }

    public static PlayList getInstance(IConfig config, SidTune tune) {
        if (tune == SidTune.RESET) {
            return NONE;
        }
        if (PlayList.singleton.tune != tune) {
            singleton = new PlayList(config, tune);
        }
        PlayList.singleton.tune.getInfo().setSelectedSong(PlayList.singleton.current);
        return singleton;
    }

    public int getCurrent() {
        return this.current;
    }

    public int getTrackNum() {
        int start = this.current - this.first + 1;
        return start < 1 ? start + this.length : start;
    }

    public int getLength() {
        return this.length;
    }

    public void next() {
        this.current = this.getNext();
    }

    public void previous() {
        this.current = this.getPrevious();
    }

    public void first() {
        this.current = this.first;
    }

    public void last() {
        int last = this.config.getSidplay2Section().isSingle() ? this.first : this.first - 1;
        this.current = last < 1 ? this.length : last;
    }

    public boolean hasPrevious() {
        return this.current != this.first;
    }

    public boolean hasNext() {
        return this.getNext() != this.first;
    }

    public int getPrevious() {
        int previous = this.config.getSidplay2Section().isSingle() ? this.current : this.current - 1;
        return previous < 1 ? this.length : previous;
    }

    public int getNext() {
        int next = this.config.getSidplay2Section().isSingle() ? this.current : this.current + 1;
        return next > this.length ? 1 : next;
    }

    static {
        singleton = NONE = new PlayList(){

            @Override
            public int getCurrent() {
                return 1;
            }

            @Override
            public int getTrackNum() {
                return 1;
            }

            @Override
            public int getNext() {
                return 1;
            }

            @Override
            public int getPrevious() {
                return 1;
            }

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public boolean hasPrevious() {
                return false;
            }

            @Override
            public int getLength() {
                return 1;
            }

            @Override
            public void first() {
            }

            @Override
            public void last() {
            }

            @Override
            public void next() {
            }

            @Override
            public void previous() {
            }
        };
    }
}

