/*
 * Decompiled with CFR 0.152.
 */
package sidplay.ini;

import libsidplay.config.ISidPlay2Section;
import sidplay.ini.IniDefaults;
import sidplay.ini.IniReader;
import sidplay.ini.IniSection;

public class IniSidplay2Section
extends IniSection
implements ISidPlay2Section {
    protected IniSidplay2Section(IniReader ini) {
        super(ini);
    }

    @Override
    public final int getVersion() {
        return this.iniReader.getPropertyInt("SIDPlay2", "Version", 20);
    }

    @Override
    public void setVersion(int version) {
        this.iniReader.setProperty("SIDPlay2", "Version", version);
    }

    @Override
    public final boolean isEnableDatabase() {
        return this.iniReader.getPropertyBool("SIDPlay2", "EnableDatabase", IniDefaults.DEFAULT_ENABLE_DATABASE);
    }

    @Override
    public final void setEnableDatabase(boolean enable) {
        this.iniReader.setProperty("SIDPlay2", "EnableDatabase", enable);
    }

    @Override
    public final int getDefaultPlayLength() {
        return this.iniReader.getPropertyTime("SIDPlay2", "Default Play Length", IniDefaults.DEFAULT_PLAY_LENGTH);
    }

    @Override
    public final void setDefaultPlayLength(int playLength) {
        this.iniReader.setProperty("SIDPlay2", "Default Play Length", String.format("%02d:%02d", playLength / 60, playLength % 60));
    }

    @Override
    public int getFadeInTime() {
        return this.iniReader.getPropertyTime("SIDPlay2", "Fade In Time", IniDefaults.DEFAULT_FADE_IN_TIME);
    }

    @Override
    public int getFadeOutTime() {
        return this.iniReader.getPropertyTime("SIDPlay2", "Fade Out Time", IniDefaults.DEFAULT_FADE_OUT_TIME);
    }

    @Override
    public boolean isLoop() {
        return this.iniReader.getPropertyBool("SIDPlay2", "Loop", IniDefaults.DEFAULT_LOOP);
    }

    @Override
    public void setLoop(boolean loop) {
        this.iniReader.setProperty("SIDPlay2", "Loop", loop);
    }

    @Override
    public final boolean isSingle() {
        return this.iniReader.getPropertyBool("SIDPlay2", "SingleTrack", IniDefaults.DEFAULT_SINGLE_TRACK);
    }

    @Override
    public final void setSingle(boolean singleSong) {
        this.iniReader.setProperty("SIDPlay2", "SingleTrack", singleSong);
    }

    @Override
    public final String getHvsc() {
        return this.iniReader.getPropertyString("SIDPlay2", "HVSC Dir", IniDefaults.DEFAULT_HVSC_DIR);
    }

    @Override
    public final void setHvsc(String hvsc) {
        this.iniReader.setProperty("SIDPlay2", "HVSC Dir", hvsc);
    }

    @Override
    public final String getLastDirectory() {
        return this.iniReader.getPropertyString("SIDPlay2", "Last Directory", IniDefaults.DEFAULT_LAST_DIR);
    }

    @Override
    public final void setLastDirectory(String lastDir) {
        this.iniReader.setProperty("SIDPlay2", "Last Directory", lastDir);
    }

    @Override
    public final String getTmpDir() {
        return this.iniReader.getPropertyString("SIDPlay2", "Temp Dir", System.getProperty("user.home") + System.getProperty("file.separator") + ".jsidplay2");
    }

    @Override
    public final void setTmpDir(String path) {
        this.iniReader.setProperty("SIDPlay2", "Temp Dir", path);
    }

    @Override
    public float getBrightness() {
        return this.iniReader.getPropertyFloat("SIDPlay2", "Brightness", IniDefaults.DEFAULT_BRIGHTNESS);
    }

    @Override
    public void setBrightness(float brightness) {
        this.iniReader.setProperty("SIDPlay2", "Brightness", Float.valueOf(brightness));
    }

    @Override
    public float getContrast() {
        return this.iniReader.getPropertyFloat("SIDPlay2", "Contrast", IniDefaults.DEFAULT_CONTRAST);
    }

    @Override
    public void setContrast(float contrast) {
        this.iniReader.setProperty("SIDPlay2", "Contrast", Float.valueOf(contrast));
    }

    @Override
    public float getGamma() {
        return this.iniReader.getPropertyFloat("SIDPlay2", "Gamma", IniDefaults.DEFAULT_GAMMA);
    }

    @Override
    public void setGamma(float gamma) {
        this.iniReader.setProperty("SIDPlay2", "Gamma", Float.valueOf(gamma));
    }

    @Override
    public float getSaturation() {
        return this.iniReader.getPropertyFloat("SIDPlay2", "Saturation", IniDefaults.DEFAULT_SATURATION);
    }

    @Override
    public void setSaturation(float saturation) {
        this.iniReader.setProperty("SIDPlay2", "Saturation", Float.valueOf(saturation));
    }

    @Override
    public float getPhaseShift() {
        return this.iniReader.getPropertyFloat("SIDPlay2", "Phase Shift", IniDefaults.DEFAULT_PHASE_SHIFT);
    }

    @Override
    public void setPhaseShift(float phaseShift) {
        this.iniReader.setProperty("SIDPlay2", "Phase Shift", Float.valueOf(phaseShift));
    }

    @Override
    public float getOffset() {
        return this.iniReader.getPropertyFloat("SIDPlay2", "Offset", IniDefaults.DEFAULT_OFFSET);
    }

    @Override
    public void setOffset(float offset) {
        this.iniReader.setProperty("SIDPlay2", "Offset", Float.valueOf(offset));
    }

    @Override
    public float getTint() {
        return this.iniReader.getPropertyFloat("SIDPlay2", "Tint", IniDefaults.DEFAULT_TINT);
    }

    @Override
    public void setTint(float tint) {
        this.iniReader.setProperty("SIDPlay2", "Tint", Float.valueOf(tint));
    }

    @Override
    public float getBlur() {
        return this.iniReader.getPropertyFloat("SIDPlay2", "Blur", IniDefaults.DEFAULT_BLUR);
    }

    @Override
    public void setBlur(float blur) {
        this.iniReader.setProperty("SIDPlay2", "Blur", Float.valueOf(blur));
    }

    @Override
    public float getBleed() {
        return this.iniReader.getPropertyFloat("SIDPlay2", "Bleed", IniDefaults.DEFAULT_BLEED);
    }

    @Override
    public void setBleed(float bleed) {
        this.iniReader.setProperty("SIDPlay2", "Bleed", Float.valueOf(bleed));
    }

    @Override
    public boolean isTurboTape() {
        return this.iniReader.getPropertyBool("SIDPlay2", "TurboTape", IniDefaults.DEFAULT_TURBO_TAPE);
    }

    @Override
    public void setTurboTape(boolean turboTape) {
        this.iniReader.setProperty("SIDPlay2", "TurboTape", turboTape);
    }
}

