/*
 * Decompiled with CFR 0.152.
 */
package sidplay.ini;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import libsidutils.siddatabase.TimeConverter;

public class IniReader {
    private static final Pattern COMMENT = Pattern.compile("[;#].*");
    private static final Pattern SECTION_HEADING = Pattern.compile("\\[(\\w+)\\]");
    private static final Pattern KEY_VALUE = Pattern.compile("(\\w+(?:\\s+\\w+)*)\\s*=\\s*(.*)");
    private final Map<String, Map<String, String>> sections = new LinkedHashMap<String, Map<String, String>>();
    private boolean dirty;

    public boolean isDirty() {
        return this.dirty;
    }

    public IniReader(String pathname) throws IOException {
        this(new FileReader(pathname));
    }

    public IniReader(InputStream input) throws IOException {
        this(new InputStreamReader(input));
    }

    public IniReader(Reader input) throws IOException {
        this.initialize(new BufferedReader(input));
    }

    public String[] listSections() {
        return this.sections.keySet().toArray(new String[0]);
    }

    public String[] sectionProperties(String section) {
        Map<String, String> properties = this.sections.get(section);
        return properties.keySet().toArray(new String[0]);
    }

    private void initialize(BufferedReader r) throws IOException {
        String line;
        LinkedHashMap<String, String> section = null;
        StringBuilder comment = new StringBuilder();
        while ((line = r.readLine()) != null) {
            if ((line = line.trim()).isEmpty()) continue;
            Matcher m = COMMENT.matcher(line);
            if (m.matches()) {
                comment.append(line);
                comment.append(System.getProperty("line.separator"));
                continue;
            }
            m = SECTION_HEADING.matcher(line);
            if (m.matches()) {
                section = new LinkedHashMap<String, String>();
                this.sections.put(m.group(1), section);
                if (comment.length() == 0) continue;
                section.put("_", comment.toString());
                comment.delete(0, comment.length());
                continue;
            }
            assert (section != null);
            m = KEY_VALUE.matcher(line);
            if (m.matches()) {
                String key = m.group(1);
                section.put(key, m.group(2));
                if (comment.length() == 0) continue;
                section.put("_" + key, comment.toString());
                comment.delete(0, comment.length());
                continue;
            }
            throw new RuntimeException(String.format("Unrecognized line in ini config: %s", line));
        }
    }

    public void save(String outputname) throws IOException {
        try (PrintWriter wr = new PrintWriter(new File(outputname));){
            for (String section : this.sections.keySet()) {
                Map<String, String> unsaved = this.sections.get(section);
                if (unsaved.isEmpty()) continue;
                if (unsaved.containsKey("_")) {
                    wr.print(unsaved.get("_"));
                }
                if (section.length() <= 0) continue;
                wr.println("[" + section + "]");
                for (String key : unsaved.keySet()) {
                    if (key.startsWith("_")) continue;
                    if (unsaved.containsKey("_" + key)) {
                        wr.print(unsaved.get("_" + key));
                    }
                    wr.println(key + "=" + unsaved.get(key));
                }
                wr.println("");
            }
        }
        this.dirty = false;
    }

    public String getPropertyString(String section, String key, String defaultValue) {
        String value;
        Map<String, String> map = this.sections.get(section);
        if (map != null && (value = map.get(key)) != null && value.length() > 0) {
            return value;
        }
        return defaultValue;
    }

    public float getPropertyFloat(String section, String key, float defaultValue) {
        String s = this.getPropertyString(section, key, null);
        if (s != null) {
            return Float.parseFloat(s);
        }
        return defaultValue;
    }

    public int getPropertyInt(String section, String key, int defaultValue) {
        String s = this.getPropertyString(section, key, null);
        if (s != null && !s.equals("")) {
            return Integer.decode(s);
        }
        return defaultValue;
    }

    public boolean getPropertyBool(String section, String key, boolean defaultValue) {
        String s = this.getPropertyString(section, key, null);
        if (s != null) {
            return Boolean.valueOf(s);
        }
        return defaultValue;
    }

    public char getPropertyChar(String section, String key, char defaultValue) {
        String s = this.getPropertyString(section, key, null);
        if (s != null && s.length() > 2 && s.charAt(0) == '\'' && s.charAt(s.length() - 1) == '\'') {
            return s.substring(1, s.length() - 1).toCharArray()[0];
        }
        return defaultValue;
    }

    public int getPropertyTime(String section, String key, int defaultValue) {
        String s = this.getPropertyString(section, key, null);
        if (s != null) {
            return this.parseTime(s);
        }
        return defaultValue;
    }

    public <T extends Enum<T>> T getPropertyEnum(String section, String key, T defaultValue, Class<?> class1) {
        String s = this.getPropertyString(section, key, null);
        if (s != null) {
            try {
                Method m = class1.getMethod("valueOf", String.class);
                Enum value = (Enum)m.invoke(null, s.toUpperCase(Locale.US));
                return (T)value;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return defaultValue;
    }

    public void setProperty(String section, String key, Object value) {
        Map<String, String> settings = this.sections.get(section);
        if (settings == null) {
            settings = new HashMap<String, String>();
            this.sections.put(section, settings);
        }
        String newValue = value instanceof Character ? "'" + value + "'" : (value instanceof Enum ? ((Enum)value).name() : String.valueOf(value));
        String oldValue = null;
        if (settings.containsKey(key)) {
            oldValue = settings.get(key);
        }
        if (value == null) {
            settings.put(key, "");
            if (oldValue != null && !"".equals(oldValue)) {
                this.dirty = true;
            }
        } else {
            settings.put(key, newValue);
            if (!newValue.equals(oldValue)) {
                this.dirty = true;
            }
        }
    }

    private int parseTime(String time) {
        int seconds = new TimeConverter().fromString(time);
        if (seconds == -1) {
            System.err.println("Invalid time, expected mm:ss (found " + time + ")");
        }
        return seconds;
    }
}

