/*
 * Decompiled with CFR 0.152.
 */
package sidplay.ini;

import libsidplay.common.CPUClock;
import libsidplay.common.ChipModel;
import libsidplay.common.Emulation;
import libsidplay.common.Engine;
import libsidplay.config.IEmulationSection;
import sidplay.ini.IniDefaults;
import sidplay.ini.IniReader;
import sidplay.ini.IniSection;

public class IniEmulationSection
extends IniSection
implements IEmulationSection {
    protected IniEmulationSection(IniReader iniReader) {
        super(iniReader);
    }

    @Override
    public Engine getEngine() {
        return this.iniReader.getPropertyEnum("Emulation", "Engine", IniDefaults.DEFAULT_ENGINE, Engine.class);
    }

    @Override
    public void setEngine(Engine engine) {
        this.iniReader.setProperty("Emulation", "Engine", (Object)engine);
    }

    @Override
    public Emulation getDefaultEmulation() {
        return this.iniReader.getPropertyEnum("Emulation", "DefaultEmulation", IniDefaults.DEFAULT_EMULATION, Emulation.class);
    }

    @Override
    public void setDefaultEmulation(Emulation emulation) {
        this.iniReader.setProperty("Emulation", "DefaultEmulation", (Object)emulation);
    }

    @Override
    public final Emulation getUserEmulation() {
        return this.iniReader.getPropertyEnum("Emulation", "UserEmulation", IniDefaults.DEFAULT_USER_EMULATION, Emulation.class);
    }

    @Override
    public final void setUserEmulation(Emulation emulation) {
        this.iniReader.setProperty("Emulation", "UserEmulation", (Object)emulation);
    }

    @Override
    public final Emulation getStereoEmulation() {
        return this.iniReader.getPropertyEnum("Emulation", "StereoEmulation", IniDefaults.DEFAULT_STEREO_EMULATION, Emulation.class);
    }

    @Override
    public final void setStereoEmulation(Emulation model) {
        this.iniReader.setProperty("Emulation", "StereoEmulation", (Object)model);
    }

    @Override
    public final Emulation getThirdEmulation() {
        return this.iniReader.getPropertyEnum("Emulation", "3rdEmulation", IniDefaults.DEFAULT_3SID_EMULATION, Emulation.class);
    }

    @Override
    public final void setThirdEmulation(Emulation emulation) {
        this.iniReader.setProperty("Emulation", "3rdEmulation", (Object)emulation);
    }

    @Override
    public final CPUClock getDefaultClockSpeed() {
        return this.iniReader.getPropertyEnum("Emulation", "DefaultClockSpeed", IniDefaults.DEFAULT_CLOCK_SPEED, CPUClock.class);
    }

    @Override
    public final void setDefaultClockSpeed(CPUClock speed) {
        this.iniReader.setProperty("Emulation", "DefaultClockSpeed", (Object)speed);
    }

    @Override
    public final CPUClock getUserClockSpeed() {
        return this.iniReader.getPropertyEnum("Emulation", "UserClockSpeed", IniDefaults.DEFAULT_USER_CLOCK_SPEED, CPUClock.class);
    }

    @Override
    public final void setUserClockSpeed(CPUClock speed) {
        this.iniReader.setProperty("Emulation", "UserClockSpeed", (Object)speed);
    }

    @Override
    public final ChipModel getDefaultSidModel() {
        return this.iniReader.getPropertyEnum("Emulation", "DefaultSidModel", IniDefaults.DEFAULT_SID_MODEL, ChipModel.class);
    }

    @Override
    public final void setDefaultSidModel(ChipModel model) {
        this.iniReader.setProperty("Emulation", "DefaultSidModel", (Object)model);
    }

    @Override
    public final ChipModel getUserSidModel() {
        return this.iniReader.getPropertyEnum("Emulation", "UserSidModel", IniDefaults.DEFAULT_USER_MODEL, ChipModel.class);
    }

    @Override
    public final void setUserSidModel(ChipModel model) {
        this.iniReader.setProperty("Emulation", "UserSidModel", (Object)model);
    }

    @Override
    public final ChipModel getStereoSidModel() {
        return this.iniReader.getPropertyEnum("Emulation", "StereoSidModel", IniDefaults.DEFAULT_STEREO_MODEL, ChipModel.class);
    }

    @Override
    public final void setStereoSidModel(ChipModel model) {
        this.iniReader.setProperty("Emulation", "StereoSidModel", (Object)model);
    }

    @Override
    public final ChipModel getThirdSIDModel() {
        return this.iniReader.getPropertyEnum("Emulation", "3rdSIDModel", IniDefaults.DEFAULT_3SID_MODEL, ChipModel.class);
    }

    @Override
    public final void setThirdSIDModel(ChipModel model) {
        this.iniReader.setProperty("Emulation", "3rdSIDModel", (Object)model);
    }

    @Override
    public final int getHardsid6581() {
        return this.iniReader.getPropertyInt("Emulation", "HardSID6581", IniDefaults.DEFAULT_HARD_SID_6581);
    }

    @Override
    public final void setHardsid6581(int chip) {
        this.iniReader.setProperty("Emulation", "HardSID6581", chip);
    }

    @Override
    public final int getHardsid8580() {
        return this.iniReader.getPropertyInt("Emulation", "HardSID8580", IniDefaults.DEFAULT_HARD_SID_8580);
    }

    @Override
    public final void setHardsid8580(int chip) {
        this.iniReader.setProperty("Emulation", "HardSID8580", chip);
    }

    @Override
    public String getNetSIDDevHost() {
        return this.iniReader.getPropertyString("Emulation", "NetSIDDev Host", IniDefaults.DEFAULT_NETSIDDEV_HOST);
    }

    @Override
    public void setNetSIDDevHost(String hostname) {
        this.iniReader.setProperty("Emulation", "NetSIDDev Host", hostname);
    }

    @Override
    public int getNetSIDDevPort() {
        return this.iniReader.getPropertyInt("Emulation", "NetSIDDev Port", IniDefaults.DEFAULT_NETSIDDEV_PORT);
    }

    @Override
    public void setNetSIDDevPort(int port) {
        this.iniReader.setProperty("Emulation", "NetSIDDev Port", port);
    }

    @Override
    public final boolean isFilter() {
        return this.iniReader.getPropertyBool("Emulation", "UseFilter", IniDefaults.DEFAULT_USE_FILTER);
    }

    @Override
    public final void setFilter(boolean enable) {
        this.iniReader.setProperty("Emulation", "UseFilter", enable);
    }

    @Override
    public final boolean isStereoFilter() {
        return this.iniReader.getPropertyBool("Emulation", "UseStereoFilter", IniDefaults.DEFAULT_USE_STEREO_FILTER);
    }

    @Override
    public final void setStereoFilter(boolean enable) {
        this.iniReader.setProperty("Emulation", "UseStereoFilter", enable);
    }

    @Override
    public final boolean isThirdSIDFilter() {
        return this.iniReader.getPropertyBool("Emulation", "Use3rdSIDFilter", IniDefaults.DEFAULT_USE_3SID_FILTER);
    }

    @Override
    public final void setThirdSIDFilter(boolean enable) {
        this.iniReader.setProperty("Emulation", "Use3rdSIDFilter", enable);
    }

    @Override
    public int getSidNumToRead() {
        return this.iniReader.getPropertyInt("Emulation", "SidNumToRead", IniDefaults.DEFAULT_SID_NUM_TO_READ);
    }

    @Override
    public void setSidNumToRead(int sidNumToRead) {
        this.iniReader.setProperty("Emulation", "SidNumToRead", sidNumToRead);
    }

    @Override
    public final boolean isDigiBoosted8580() {
        return this.iniReader.getPropertyBool("Emulation", "DigiBoosted8580", IniDefaults.DEFAULT_DIGI_BOOSTED_8580);
    }

    @Override
    public final void setDigiBoosted8580(boolean boost) {
        this.iniReader.setProperty("Emulation", "DigiBoosted8580", boost);
    }

    @Override
    public final int getDualSidBase() {
        return this.iniReader.getPropertyInt("Emulation", "dualSidBase", IniDefaults.DEFAULT_DUAL_SID_BASE);
    }

    @Override
    public final void setDualSidBase(int base) {
        this.iniReader.setProperty("Emulation", "dualSidBase", String.format("0x%04x", base));
    }

    @Override
    public final int getThirdSIDBase() {
        return this.iniReader.getPropertyInt("Emulation", "thirdSIDBase", IniDefaults.DEFAULT_THIRD_SID_BASE);
    }

    @Override
    public final void setThirdSIDBase(int base) {
        this.iniReader.setProperty("Emulation", "thirdSIDBase", String.format("0x%04x", base));
    }

    @Override
    public final boolean isFakeStereo() {
        return this.iniReader.getPropertyBool("Emulation", "fakeStereo", IniDefaults.DEFAULT_FAKE_STEREO);
    }

    @Override
    public final void setFakeStereo(boolean fakeStereo) {
        this.iniReader.setProperty("Emulation", "fakeStereo", fakeStereo);
    }

    @Override
    public final boolean isForceStereoTune() {
        return this.iniReader.getPropertyBool("Emulation", "forceStereoTune", IniDefaults.DEFAULT_FORCE_STEREO_TUNE);
    }

    @Override
    public final void setForceStereoTune(boolean force) {
        this.iniReader.setProperty("Emulation", "forceStereoTune", force);
    }

    @Override
    public final boolean isForce3SIDTune() {
        return this.iniReader.getPropertyBool("Emulation", "force3SIDTune", IniDefaults.DEFAULT_FORCE_3SID_TUNE);
    }

    @Override
    public final void setForce3SIDTune(boolean force) {
        this.iniReader.setProperty("Emulation", "force3SIDTune", force);
    }

    @Override
    public boolean isMuteVoice1() {
        return this.iniReader.getPropertyBool("Emulation", "muteVoice1", IniDefaults.DEFAULT_MUTE_VOICE1);
    }

    @Override
    public void setMuteVoice1(boolean mute) {
        this.iniReader.setProperty("Emulation", "muteVoice1", mute);
    }

    @Override
    public boolean isMuteVoice2() {
        return this.iniReader.getPropertyBool("Emulation", "muteVoice2", IniDefaults.DEFAULT_MUTE_VOICE2);
    }

    @Override
    public void setMuteVoice2(boolean mute) {
        this.iniReader.setProperty("Emulation", "muteVoice2", mute);
    }

    @Override
    public boolean isMuteVoice3() {
        return this.iniReader.getPropertyBool("Emulation", "muteVoice3", IniDefaults.DEFAULT_MUTE_VOICE3);
    }

    @Override
    public void setMuteVoice3(boolean mute) {
        this.iniReader.setProperty("Emulation", "muteVoice3", mute);
    }

    @Override
    public boolean isMuteVoice4() {
        return this.iniReader.getPropertyBool("Emulation", "muteVoice4", IniDefaults.DEFAULT_MUTE_VOICE4);
    }

    @Override
    public void setMuteVoice4(boolean mute) {
        this.iniReader.setProperty("Emulation", "muteVoice4", mute);
    }

    @Override
    public boolean isMuteStereoVoice1() {
        return this.iniReader.getPropertyBool("Emulation", "muteStereoVoice1", IniDefaults.DEFAULT_MUTE_STEREO_VOICE1);
    }

    @Override
    public void setMuteStereoVoice1(boolean mute) {
        this.iniReader.setProperty("Emulation", "muteStereoVoice1", mute);
    }

    @Override
    public boolean isMuteStereoVoice2() {
        return this.iniReader.getPropertyBool("Emulation", "muteStereoVoice2", IniDefaults.DEFAULT_MUTE_STEREO_VOICE2);
    }

    @Override
    public void setMuteStereoVoice2(boolean mute) {
        this.iniReader.setProperty("Emulation", "muteStereoVoice2", mute);
    }

    @Override
    public boolean isMuteStereoVoice3() {
        return this.iniReader.getPropertyBool("Emulation", "muteStereoVoice3", IniDefaults.DEFAULT_MUTE_STEREO_VOICE3);
    }

    @Override
    public void setMuteStereoVoice3(boolean mute) {
        this.iniReader.setProperty("Emulation", "muteStereoVoice3", mute);
    }

    @Override
    public boolean isMuteStereoVoice4() {
        return this.iniReader.getPropertyBool("Emulation", "muteStereoVoice4", IniDefaults.DEFAULT_MUTE_STEREO_VOICE4);
    }

    @Override
    public void setMuteStereoVoice4(boolean mute) {
        this.iniReader.setProperty("Emulation", "muteStereoVoice4", mute);
    }

    @Override
    public boolean isMuteThirdSIDVoice1() {
        return this.iniReader.getPropertyBool("Emulation", "muteThirdSIDVoice1", IniDefaults.DEFAULT_MUTE_THIRDSID_VOICE1);
    }

    @Override
    public void setMuteThirdSIDVoice1(boolean mute) {
        this.iniReader.setProperty("Emulation", "muteThirdSIDVoice1", mute);
    }

    @Override
    public boolean isMuteThirdSIDVoice2() {
        return this.iniReader.getPropertyBool("Emulation", "muteThirdSIDVoice2", IniDefaults.DEFAULT_MUTE_THIRDSID_VOICE2);
    }

    @Override
    public void setMuteThirdSIDVoice2(boolean mute) {
        this.iniReader.setProperty("Emulation", "muteThirdSIDVoice2", mute);
    }

    @Override
    public boolean isMuteThirdSIDVoice3() {
        return this.iniReader.getPropertyBool("Emulation", "muteThirdSIDVoice3", IniDefaults.DEFAULT_MUTE_THIRDSID_VOICE3);
    }

    @Override
    public void setMuteThirdSIDVoice3(boolean mute) {
        this.iniReader.setProperty("Emulation", "muteThirdSIDVoice3", mute);
    }

    @Override
    public boolean isMuteThirdSIDVoice4() {
        return this.iniReader.getPropertyBool("Emulation", "muteThirdSIDVoice4", IniDefaults.DEFAULT_MUTE_THIRDSID_VOICE4);
    }

    @Override
    public void setMuteThirdSIDVoice4(boolean mute) {
        this.iniReader.setProperty("Emulation", "muteThirdSIDVoice4", mute);
    }

    @Override
    public final String getNetSIDFilter6581() {
        return this.iniReader.getPropertyString("Emulation", "NetSID_Filter6581", IniDefaults.DEFAULT_NETSID_FILTER_6581);
    }

    @Override
    public final void setNetSIDFilter6581(String filterName) {
        this.iniReader.setProperty("Emulation", "NetSID_Filter6581", filterName);
    }

    @Override
    public final String getNetSIDStereoFilter6581() {
        return this.iniReader.getPropertyString("Emulation", "NetSID_Stereo_Filter6581", IniDefaults.DEFAULT_NETSID_STEREO_FILTER_6581);
    }

    @Override
    public final void setNetSIDStereoFilter6581(String filterName) {
        this.iniReader.setProperty("Emulation", "NetSID_Stereo_Filter6581", filterName);
    }

    @Override
    public final String getNetSIDThirdSIDFilter6581() {
        return this.iniReader.getPropertyString("Emulation", "NetSID_3rdSID_Filter6581", IniDefaults.DEFAULT_NETSID_3SID_FILTER_6581);
    }

    @Override
    public final void setNetSIDThirdSIDFilter6581(String filterName) {
        this.iniReader.setProperty("Emulation", "NetSID_3rdSID_Filter6581", filterName);
    }

    @Override
    public final String getNetSIDFilter8580() {
        return this.iniReader.getPropertyString("Emulation", "NetSID_Filter8580", IniDefaults.DEFAULT_NETSID_FILTER_8580);
    }

    @Override
    public final void setNetSIDFilter8580(String filterName) {
        this.iniReader.setProperty("Emulation", "NetSID_Filter8580", filterName);
    }

    @Override
    public final String getNetSIDStereoFilter8580() {
        return this.iniReader.getPropertyString("Emulation", "NetSID_Stereo_Filter8580", IniDefaults.DEFAULT_NETSID_STEREO_FILTER_8580);
    }

    @Override
    public final void setNetSIDStereoFilter8580(String filterName) {
        this.iniReader.setProperty("Emulation", "NetSID_Stereo_Filter8580", filterName);
    }

    @Override
    public final String getNetSIDThirdSIDFilter8580() {
        return this.iniReader.getPropertyString("Emulation", "NetSID_3rdSID_Filter8580", IniDefaults.DEFAULT_NETSID_3SID_FILTER_8580);
    }

    @Override
    public final void setNetSIDThirdSIDFilter8580(String filterName) {
        this.iniReader.setProperty("Emulation", "NetSID_3rdSID_Filter8580", filterName);
    }

    @Override
    public final String getFilter6581() {
        return this.iniReader.getPropertyString("Emulation", "Filter6581", IniDefaults.DEFAULT_FILTER_6581);
    }

    @Override
    public final void setFilter6581(String filterName) {
        this.iniReader.setProperty("Emulation", "Filter6581", filterName);
    }

    @Override
    public final String getStereoFilter6581() {
        return this.iniReader.getPropertyString("Emulation", "Stereo_Filter6581", IniDefaults.DEFAULT_STEREO_FILTER_6581);
    }

    @Override
    public final void setStereoFilter6581(String filterName) {
        this.iniReader.setProperty("Emulation", "Stereo_Filter6581", filterName);
    }

    @Override
    public final String getThirdSIDFilter6581() {
        return this.iniReader.getPropertyString("Emulation", "3rdSID_Filter6581", IniDefaults.DEFAULT_3SID_FILTER_6581);
    }

    @Override
    public final void setThirdSIDFilter6581(String filterName) {
        this.iniReader.setProperty("Emulation", "3rdSID_Filter6581", filterName);
    }

    @Override
    public final String getFilter8580() {
        return this.iniReader.getPropertyString("Emulation", "Filter8580", IniDefaults.DEFAULT_FILTER_8580);
    }

    @Override
    public final void setFilter8580(String filterName) {
        this.iniReader.setProperty("Emulation", "Filter8580", filterName);
    }

    @Override
    public final String getStereoFilter8580() {
        return this.iniReader.getPropertyString("Emulation", "Stereo_Filter8580", IniDefaults.DEFAULT_STEREO_FILTER_8580);
    }

    @Override
    public final void setStereoFilter8580(String filterName) {
        this.iniReader.setProperty("Emulation", "Stereo_Filter8580", filterName);
    }

    @Override
    public final String getThirdSIDFilter8580() {
        return this.iniReader.getPropertyString("Emulation", "3rdSID_Filter8580", IniDefaults.DEFAULT_3SID_FILTER_8580);
    }

    @Override
    public final void setThirdSIDFilter8580(String filterName) {
        this.iniReader.setProperty("Emulation", "3rdSID_Filter8580", filterName);
    }

    @Override
    public final String getReSIDfpFilter6581() {
        return this.iniReader.getPropertyString("Emulation", "ReSIDfp_Filter6581", IniDefaults.DEFAULT_ReSIDfp_FILTER_6581);
    }

    @Override
    public final void setReSIDfpFilter6581(String filterName) {
        this.iniReader.setProperty("Emulation", "ReSIDfp_Filter6581", filterName);
    }

    @Override
    public final String getReSIDfpStereoFilter6581() {
        return this.iniReader.getPropertyString("Emulation", "ReSIDfp_Stereo_Filter6581", IniDefaults.DEFAULT_ReSIDfp_STEREO_FILTER_6581);
    }

    @Override
    public final void setReSIDfpStereoFilter6581(String filterName) {
        this.iniReader.setProperty("Emulation", "ReSIDfp_Stereo_Filter6581", filterName);
    }

    @Override
    public final String getReSIDfpThirdSIDFilter6581() {
        return this.iniReader.getPropertyString("Emulation", "ReSIDfp_3rdSID_Filter6581", IniDefaults.DEFAULT_ReSIDfp_3SID_FILTER_6581);
    }

    @Override
    public final void setReSIDfpThirdSIDFilter6581(String filterName) {
        this.iniReader.setProperty("Emulation", "ReSIDfp_3rdSID_Filter6581", filterName);
    }

    @Override
    public final String getReSIDfpFilter8580() {
        return this.iniReader.getPropertyString("Emulation", "ReSIDfp_Filter8580", IniDefaults.DEFAULT_ReSIDfp_FILTER_8580);
    }

    @Override
    public final void setReSIDfpFilter8580(String filterName) {
        this.iniReader.setProperty("Emulation", "ReSIDfp_Filter8580", filterName);
    }

    @Override
    public final String getReSIDfpStereoFilter8580() {
        return this.iniReader.getPropertyString("Emulation", "ReSIDfp_Stereo_Filter8580", IniDefaults.DEFAULT_ReSIDfp_STEREO_FILTER_8580);
    }

    @Override
    public final void setReSIDfpStereoFilter8580(String filterName) {
        this.iniReader.setProperty("Emulation", "ReSIDfp_Stereo_Filter8580", filterName);
    }

    @Override
    public final String getReSIDfpThirdSIDFilter8580() {
        return this.iniReader.getPropertyString("Emulation", "ReSIDfp_3rdSID_Filter8580", IniDefaults.DEFAULT_ReSIDfp_3SID_FILTER_8580);
    }

    @Override
    public final void setReSIDfpThirdSIDFilter8580(String filterName) {
        this.iniReader.setProperty("Emulation", "ReSIDfp_3rdSID_Filter8580", filterName);
    }
}

