/*
 * Decompiled with CFR 0.152.
 */
package sidplay.ini;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.List;
import libsidplay.config.IAudioSection;
import libsidplay.config.IC1541Section;
import libsidplay.config.IConfig;
import libsidplay.config.IEmulationSection;
import libsidplay.config.IFilterSection;
import libsidplay.config.IPrinterSection;
import libsidplay.config.ISidPlay2Section;
import sidplay.ini.IniAudioSection;
import sidplay.ini.IniC1541Section;
import sidplay.ini.IniConsoleSection;
import sidplay.ini.IniEmulationSection;
import sidplay.ini.IniFilterSection;
import sidplay.ini.IniPrinterSection;
import sidplay.ini.IniReader;
import sidplay.ini.IniSidplay2Section;

public class IniConfig
implements IConfig {
    private static final String FILE_NAME = "sidplay2.ini";
    private static IniConfig singleInstance;
    private final File iniPath;
    private ISidPlay2Section sidplay2Section;
    private IC1541Section c1541Section;
    private IPrinterSection printerSection;
    private IniConsoleSection consoleSection;
    private IAudioSection audioSection;
    private IEmulationSection emulationSection;
    protected IniReader iniReader;

    private void clear() {
        this.sidplay2Section = new IniSidplay2Section(this.iniReader);
        this.c1541Section = new IniC1541Section(this.iniReader);
        this.printerSection = new IniPrinterSection(this.iniReader);
        this.consoleSection = new IniConsoleSection(this.iniReader);
        this.audioSection = new IniAudioSection(this.iniReader);
        this.emulationSection = new IniEmulationSection(this.iniReader);
    }

    @Override
    public List<? extends IFilterSection> getFilterSection() {
        ArrayList<IniFilterSection> filters = new ArrayList<IniFilterSection>();
        for (String heading : this.iniReader.listSections()) {
            if (!heading.matches("Filter.*")) continue;
            filters.add(new IniFilterSection(this.iniReader, heading));
        }
        return filters;
    }

    public static IniConfig getDefault() {
        if (singleInstance == null) {
            singleInstance = new IniConfig(false, null);
        }
        return singleInstance;
    }

    public IniConfig() {
        this(false, IniConfig.getINIPath(false));
    }

    public IniConfig(boolean createIfNotExists) {
        this(createIfNotExists, IniConfig.getINIPath(createIfNotExists));
    }

    public IniConfig(boolean createIfNotExists, File iniPath) {
        this.iniPath = iniPath;
        if (iniPath != null) {
            if (iniPath.exists()) {
                try (FileInputStream is = new FileInputStream(iniPath);){
                    this.iniReader = new IniReader(is);
                    this.clear();
                    if (this.sidplay2Section.getVersion() == 20) {
                        System.out.println("Use INI file: " + iniPath);
                        return;
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                this.createINIBackup(iniPath);
            }
            System.out.println("Use internal INI file: sidplay2.ini");
        }
        this.readInternal();
        if (iniPath != null && !iniPath.exists() && createIfNotExists) {
            this.write();
        }
    }

    private static File getINIPath(boolean createIfNotExists) {
        try {
            File configPlace = null;
            for (String s : new String[]{System.getProperty("user.dir"), System.getProperty("user.home")}) {
                configPlace = new File(s, FILE_NAME);
                if (!configPlace.exists()) continue;
                return configPlace;
            }
            if (createIfNotExists) {
                return new File(System.getProperty("user.home"), FILE_NAME);
            }
            return configPlace;
        }
        catch (AccessControlException e) {
            return null;
        }
    }

    private void createINIBackup(File iniFile) {
        iniFile.renameTo(new File(iniFile.getParentFile(), "sidplay2.ini.bak"));
    }

    private void readInternal() {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream("sidplay/ini/sidplay2.ini");
        try {
            this.iniReader = new IniReader(is);
            this.clear();
            this.sidplay2Section.setVersion(20);
            is.close();
        }
        catch (IOException e) {
            return;
        }
    }

    public void write() {
        if (!this.iniReader.isDirty()) {
            return;
        }
        System.out.println("Save INI file: " + this.iniPath);
        try {
            this.iniReader.save(this.iniPath.getAbsolutePath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public final ISidPlay2Section getSidplay2Section() {
        return this.sidplay2Section;
    }

    @Override
    public final IC1541Section getC1541Section() {
        return this.c1541Section;
    }

    @Override
    public final IPrinterSection getPrinterSection() {
        return this.printerSection;
    }

    public final IniConsoleSection getConsoleSection() {
        return this.consoleSection;
    }

    @Override
    public final IAudioSection getAudioSection() {
        return this.audioSection;
    }

    @Override
    public final IEmulationSection getEmulationSection() {
        return this.emulationSection;
    }
}

