/*
 * Decompiled with CFR 0.152.
 */
package sidplay.consoleplayer;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.ResourceBundle;
import libsidplay.common.ChipModel;
import libsidplay.config.IEmulationSection;
import libsidplay.sidtune.SidTune;
import sidplay.Player;
import sidplay.ini.IniConfig;
import sidplay.ini.IniConsoleSection;
import sidplay.player.PlayList;
import sidplay.player.Timer;

public class ConsoleIO {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("sidplay.consoleplayer.ConsolePlayer");
    private IniConfig config;
    private String filename;
    private boolean v1mute;
    private boolean v2mute;
    private boolean v3mute;
    private boolean v4mute;
    private boolean v5mute;
    private boolean v6mute;
    private boolean v7mute;
    private boolean v8mute;
    private boolean v9mute;
    private boolean v10mute;
    private boolean v11mute;
    private boolean v12mute;

    public ConsoleIO(IniConfig config, String filename) {
        this.config = config;
        this.filename = filename;
    }

    public void menu(Player player, int verboseLevel, boolean quiet, PrintStream out) {
        if (quiet) {
            return;
        }
        IniConsoleSection console = this.config.getConsoleSection();
        SidTune tune = player.getTune();
        PlayList playList = player.getPlayList();
        Timer timer = player.getTimer();
        this.printTopLine(out, console);
        this.printHeading(out, console);
        this.printSeparatorLine(out, console);
        if (tune.getInfo().getInfoString().size() == 3) {
            this.printTitleAutorReleased(out, console, tune);
        } else {
            this.printDecription(out, console, tune);
        }
        if (tune.getInfo().getInfoString().size() > 0) {
            this.printSeparatorLine(out, console);
        }
        if (verboseLevel != 0) {
            this.printFileDetails(out, console, tune);
        }
        this.printPlaylist(out, console, tune, playList);
        if (verboseLevel > 0) {
            this.printHorizontalBottomLine(out, console);
            this.printSongSpeedCIAorVBI(out, console, tune, playList);
        }
        this.printSongLength(out, console, timer);
        if (verboseLevel > 0) {
            this.printHorizontalBottomLine(out, console);
            this.printAddresses(out, console, tune);
            this.printSIDDetails(out, console, tune);
        }
        this.printHorizontalBottomLine(out, console);
        this.printKeyboardControls(out);
    }

    private void printTopLine(PrintStream out, IniConsoleSection console) {
        out.printf("%c%s%c\n", Character.valueOf(console.getTopLeft()), this.setFill(console.getHorizontal(), 54), Character.valueOf(console.getTopRight()));
    }

    private void printHeading(PrintStream out, IniConsoleSection console) {
        out.printf("%c%52s  %c\n", Character.valueOf(console.getVertical()), BUNDLE.getString("HEADING"), Character.valueOf(console.getVertical()));
    }

    private void printSeparatorLine(PrintStream out, IniConsoleSection console) {
        out.printf("%c%s%c\n", Character.valueOf(console.getJunctionLeft()), this.setFill(console.getHorizontal(), 54), Character.valueOf(console.getJunctionRight()));
    }

    private void printTitleAutorReleased(PrintStream out, IniConsoleSection console, SidTune tune) {
        Iterator<String> description = tune.getInfo().getInfoString().iterator();
        out.printf("%c %-12s : %37s %c\n", Character.valueOf(console.getVertical()), BUNDLE.getString("TITLE"), description.next(), Character.valueOf(console.getVertical()));
        out.printf("%c %-12s : %37s %c\n", Character.valueOf(console.getVertical()), BUNDLE.getString("AUTHOR"), description.next(), Character.valueOf(console.getVertical()));
        out.printf("%c %-12s : %37s %c\n", Character.valueOf(console.getVertical()), BUNDLE.getString("RELEASED"), description.next(), Character.valueOf(console.getVertical()));
    }

    private void printDecription(PrintStream out, IniConsoleSection console, SidTune tune) {
        for (String description : tune.getInfo().getInfoString()) {
            out.printf("%c %-12s : %37s %c\n", Character.valueOf(console.getVertical()), BUNDLE.getString("DESCRIPTION"), description, Character.valueOf(console.getVertical()));
        }
    }

    private void printFileDetails(PrintStream out, IniConsoleSection console, SidTune tune) {
        out.printf("%c %-12s : %37s %c\n", Character.valueOf(console.getVertical()), BUNDLE.getString("FILE_FORMAT"), tune.getInfo().getClass().getSimpleName(), Character.valueOf(console.getVertical()));
        out.printf("%c %-12s : %37s %c\n", Character.valueOf(console.getVertical()), BUNDLE.getString("FILENAMES"), new File(this.filename).getName(), Character.valueOf(console.getVertical()));
    }

    private void printPlaylist(PrintStream out, IniConsoleSection console, SidTune tune, PlayList playList) {
        int trackNum = playList.getTrackNum();
        out.printf("%c %-12s : ", Character.valueOf(console.getVertical()), BUNDLE.getString("PLAYLIST"));
        StringBuffer trackList = new StringBuffer();
        trackList.append(trackNum).append("/").append(playList.getLength());
        trackList.append(" (tune ").append(tune.getInfo().getCurrentSong()).append("/").append(tune.getInfo().getSongs());
        trackList.append("[").append(tune.getInfo().getStartSong()).append("])");
        if (this.config.getSidplay2Section().isLoop()) {
            trackList.append(" [" + BUNDLE.getString("LOOPING") + "]");
        }
        out.printf("%37s %c\n", trackList.toString(), Character.valueOf(console.getVertical()));
    }

    private void printSongSpeedCIAorVBI(PrintStream out, IniConsoleSection console, SidTune tune, PlayList playList) {
        out.printf("%c %-12s : %37s %c\n", new Object[]{Character.valueOf(console.getVertical()), BUNDLE.getString("SONG_SPEED"), tune.getSongSpeed(playList.getCurrent()), Character.valueOf(console.getVertical())});
    }

    private void printSongLength(PrintStream out, IniConsoleSection console, Timer timer) {
        out.printf("%c %-12s : ", Character.valueOf(console.getVertical()), BUNDLE.getString("SONG_LENGTH"));
        if (timer.getEnd() != 0L) {
            String time = String.format("%02d:%02d", timer.getEnd() / 60L % 100L, timer.getEnd() % 60L);
            out.printf("%37s %c\n", time, Character.valueOf(console.getVertical()));
        } else {
            out.printf("%37s %c\n", BUNDLE.getString("UNLIMITED"), Character.valueOf(console.getVertical()));
        }
    }

    private void printHorizontalBottomLine(PrintStream out, IniConsoleSection console) {
        out.printf("%c%s%c\n", Character.valueOf(console.getBottomLeft()), this.setFill(console.getHorizontal(), 54), Character.valueOf(console.getBottomRight()));
    }

    private void printAddresses(PrintStream out, IniConsoleSection console, SidTune tune) {
        StringBuffer line = new StringBuffer();
        line.append(BUNDLE.getString("DRIVER_ADDR") + " = ");
        if (tune.getInfo().getDeterminedDriverAddr() == 0) {
            line.append(BUNDLE.getString("NOT_PRESENT"));
        } else {
            line.append(String.format("$%04x", tune.getInfo().getDeterminedDriverAddr()));
            line.append(String.format("-$%04x", tune.getInfo().getDeterminedDriverAddr() + tune.getInfo().getDeterminedDriverLength() - 1));
        }
        if (tune.getInfo().getPlayAddr() == 65535) {
            line.append(String.format(", " + BUNDLE.getString("SYS") + " = $%04x", tune.getInfo().getInitAddr()));
        } else {
            line.append(String.format(", " + BUNDLE.getString("INIT") + " = $%04x", tune.getInfo().getInitAddr()));
        }
        out.printf("%c %-12s : %37s %c\n", Character.valueOf(console.getVertical()), BUNDLE.getString("ADDRESSES"), line.toString(), Character.valueOf(console.getVertical()));
        line = new StringBuffer();
        line.append(String.format(BUNDLE.getString("LOAD") + " = $%04x", tune.getInfo().getLoadAddr()));
        line.append(String.format("-$%04x", tune.getInfo().getLoadAddr() + tune.getInfo().getC64dataLen() - 1));
        if (tune.getInfo().getPlayAddr() != 65535) {
            line.append(String.format(", %s = $%04x", BUNDLE.getString("PLAY"), tune.getInfo().getPlayAddr()));
        }
        out.printf("%c              : %37s %c\n", Character.valueOf(console.getVertical()), line.toString(), Character.valueOf(console.getVertical()));
    }

    private void printSIDDetails(PrintStream out, IniConsoleSection console, SidTune tune) {
        StringBuffer line = new StringBuffer();
        IEmulationSection emulation = this.config.getEmulationSection();
        line.append(BUNDLE.getString("FILTER") + (emulation.isFilter() ? " = on, " : " = off, "));
        ChipModel chipModel = ChipModel.getChipModel(emulation, tune, 0);
        line.append(String.format(BUNDLE.getString("MODEL") + " = %s", new Object[]{chipModel}));
        if (SidTune.isSIDUsed(emulation, tune, 1)) {
            ChipModel stereoModel = ChipModel.getChipModel(emulation, tune, 1);
            line.append(String.format("(%s)", new Object[]{stereoModel}));
        }
        out.printf("%c %-12s : %37s %c\n", Character.valueOf(console.getVertical()), BUNDLE.getString("SID_DETAILS"), line.toString(), Character.valueOf(console.getVertical()));
        if (SidTune.isSIDUsed(emulation, tune, 2)) {
            ChipModel thirdModel = ChipModel.getChipModel(emulation, tune, 2);
            line.setLength(0);
            line.append(String.format("(%s)", new Object[]{thirdModel}));
            out.printf("%c %-12s : %37s %c\n", Character.valueOf(console.getVertical()), BUNDLE.getString("SID_DETAILS"), line.toString(), Character.valueOf(console.getVertical()));
        }
    }

    private void printKeyboardControls(PrintStream out) {
        out.println(BUNDLE.getString("KEYBOARD_CONTROLS"));
        out.println(BUNDLE.getString("FORWARD_REWIND"));
        out.println(BUNDLE.getString("FIRST_LAST"));
        out.println(BUNDLE.getString("NORMAL_FAST"));
        out.println(BUNDLE.getString("PAUSE_CONTINUE"));
        out.println(BUNDLE.getString("MUTE_1"));
        out.println(BUNDLE.getString("MUTE_2"));
        out.println(BUNDLE.getString("MUTE_3"));
        out.println(BUNDLE.getString("MUTE_4"));
        out.println(BUNDLE.getString("MUTE_5"));
        out.println(BUNDLE.getString("MUTE_6"));
        out.println(BUNDLE.getString("MUTE_7"));
        out.println(BUNDLE.getString("MUTE_8"));
        out.println(BUNDLE.getString("MUTE_9"));
        out.println(BUNDLE.getString("MUTE_10"));
        out.println(BUNDLE.getString("MUTE_11"));
        out.println(BUNDLE.getString("MUTE_12"));
        out.println(BUNDLE.getString("FILTER_ENABLE"));
        out.println(BUNDLE.getString("STEREO_FILTER_ENABLE"));
        out.println(BUNDLE.getString("3RD_SID_FILTER_ENABLE"));
        out.println(BUNDLE.getString("QUIT"));
    }

    private String setFill(char ch, int length) {
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            ret.append(ch);
        }
        return ret.toString();
    }

    public void decodeKeys(Player player) {
        try {
            if (System.in.available() == 0) {
                return;
            }
            int key = System.in.read();
            IEmulationSection emulation = this.config.getEmulationSection();
            switch (key) {
                case 104: {
                    player.firstSong();
                    break;
                }
                case 101: {
                    player.lastSong();
                    break;
                }
                case 62: {
                    if (!player.getPlayList().hasNext()) break;
                    player.nextSong();
                    break;
                }
                case 60: {
                    if (!player.getPlayList().hasPrevious()) break;
                    player.previousSong();
                    break;
                }
                case 46: {
                    player.configureMixer(mixer -> mixer.fastForward());
                    break;
                }
                case 44: {
                    player.configureMixer(mixer -> mixer.normalSpeed());
                    break;
                }
                case 112: {
                    player.pauseContinue();
                    break;
                }
                case 49: {
                    this.v1mute = !this.v1mute;
                    player.configureSID(0, sid -> sid.setVoiceMute(0, this.v1mute));
                    break;
                }
                case 50: {
                    this.v2mute = !this.v2mute;
                    player.configureSID(0, sid -> sid.setVoiceMute(1, this.v2mute));
                    break;
                }
                case 51: {
                    this.v3mute = !this.v3mute;
                    player.configureSID(0, sid -> sid.setVoiceMute(2, this.v3mute));
                    break;
                }
                case 52: {
                    this.v4mute = !this.v4mute;
                    player.configureSID(0, sid -> sid.setVoiceMute(3, this.v4mute));
                    break;
                }
                case 53: {
                    this.v5mute = !this.v5mute;
                    player.configureSID(1, sid -> sid.setVoiceMute(0, this.v5mute));
                    break;
                }
                case 54: {
                    this.v6mute = !this.v6mute;
                    player.configureSID(1, sid -> sid.setVoiceMute(1, this.v6mute));
                    break;
                }
                case 55: {
                    this.v7mute = !this.v7mute;
                    player.configureSID(1, sid -> sid.setVoiceMute(2, this.v7mute));
                    break;
                }
                case 56: {
                    this.v8mute = !this.v8mute;
                    player.configureSID(1, sid -> sid.setVoiceMute(3, this.v8mute));
                    break;
                }
                case 57: {
                    this.v9mute = !this.v9mute;
                    player.configureSID(2, sid -> sid.setVoiceMute(0, this.v9mute));
                    break;
                }
                case 97: {
                    this.v10mute = !this.v10mute;
                    player.configureSID(2, sid -> sid.setVoiceMute(1, this.v10mute));
                    break;
                }
                case 98: {
                    this.v11mute = !this.v11mute;
                    player.configureSID(2, sid -> sid.setVoiceMute(2, this.v11mute));
                    break;
                }
                case 99: {
                    this.v12mute = !this.v12mute;
                    player.configureSID(2, sid -> sid.setVoiceMute(3, this.v12mute));
                    break;
                }
                case 102: {
                    boolean filterEnable = emulation.isFilter() ^ true;
                    emulation.setFilter(filterEnable);
                    player.configureSID(0, sid -> sid.setFilterEnable(emulation, 0));
                    break;
                }
                case 103: {
                    boolean filterEnable = emulation.isStereoFilter() ^ true;
                    emulation.setStereoFilter(filterEnable);
                    player.configureSID(1, sid -> sid.setFilterEnable(emulation, 1));
                    break;
                }
                case 71: {
                    boolean filterEnable = emulation.isThirdSIDFilter() ^ true;
                    emulation.setThirdSIDFilter(filterEnable);
                    player.configureSID(2, sid -> sid.setFilterEnable(emulation, 2));
                    break;
                }
                case 113: {
                    player.quit();
                    break;
                }
            }
        }
        catch (IOException e) {
            player.quit();
        }
    }
}

