/*
 * Decompiled with CFR 0.152.
 */
package sidplay.audio;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import javax.sound.sampled.LineUnavailableException;
import sidplay.audio.AudioConfig;
import sidplay.audio.AudioDriver;

public class WavFile
implements AudioDriver {
    private static final int HEADER_LENGTH = 44;
    private static final int HEADER_OFFSET = 8;
    private ByteBuffer sampleBuffer;
    private int samplesWritten;
    private RandomAccessFile file;
    private final WavHeader wavHdr = new WavHeader();

    @Override
    public void open(AudioConfig cfg, String recordingFilename) throws IOException, LineUnavailableException {
        int blockAlign = 2 * cfg.getChannels();
        this.sampleBuffer = ByteBuffer.allocate(cfg.getChunkFrames() * blockAlign);
        this.sampleBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.wavHdr.length = 36;
        this.wavHdr.format = (short)1;
        this.wavHdr.channels = (short)cfg.getChannels();
        this.wavHdr.sampleFreq = cfg.getFrameRate();
        this.wavHdr.bytesPerSec = cfg.getFrameRate() * blockAlign;
        this.wavHdr.blockAlign = (short)blockAlign;
        this.wavHdr.bitsPerSample = (short)16;
        this.file = new RandomAccessFile(recordingFilename + ".wav", "rw");
        this.file.setLength(0L);
        this.file.write(this.wavHdr.getBytes());
        this.samplesWritten = 0;
    }

    @Override
    public void write() throws InterruptedException {
        try {
            int len = this.sampleBuffer.capacity();
            this.file.write(this.sampleBuffer.array(), 0, len);
            this.samplesWritten += len;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new InterruptedException();
        }
    }

    @Override
    public void close() {
        try {
            this.wavHdr.length = this.samplesWritten + 44 - 8;
            this.wavHdr.dataChunkLen = this.samplesWritten;
            this.file.seek(0L);
            this.file.write(this.wavHdr.getBytes(), 0, 44);
            this.file.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ByteBuffer buffer() {
        return this.sampleBuffer;
    }

    static class WavHeader {
        private static final Charset US_ASCII = Charset.forName("US-ASCII");
        private int length;
        private short format;
        private short channels;
        private int sampleFreq;
        private int bytesPerSec;
        private short blockAlign;
        private short bitsPerSample;
        private int dataChunkLen;

        WavHeader() {
        }

        private byte[] getBytes() {
            ByteBuffer b = ByteBuffer.allocate(44);
            b.order(ByteOrder.LITTLE_ENDIAN);
            b.put("RIFF".getBytes(US_ASCII));
            b.putInt(this.length);
            b.put("WAVE".getBytes(US_ASCII));
            b.put("fmt ".getBytes(US_ASCII));
            b.putInt(16);
            b.putShort(this.format);
            b.putShort(this.channels);
            b.putInt(this.sampleFreq);
            b.putInt(this.bytesPerSec);
            b.putShort(this.blockAlign);
            b.putShort(this.bitsPerSample);
            b.put("data".getBytes(US_ASCII));
            b.putInt(this.dataChunkLen);
            return b.array();
        }
    }
}

