/*
 * Decompiled with CFR 0.152.
 */
package sidplay.audio;

import java.io.IOException;
import java.nio.ByteBuffer;
import javax.sound.sampled.LineUnavailableException;
import sidplay.audio.AudioConfig;
import sidplay.audio.AudioDriver;

public class ProxyDriver
implements AudioDriver {
    private final AudioDriver driverOne;
    private final AudioDriver driverTwo;

    public ProxyDriver(AudioDriver driver1, AudioDriver driver2) {
        this.driverOne = driver1;
        this.driverTwo = driver2;
    }

    @Override
    public void open(AudioConfig cfg, String recordingFilename) throws IOException, LineUnavailableException {
        this.driverOne.open(cfg, recordingFilename);
        this.driverTwo.open(cfg, recordingFilename);
    }

    @Override
    public void pause() {
        this.driverOne.pause();
        this.driverTwo.pause();
    }

    @Override
    public void write() throws InterruptedException {
        this.driverOne.write();
        System.arraycopy(this.buffer().array(), 0, this.driverTwo.buffer().array(), 0, this.driverTwo.buffer().capacity());
        this.driverTwo.write();
    }

    @Override
    public void close() {
        this.driverOne.close();
        this.driverTwo.close();
    }

    @Override
    public ByteBuffer buffer() {
        return this.driverOne.buffer();
    }
}

