/*
 * Decompiled with CFR 0.152.
 */
package sidplay.audio;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.LineUnavailableException;
import lowlevel.LameEncoder;
import mp3.MPEGMode;
import sidplay.audio.AudioConfig;
import sidplay.audio.AudioDriver;

public abstract class MP3Driver
implements AudioDriver {
    protected ByteBuffer sampleBuffer;
    protected int cbr = LameEncoder.DEFAULT_BITRATE;
    protected int vbrQuality = LameEncoder.DEFAULT_QUALITY;
    protected boolean vbr = LameEncoder.DEFAULT_VBR;
    protected OutputStream out;
    private LameEncoder jump3r;

    public void setCbr(int cbr) {
        this.cbr = cbr;
    }

    public void setVbrQuality(int vbrQuality) {
        this.vbrQuality = vbrQuality;
    }

    public void setVbr(boolean isVbr) {
        this.vbr = isVbr;
    }

    @Override
    public void open(AudioConfig cfg, String recordingFilename) throws IOException, LineUnavailableException {
        int blockAlign = 2 * cfg.getChannels();
        this.sampleBuffer = ByteBuffer.allocate(cfg.getChunkFrames() * blockAlign);
        this.sampleBuffer.order(ByteOrder.LITTLE_ENDIAN);
        AudioFormat audioFormat = new AudioFormat(cfg.getFrameRate(), 16, cfg.getChannels(), true, false);
        this.jump3r = new LameEncoder(audioFormat, this.cbr, MPEGMode.STEREO, this.vbrQuality, this.vbr);
        this.out = this.getOut(recordingFilename);
    }

    @Override
    public void write() throws InterruptedException {
        try {
            byte[] encoded = new byte[this.jump3r.getMP3BufferSize()];
            int bytesWritten = this.jump3r.encodeBuffer(this.sampleBuffer.array(), 0, this.sampleBuffer.capacity(), encoded);
            this.out.write(encoded, 0, bytesWritten);
        }
        catch (IOException | ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
            throw new InterruptedException();
        }
    }

    @Override
    public void close() {
        if (this.jump3r != null) {
            this.jump3r.close();
        }
    }

    @Override
    public ByteBuffer buffer() {
        return this.sampleBuffer;
    }

    protected abstract OutputStream getOut(String var1) throws IOException;

    public static class MP3Stream
    extends MP3Driver {
        public MP3Stream(OutputStream out) {
            this.out = out;
        }

        @Override
        protected OutputStream getOut(String recordingFilename) {
            return this.out;
        }
    }

    public static class MP3File
    extends MP3Driver {
        @Override
        protected OutputStream getOut(String recordingFilename) throws IOException {
            return new FileOutputStream(recordingFilename + ".mp3");
        }

        @Override
        public void close() {
            super.close();
            if (this.out != null) {
                try {
                    this.out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

