/*
 * Decompiled with CFR 0.152.
 */
package sidplay.audio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import sidplay.audio.AudioConfig;
import sidplay.audio.AudioDriver;

public class JavaSound
implements AudioDriver {
    private AudioConfig cfg;
    private AudioFormat audioFormat;
    private SourceDataLine dataLine;
    private ByteBuffer sampleBuffer;

    @Override
    public synchronized void open(AudioConfig cfg, String recordingFilename) throws IOException, LineUnavailableException {
        ObservableList<Device> devices;
        int device = cfg.getDevice();
        if (device < (devices = JavaSound.getDevices()).size()) {
            this.open(cfg, ((Device)devices.get(device)).getInfo());
        } else {
            this.open(cfg, (Mixer.Info)null);
        }
    }

    public synchronized void open(AudioConfig cfg, Mixer.Info info) throws IOException, LineUnavailableException {
        this.cfg = cfg;
        boolean signed = true;
        boolean bigEndian = false;
        this.audioFormat = new AudioFormat(cfg.getFrameRate(), 16, cfg.getChannels(), signed, bigEndian);
        this.setAudioDevice(info);
    }

    public static final ObservableList<Device> getDevices() {
        ObservableList devices = FXCollections.observableArrayList();
        for (Mixer.Info info : AudioSystem.getMixerInfo()) {
            Line.Info lineInfo;
            Mixer mixer = AudioSystem.getMixer(info);
            if (!mixer.isLineSupported(lineInfo = new Line.Info(SourceDataLine.class))) continue;
            devices.add((Object)new Device(info));
        }
        return devices;
    }

    public synchronized void setAudioDevice(Mixer.Info info) throws LineUnavailableException {
        this.close();
        this.dataLine = AudioSystem.getSourceDataLine(this.audioFormat, info);
        this.dataLine.open(this.dataLine.getFormat(), this.cfg.getBufferFrames() * 2 * this.cfg.getChannels());
        this.cfg.setBufferFrames(this.dataLine.getBufferSize() / 2 / this.cfg.getChannels());
        this.sampleBuffer = ByteBuffer.allocate(this.cfg.getChunkFrames() * 2 * this.cfg.getChannels()).order(ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public synchronized void write() throws InterruptedException {
        if (!this.dataLine.isActive()) {
            this.dataLine.start();
        }
        this.dataLine.write(this.sampleBuffer.array(), 0, this.sampleBuffer.capacity());
    }

    public synchronized int getRemainingPlayTime() {
        int bytesPerFrame = this.dataLine.getFormat().getChannels() * 2;
        int framesPlayed = this.dataLine.available() / bytesPerFrame;
        int framesTotal = this.dataLine.getBufferSize() / bytesPerFrame;
        int framesNotYetPlayed = framesTotal - framesPlayed;
        return framesNotYetPlayed * 1000 / framesTotal;
    }

    @Override
    public synchronized void pause() {
        if (this.dataLine.isActive()) {
            this.dataLine.stop();
        }
    }

    @Override
    public synchronized void close() {
        if (this.dataLine == null) {
            return;
        }
        if (this.dataLine.isActive()) {
            this.dataLine.stop();
            this.dataLine.flush();
        }
        if (this.dataLine.isOpen()) {
            this.dataLine.close();
        }
    }

    @Override
    public ByteBuffer buffer() {
        return this.sampleBuffer;
    }

    public static final class Device {
        private final Mixer.Info info;

        public Device(Mixer.Info info) {
            this.info = info;
        }

        public Mixer.Info getInfo() {
            return this.info;
        }

        public String toString() {
            return this.info.getName();
        }
    }
}

