/*
 * Decompiled with CFR 0.152.
 */
package sidplay.audio;

import java.io.IOException;
import javax.sound.sampled.LineUnavailableException;
import libsidplay.config.IAudioSection;
import lowlevel.LameDecoder;
import sidplay.audio.AudioConfig;
import sidplay.audio.JavaSound;

public class CmpMP3File
extends JavaSound {
    protected LameDecoder jump3r;
    protected JavaSound mp3JavaSound = new JavaSound();
    private IAudioSection audioSection;

    void setAudioSection(IAudioSection audioSection) {
        this.audioSection = audioSection;
    }

    @Override
    public void open(AudioConfig cfg, String recordingFilename) throws IOException, LineUnavailableException {
        super.open(cfg, recordingFilename);
        this.jump3r = new LameDecoder(this.audioSection.getMp3File());
        this.mp3JavaSound.open(new AudioConfig(this.jump3r.getSampleRate(), this.jump3r.getChannels(), cfg.getDevice()){

            @Override
            public int getChunkFrames() {
                return CmpMP3File.this.jump3r.getFrameSize();
            }
        }, recordingFilename);
    }

    @Override
    public void write() throws InterruptedException {
        if (!this.jump3r.decode(this.mp3JavaSound.buffer())) {
            throw new MP3Termination();
        }
        if (this.audioSection.isPlayOriginal()) {
            this.mp3JavaSound.write();
        } else {
            super.write();
        }
    }

    @Override
    public synchronized void pause() {
        super.pause();
        this.mp3JavaSound.pause();
    }

    @Override
    public void close() {
        super.close();
        this.mp3JavaSound.close();
        if (this.jump3r != null) {
            this.jump3r.close();
        }
    }

    public static class MP3Termination
    extends InterruptedException {
        private static final long serialVersionUID = -7204524330347735933L;
    }
}

