/*
 * Decompiled with CFR 0.152.
 */
package sidplay.audio;

import libsidplay.config.IAudioSection;

public class AudioConfig {
    private final int frameRate;
    private final int channels;
    private int bufferFrames;
    private final int deviceIdx;

    public AudioConfig(int frameRate, int channels, int deviceIdx) {
        this.frameRate = frameRate;
        this.channels = channels;
        this.deviceIdx = deviceIdx;
        this.bufferFrames = 32 * channels * 64;
    }

    public static AudioConfig getInstance(IAudioSection audio) {
        return new AudioConfig(audio.getSamplingRate().getFrequency(), 2, audio.getDevice());
    }

    public final int getFrameRate() {
        return this.frameRate;
    }

    public int getChunkFrames() {
        return Math.min(1024, this.bufferFrames);
    }

    public final int getBufferFrames() {
        return this.bufferFrames;
    }

    public final void setBufferFrames(int bufferFrames) {
        this.bufferFrames = bufferFrames;
    }

    public final int getChannels() {
        return this.channels;
    }

    public final int getDevice() {
        return this.deviceIdx;
    }
}

