/*
 * Decompiled with CFR 0.152.
 */
package sidplay.audio;

import libsidplay.config.IAudioSection;
import libsidplay.sidtune.MP3Tune;
import libsidplay.sidtune.SidTune;
import sidplay.audio.AudioDriver;
import sidplay.audio.CmpMP3File;
import sidplay.audio.JavaSound;
import sidplay.audio.MP3Driver;
import sidplay.audio.ProxyDriver;
import sidplay.audio.WavFile;

public final class Audio
extends Enum<Audio> {
    public static final /* enum */ Audio SOUNDCARD = new Audio(new JavaSound());
    public static final /* enum */ Audio WAV = new Audio(new WavFile());
    public static final /* enum */ Audio MP3 = new Audio(new MP3Driver.MP3File());
    public static final /* enum */ Audio LIVE_WAV = new Audio(new ProxyDriver(new JavaSound(), new WavFile()));
    public static final /* enum */ Audio LIVE_MP3 = new Audio(new ProxyDriver(new JavaSound(), new MP3Driver.MP3File()));
    public static final /* enum */ Audio COMPARE_MP3;
    private final AudioDriver audioDriver;
    private static final CmpMP3File CMP_MP3;
    private AudioDriver oldAudioDriver;
    private static final /* synthetic */ Audio[] $VALUES;

    public static Audio[] values() {
        return (Audio[])$VALUES.clone();
    }

    public static Audio valueOf(String name) {
        return Enum.valueOf(Audio.class, name);
    }

    private Audio(AudioDriver audioDriver) {
        this.audioDriver = audioDriver;
    }

    public final AudioDriver getAudioDriver() {
        return this.audioDriver;
    }

    public final AudioDriver getAudioDriver(IAudioSection audioSection, SidTune tune) {
        return this.handleMP3(audioSection, tune, this.audioDriver);
    }

    private AudioDriver handleMP3(IAudioSection audioSection, SidTune tune, AudioDriver audioDriver) {
        AudioDriver newAudioDriver = audioDriver;
        if (this.oldAudioDriver == null && tune instanceof MP3Tune) {
            this.oldAudioDriver = audioDriver;
        } else if (this.oldAudioDriver != null && !(tune instanceof MP3Tune)) {
            newAudioDriver = this.oldAudioDriver;
            this.oldAudioDriver = null;
        }
        if (tune instanceof MP3Tune) {
            audioSection.setPlayOriginal(true);
            audioSection.setMp3File(((MP3Tune)tune).getMP3Filename());
            newAudioDriver = CMP_MP3;
        }
        if (CMP_MP3.equals(newAudioDriver)) {
            CMP_MP3.setAudioSection(audioSection);
        }
        return newAudioDriver;
    }

    static {
        CMP_MP3 = new CmpMP3File();
        COMPARE_MP3 = new Audio(CMP_MP3);
        $VALUES = new Audio[]{SOUNDCARD, WAV, MP3, LIVE_WAV, LIVE_MP3, COMPARE_MP3};
    }
}

