/*
 * Decompiled with CFR 0.152.
 */
package sidplay;

import hardsid_builder.HardSID;
import hardsid_builder.HardSIDBuilder;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javax.sound.sampled.LineUnavailableException;
import libsidplay.HardwareEnsemble;
import libsidplay.common.CPUClock;
import libsidplay.common.Engine;
import libsidplay.common.Event;
import libsidplay.common.EventScheduler;
import libsidplay.common.Mixer;
import libsidplay.common.SIDBuilder;
import libsidplay.common.SIDEmu;
import libsidplay.components.c1530.Datasette;
import libsidplay.components.mos6510.MOS6510;
import libsidplay.components.mos6526.MOS6526;
import libsidplay.components.mos656x.VIC;
import libsidplay.config.IAudioSection;
import libsidplay.config.IConfig;
import libsidplay.sidtune.SidTune;
import libsidplay.sidtune.SidTuneError;
import libsidutils.siddatabase.SidDatabase;
import libsidutils.stil.STIL;
import netsiddev_builder.NetSIDDevBuilder;
import resid_builder.ReSIDBuilder;
import resid_builder.resid.ReSID;
import resid_builder.residfp.ReSIDfp;
import sidplay.audio.Audio;
import sidplay.audio.AudioConfig;
import sidplay.audio.AudioDriver;
import sidplay.audio.CmpMP3File;
import sidplay.ini.IniConfig;
import sidplay.player.PlayList;
import sidplay.player.State;
import sidplay.player.Timer;

public class Player
extends HardwareEnsemble {
    private static final int PAUSE_SLEEP_TIME = 250;
    private static final int PAUSE_QUIT_TIME = 1000;
    private static final int PREV_SONG_TIMEOUT = 4;
    private static final int RAM_COMMAND = 631;
    private static final int RAM_COMMAND_LEN = 198;
    private static final int MAX_COMMAND_LEN = 16;
    private static final String RUN = "RUN\r";
    private static final String SYS = "SYS%d\r";
    private static final String LOAD = "LOAD\r";
    private ObjectProperty<State> stateProperty = new SimpleObjectProperty((Object)State.QUIT);
    private Timer timer;
    private PlayList playList;
    private SidTune tune = SidTune.RESET;
    private String command;
    private Thread playerThread;
    private Consumer<Player> menuHook = player -> {};
    private Consumer<Player> interactivityHook = player -> {};
    private AudioDriver audioDriver = Audio.SOUNDCARD.getAudioDriver();
    private SIDBuilder sidBuilder;
    private STIL stil;
    private SidDatabase sidDatabase;
    private Function<SidTune, String> recordingFilenameProvider = tune -> "jsidplay2";
    private BiFunction<Integer, SIDEmu, SIDEmu> requiredSIDs = (sidNum, sidEmu) -> {
        if (SidTune.isSIDUsed(this.config.getEmulationSection(), this.tune, sidNum)) {
            return this.sidBuilder.lock((SIDEmu)sidEmu, (int)sidNum, this.tune);
        }
        if (sidEmu != SIDEmu.NONE) {
            this.sidBuilder.unlock((SIDEmu)sidEmu);
        }
        return SIDEmu.NONE;
    };
    private BiFunction<Integer, SIDEmu, SIDEmu> noSIDs = (sidNum, sidEmu) -> {
        if (sidEmu != SIDEmu.NONE) {
            this.sidBuilder.unlock((SIDEmu)sidEmu);
        }
        return SIDEmu.NONE;
    };
    private IntFunction<Integer> sidLocator = sidNum -> SidTune.getSIDAddress(this.config.getEmulationSection(), this.tune, sidNum);
    private Runnable playerRunnable = () -> {
        do {
            try {
                this.open();
                this.stateProperty.set((Object)State.START);
                this.menuHook.accept(this);
                this.stateProperty.set((Object)State.PLAY);
                while (this.play()) {
                    this.interactivityHook.accept(this);
                }
            }
            catch (CmpMP3File.MP3Termination e) {
                this.stateProperty.set((Object)State.END);
            }
            catch (IOException | InterruptedException | LineUnavailableException e) {
                throw new RuntimeException(e.getMessage());
            }
            finally {
                this.close();
            }
        } while (this.stateProperty.get() == State.RESTART);
    };

    public Player(IConfig config) {
        this(config, MOS6510.class);
    }

    public Player(final IConfig config, Class<? extends MOS6510> cpuClass) {
        super(config, cpuClass);
        this.playList = PlayList.getInstance(config, SidTune.RESET);
        this.timer = new Timer(this){

            @Override
            public void start() {
                Player.this.c64.insertSIDChips(Player.this.requiredSIDs, Player.this.sidLocator);
                Player.this.configureMixer(mixer -> mixer.start());
            }

            @Override
            public void end() {
                if (Player.this.tune != SidTune.RESET) {
                    if (!config.getSidplay2Section().isSingle() && Player.this.playList.hasNext()) {
                        Player.this.nextSong();
                    } else if (config.getSidplay2Section().isLoop()) {
                        Player.this.stateProperty.set((Object)State.RESTART);
                    } else {
                        Player.this.stateProperty.set((Object)State.END);
                    }
                }
            }

            @Override
            public void fadeInStart(int fadeIn) {
                if (Player.this.tune != SidTune.RESET) {
                    Player.this.configureMixer(mixer -> mixer.fadeIn(fadeIn));
                }
            }

            @Override
            public void fadeOutStart(int fadeOut) {
                if (Player.this.tune != SidTune.RESET) {
                    Player.this.configureMixer(mixer -> mixer.fadeOut(fadeOut));
                }
            }
        };
        this.initializeTmpDir();
    }

    private void initializeTmpDir() {
        File tmpDir = new File(this.config.getSidplay2Section().getTmpDir());
        if (!tmpDir.exists()) {
            tmpDir.mkdirs();
        }
    }

    @Override
    protected final void setClock(CPUClock cpuFreq) {
        super.setClock(cpuFreq);
        this.sidBuilder = this.createSIDBuilder(cpuFreq);
    }

    private SIDBuilder createSIDBuilder(CPUClock cpuClock) {
        Engine engine = this.config.getEmulationSection().getEngine();
        switch (engine) {
            case EMULATION: {
                return new ReSIDBuilder(this.c64.getEventScheduler(), this.config, cpuClock, this.audioDriver);
            }
            case NETSID: {
                return new NetSIDDevBuilder(this.c64.getEventScheduler(), this.config, this.tune, cpuClock);
            }
            case HARDSID: {
                return new HardSIDBuilder(this.c64.getEventScheduler(), this.config);
            }
        }
        throw new RuntimeException("Unknown engine type: " + (Object)((Object)engine));
    }

    public final void updateSIDChipConfiguration() {
        this.executeInPlayerThread("Update SID Chip Configuration", () -> this.c64.insertSIDChips(this.requiredSIDs, this.sidLocator));
    }

    public final void configureVICs(Consumer<VIC> action) {
        this.executeInPlayerThread("Configure VICs", () -> this.c64.configureVICs(action));
    }

    public final void configureSIDs(BiConsumer<Integer, SIDEmu> action) {
        this.executeInPlayerThread("Configure SIDs", () -> this.c64.configureSIDs(action));
    }

    public final void configureSID(int chipNum, Consumer<SIDEmu> action) {
        this.executeInPlayerThread("Configure SID", () -> this.c64.configureSID(chipNum, action));
    }

    public final void configureMixer(Consumer<Mixer> action) {
        this.executeInPlayerThread("Configure Mixer", () -> {
            if (this.sidBuilder instanceof Mixer) {
                action.accept((Mixer)((Object)this.sidBuilder));
            }
        });
    }

    private void executeInPlayerThread(String eventName, final Runnable runnable) {
        if (Thread.currentThread().equals(this.playerThread)) {
            runnable.run();
        } else {
            this.c64.getEventScheduler().scheduleThreadSafe(new Event(eventName){

                @Override
                public void event() throws InterruptedException {
                    runnable.run();
                }
            });
        }
    }

    @Override
    protected final void reset() {
        super.reset();
        this.timer.reset();
        this.c64.getEventScheduler().schedule(new Event("Auto-start"){

            @Override
            public void event() throws InterruptedException {
                if (Player.this.tune != SidTune.RESET) {
                    Integer driverAddress = Player.this.tune.placeProgramInMemory(Player.this.c64.getRAM());
                    if (driverAddress != null) {
                        Player.this.c64.setPlayAddr(Player.this.tune.getInfo().getPlayAddr());
                        Player.this.c64.getCPU().forcedJump(driverAddress);
                    } else {
                        int loadAddr = Player.this.tune.getInfo().getLoadAddr();
                        Player.this.command = loadAddr == 2049 ? Player.RUN : String.format(Player.SYS, loadAddr);
                    }
                }
                if (Player.this.command != null) {
                    if (Player.this.command.startsWith(Player.LOAD)) {
                        Player.this.datasette.control(Datasette.Control.START);
                    }
                    Player.this.typeInCommand(Player.this.command);
                }
            }
        }, SidTune.getInitDelay(this.tune));
    }

    public final void typeInCommand(String command) {
        byte[] ram = this.c64.getRAM();
        int length = Math.min(command.length(), 16);
        for (int charNum = 0; charNum < length; ++charNum) {
            ram[631 + charNum] = (byte)command.charAt(charNum);
        }
        ram[198] = (byte)length;
    }

    private void setCommand(String command) {
        this.command = command;
    }

    public final int time() {
        EventScheduler c = this.c64.getEventScheduler();
        return (int)((double)c.getTime(Event.Phase.PHI2) / c.getCyclesPerSecond());
    }

    public final PlayList getPlayList() {
        return this.playList;
    }

    public final Timer getTimer() {
        return this.timer;
    }

    public final SidTune getTune() {
        return this.tune;
    }

    public final void setTune(SidTune tune) {
        this.tune = tune;
    }

    public final void startC64() {
        if (this.playerThread == null || !this.playerThread.isAlive()) {
            this.playerThread = new Thread(this.playerRunnable, "Player");
            this.playerThread.setPriority(10);
            this.playerThread.start();
        }
    }

    public final void stopC64() {
        this.stopC64(true);
    }

    public final void stopC64(boolean quitOrWait) {
        try {
            while (this.playerThread != null && this.playerThread.isAlive()) {
                if (quitOrWait) {
                    this.quit();
                }
                this.playerThread.join(1000L);
                if (!quitOrWait || !this.playerThread.isAlive()) continue;
                this.playerThread.interrupt();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public final void setMenuHook(Consumer<Player> menuHook) {
        this.menuHook = menuHook;
    }

    public final void setInteractivityHook(Consumer<Player> interactivityHook) {
        this.interactivityHook = interactivityHook;
    }

    public final ReadOnlyObjectProperty<State> stateProperty() {
        return this.stateProperty;
    }

    private void open() throws InterruptedException, IOException, LineUnavailableException {
        this.playList = PlayList.getInstance(this.config, this.tune);
        IAudioSection audioSection = this.config.getAudioSection();
        if (Arrays.stream(Audio.values()).anyMatch(audio -> audio.getAudioDriver().equals(this.audioDriver))) {
            this.audioDriver = audioSection.getAudio().getAudioDriver(audioSection, this.tune);
        }
        AudioConfig audioConfig = AudioConfig.getInstance(audioSection);
        this.audioDriver.open(audioConfig, this.recordingFilenameProvider.apply(this.tune));
        this.setClock(CPUClock.getCPUClock(this.config.getEmulationSection(), this.tune));
        this.reset();
    }

    public final void setAudioDriver(AudioDriver driver) {
        this.audioDriver = driver;
    }

    private boolean play() throws InterruptedException {
        if (this.stateProperty.get() == State.PLAY) {
            for (int i = 0; i < this.config.getAudioSection().getBufferSize(); ++i) {
                this.c64.getEventScheduler().clock();
            }
        }
        if (this.stateProperty.get() == State.PAUSE) {
            Thread.sleep(250L);
        }
        return this.stateProperty.get() == State.PLAY || this.stateProperty.get() == State.PAUSE;
    }

    private void close() {
        this.c64.insertSIDChips(this.noSIDs, this.sidLocator);
        this.audioDriver.close();
    }

    public final void play(SidTune tune) {
        this.play(tune, null);
    }

    public final void resetC64(String command) {
        this.play(SidTune.RESET, command);
    }

    private void play(SidTune tune, String command) {
        this.stopC64();
        this.setTune(tune);
        this.setCommand(command);
        this.startC64();
    }

    public final void pauseContinue() {
        if (this.stateProperty.get() == State.QUIT || this.stateProperty.get() == State.END) {
            this.play(this.tune);
        } else if (this.stateProperty.get() == State.PAUSE) {
            this.stateProperty.set((Object)State.PLAY);
        } else {
            this.executeInPlayerThread("Pause", () -> {
                this.stateProperty.set((Object)State.PAUSE);
                this.audioDriver.pause();
                this.sidBuilder.pause();
            });
        }
    }

    public final void nextSong() {
        this.playList.next();
        this.stateProperty.set((Object)State.RESTART);
    }

    public final void previousSong() {
        if (this.time() < 4) {
            this.playList.previous();
        }
        this.stateProperty.set((Object)State.RESTART);
    }

    public final void firstSong() {
        this.playList.first();
        this.stateProperty.set((Object)State.RESTART);
    }

    public final void lastSong() {
        this.playList.last();
        this.stateProperty.set((Object)State.RESTART);
    }

    public final <T> T getMixerInfo(Function<Mixer, T> function, T defaultValue) {
        boolean isMixer = this.sidBuilder instanceof Mixer;
        return isMixer ? function.apply((Mixer)((Object)this.sidBuilder)) : defaultValue;
    }

    public final void quit() {
        this.stateProperty.set((Object)State.QUIT);
    }

    public final void setSidDatabase(SidDatabase sidDatabase) {
        this.sidDatabase = sidDatabase;
    }

    public final <T> T getSidDatabaseInfo(Function<SidDatabase, T> function, T defaultValue) {
        return this.sidDatabase != null ? function.apply(this.sidDatabase) : defaultValue;
    }

    public final void setSTIL(STIL stil) {
        this.stil = stil;
    }

    public final STIL.STILEntry getStilEntry(String collectionName) {
        return this.stil != null && collectionName != null ? this.stil.getSTILEntry(collectionName) : null;
    }

    public final void setRecordingFilenameProvider(Function<SidTune, String> recordingFilenameProvider) {
        this.recordingFilenameProvider = recordingFilenameProvider;
    }

    public final String getCredits(Properties properties) {
        StringBuffer credits = new StringBuffer();
        credits.append("Java Version and User Interface v");
        credits.append(properties.getProperty("version"));
        credits.append(":\n");
        credits.append("\tCopyright (\u00a9) 2007-2017 Ken H\u00e4ndel\n");
        credits.append("\thttp://sourceforge.net/projects/jsidplay2/\n");
        credits.append("Distortion Simulation and development: Antti S. Lankila\n");
        credits.append("\thttp://bel.fi/~alankila/c64-sw/\n");
        credits.append("Network SID Device:\n");
        credits.append("\tSupported by Wilfred Bos, The Netherlands\n");
        credits.append("\thttp://www.acid64.com\n");
        credits.append("Testing and Feedback: Nata, founder of proNoise\n");
        credits.append("\thttp://www.nata.netau.net/\n");
        credits.append("graphical output:\n\t(\u00a9) 2007 Joakim Eriksson\n");
        credits.append("\t(\u00a9) 2009, 2010 Antti S. Lankila\n");
        credits.append("MP3 encoder/decoder (jump3r), based on Lame\n");
        credits.append("\tCopyright (\u00a9) 2010-2011  Ken H\u00e4ndel\n");
        credits.append("\thttp://sourceforge.net/projects/jsidplay2/\n");
        credits.append("This product uses the database of Game Base 64 (GB64)\n");
        credits.append("\thttp://www.gb64.com/\n");
        credits.append("Command Line Parser (JCommander):\n");
        credits.append("\tCopyright (\u00a9) 2010-2014 C\u00e9dric Beust\n");
        credits.append("\thttp://jcommander.org/\n");
        credits.append("MP3 downloads from Stone Oakvalley's Authentic SID MusicCollection (SOASC=):\n");
        credits.append("\thttp://www.6581-8580.com/\n");
        credits.append("6510 cross assembler (Kickassembler V4.7):\n");
        credits.append("\tCopyright (\u00a9) 2006-2014 Mads Nielsen\n");
        credits.append("\thttp://www.theweb.dk/KickAssembler/\n");
        credits.append("PSID to PRG converter (PSID64 v0.9):\n");
        credits.append("\tCopyright (\u00a9) 2001-2007 Roland Hermans\n");
        credits.append("\thttp://sourceforge.net/projects/psid64/\n");
        credits.append("An Optimizing Hybrid LZ77 RLE Data Compression Program (Pucrunch 22.11.2008):\n");
        credits.append("\tCopyright (\u00a9) 1997-2008 Pasi 'Albert' Ojala\n");
        credits.append("\thttp://www.cs.tut.fi/~albert/Dev/pucrunch/\n");
        credits.append("SID dump file (SIDDump V1.04):\n");
        credits.append("\tCopyright (\u00a9) 2007 Lasse \u00d6\u00f6rni\n");
        credits.append("HVSC playroutine identity scanner (SIDId V1.07):\n");
        credits.append("\tCopyright (\u00a9) 2007 Lasse \u00d6\u00f6rni\n");
        credits.append("High Voltage Music Engine MusicCollection (HVMEC V1.0):\n");
        credits.append("\tCopyright (\u00a9) 2011 by Stefano Tognon and Stephan Parth\n");
        credits.append("C1541 Floppy Disk Drive Emulation:\n");
        credits.append("\tCopyright (\u00a9) 2010 VICE (the Versatile Commodore Emulator)\n");
        credits.append("\thttp://www.viceteam.org/\n");
        credits.append("Based on libsidplay v2.1.1 and ReSID v0.0.2 engine:\n");
        credits.append("\tCopyright (\u00a9) 1999-2002 Simon White <sidplay2@yahoo.com>\n");
        credits.append("\thttp://sidplay2.sourceforge.net\n");
        credits.append(MOS6510.credits());
        credits.append(MOS6526.credits());
        credits.append(VIC.credits());
        credits.append(ReSID.credits());
        credits.append(ReSIDfp.credits());
        credits.append(HardSID.credits());
        return credits.toString();
    }

    public static void main(String[] args) throws IOException, SidTuneError {
        if (args.length < 1) {
            System.err.println("Missing argument: <filename>");
            System.exit(-1);
        }
        SidTune tune = SidTune.load(new File(args[0]));
        Player player = new Player(new IniConfig());
        player.play(tune);
    }
}

