/*
 * Decompiled with CFR 0.152.
 */
package sidplay;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import libsidplay.common.CPUClock;
import libsidplay.common.ChipModel;
import libsidplay.common.Emulation;
import libsidplay.common.Engine;
import libsidplay.common.SamplingRate;
import libsidplay.components.mos6510.MOS6510;
import libsidplay.sidtune.SidTune;
import libsidplay.sidtune.SidTuneError;
import libsidutils.PathUtils;
import libsidutils.debug.MOS6510Debug;
import libsidutils.siddatabase.SidDatabase;
import sidplay.Player;
import sidplay.audio.Audio;
import sidplay.audio.JavaSound;
import sidplay.consoleplayer.ConsoleIO;
import sidplay.consoleplayer.ParameterTimeConverter;
import sidplay.consoleplayer.VerboseValidator;
import sidplay.ini.IniConfig;
import sidplay.ini.IniDefaults;

@Parameters(resourceBundle="sidplay.consoleplayer.ConsolePlayer")
public final class ConsolePlayer {
    @Parameter(names={"--help", "-h"}, descriptionKey="USAGE", help=true)
    private Boolean help = Boolean.FALSE;
    @Parameter(names={"--cpuDebug"}, hidden=true, descriptionKey="DEBUG")
    private Boolean cpuDebug = Boolean.FALSE;
    @Parameter(names={"--audio", "-a"}, descriptionKey="DRIVER")
    private Audio audio = IniDefaults.DEFAULT_AUDIO;
    @Parameter(names={"--bufferSize", "-B"}, descriptionKey="BUFFER_SIZE")
    private int bufferSize = IniDefaults.DEFAULT_BUFFER_SIZE;
    @Parameter(names={"--deviceIndex", "-A"}, descriptionKey="DEVICEINDEX")
    private Integer deviceIdx = IniDefaults.DEFAULT_DEVICE;
    @Parameter(names={"--engine", "-E"}, descriptionKey="ENGINE")
    private Engine engine = IniDefaults.DEFAULT_ENGINE;
    @Parameter(names={"--defaultEmulation", "-e"}, descriptionKey="DEFAULT_EMULATION")
    private Emulation defaultEmulation = IniDefaults.DEFAULT_EMULATION;
    @Parameter(names={"--recordingFilename", "-r"}, descriptionKey="RECORDING_FILENAME")
    private String recordingFilename = "jsidplay2";
    @Parameter(names={"--startSong", "-o"}, descriptionKey="START_SONG")
    private Integer song = null;
    @Parameter(names={"--loop", "-l"}, descriptionKey="LOOP")
    private Boolean loop = IniDefaults.DEFAULT_LOOP;
    @Parameter(names={"--single", "-s"}, descriptionKey="SINGLE")
    private Boolean single = IniDefaults.DEFAULT_SINGLE_TRACK;
    @Parameter(names={"--frequency", "-f"}, descriptionKey="FREQUENCY")
    private SamplingRate samplingRate = IniDefaults.DEFAULT_SAMPLING_RATE;
    @Parameter(names={"--dualSID", "-d"}, descriptionKey="DUAL_SID")
    private Boolean dualSID = IniDefaults.DEFAULT_FORCE_STEREO_TUNE;
    @Parameter(names={"--thirdSID", "-D"}, descriptionKey="THIRD_SID")
    private Boolean thirdSID = IniDefaults.DEFAULT_FORCE_3SID_TUNE;
    @Parameter(names={"--forceClock", "-c"}, descriptionKey="FORCE_CLOCK")
    private CPUClock forceClock = null;
    @Parameter(names={"--defaultClock", "-k"}, descriptionKey="DEFAULT_CLOCK")
    private CPUClock defaultClock = IniDefaults.DEFAULT_CLOCK_SPEED;
    @Parameter(names={"--disableFilter", "-i"}, descriptionKey="DISABLE_FILTER")
    private Boolean disableFilter = !IniDefaults.DEFAULT_USE_FILTER;
    @Parameter(names={"--disableStereoFilter", "-j"}, descriptionKey="DISABLE_STEREO_FILTER")
    private Boolean disableStereoFilter = !IniDefaults.DEFAULT_USE_STEREO_FILTER;
    @Parameter(names={"--disable3rdSidFilter", "-J"}, descriptionKey="DISABLE_3RD_SID_FILTER")
    private Boolean disable3rdSIDFilter = !IniDefaults.DEFAULT_USE_3SID_FILTER;
    @Parameter(names={"--forceModel", "-m"}, descriptionKey="FORCE_MODEL")
    private ChipModel forceModel = ChipModel.AUTO;
    @Parameter(names={"--defaultModel", "-u"}, descriptionKey="DEFAULT_MODEL")
    private ChipModel defaultModel = IniDefaults.DEFAULT_SID_MODEL;
    @Parameter(names={"--startTime", "-t"}, descriptionKey="START_TIME", converter=ParameterTimeConverter.class)
    private Integer startTime = 0;
    @Parameter(names={"--defaultLength", "-g"}, descriptionKey="DEFAULT_LENGTH", converter=ParameterTimeConverter.class)
    private Integer defaultLength = IniDefaults.DEFAULT_PLAY_LENGTH;
    @Parameter(names={"--enableSidDatabase", "-n"}, descriptionKey="ENABLE_SID_DATABASE", arity=1)
    private Boolean enableSidDatabase = IniDefaults.DEFAULT_ENABLE_DATABASE;
    @Parameter(names={"--verbose", "-v"}, descriptionKey="VERBOSE", validateWith=VerboseValidator.class)
    private Integer verbose = 0;
    @Parameter(names={"--quiet", "-q"}, descriptionKey="QUIET")
    private Boolean quiet = Boolean.FALSE;
    @Parameter(description="filename")
    private List<String> filenames = new ArrayList<String>();

    private ConsolePlayer(String[] args) {
        try {
            JCommander commander = new JCommander((Object)this, args);
            commander.setProgramName(this.getClass().getName());
            commander.setCaseSensitiveOptions(true);
            Optional filename = this.filenames.stream().findFirst();
            if (this.help.booleanValue() || !filename.isPresent()) {
                commander.usage();
                this.printSoundcardDevices();
                this.exit(1);
            }
            if (this.isRecording()) {
                System.out.println("Warning: Loop has been disabled while recording audio files!");
                this.loop = false;
            }
            IniConfig config = new IniConfig(true);
            config.getSidplay2Section().setLoop(this.loop);
            config.getSidplay2Section().setSingle(this.single);
            config.getSidplay2Section().setDefaultPlayLength(this.defaultLength);
            config.getSidplay2Section().setEnableDatabase(this.enableSidDatabase);
            config.getAudioSection().setAudio(this.audio);
            config.getAudioSection().setSamplingRate(this.samplingRate);
            config.getAudioSection().setBufferSize(this.bufferSize);
            config.getAudioSection().setDevice(this.deviceIdx);
            config.getEmulationSection().setEngine(this.engine);
            config.getEmulationSection().setDefaultEmulation(this.defaultEmulation);
            config.getEmulationSection().setForceStereoTune(this.dualSID);
            config.getEmulationSection().setForce3SIDTune(this.thirdSID);
            config.getEmulationSection().setUserClockSpeed(this.forceClock);
            config.getEmulationSection().setDefaultClockSpeed(this.defaultClock);
            config.getEmulationSection().setUserSidModel(this.forceModel);
            config.getEmulationSection().setDefaultSidModel(this.defaultModel);
            config.getEmulationSection().setFilter(this.disableFilter == false);
            config.getEmulationSection().setStereoFilter(this.disableStereoFilter == false);
            config.getEmulationSection().setThirdSIDFilter(this.disable3rdSIDFilter == false);
            SidTune tune = SidTune.load(new File((String)filename.get()));
            tune.getInfo().setSelectedSong(this.song);
            Player player = new Player(config, this.cpuDebug != false ? MOS6510Debug.class : MOS6510.class);
            player.setTune(tune);
            player.getTimer().setStart(this.startTime);
            ConsoleIO consoleIO = new ConsoleIO(config, (String)filename.get());
            player.setMenuHook(obj -> consoleIO.menu((Player)obj, this.verbose, this.quiet, System.out));
            player.setInteractivityHook(obj -> consoleIO.decodeKeys((Player)obj));
            if (config.getSidplay2Section().isEnableDatabase()) {
                this.setSIDDatabase(player);
            }
            player.setRecordingFilenameProvider(theTune -> {
                File file = new File(this.recordingFilename);
                String basename = new File(file.getParentFile(), PathUtils.getFilenameWithoutSuffix(file.getName())).getAbsolutePath();
                if (theTune.getInfo().getSongs() > 1) {
                    basename = basename + String.format("-%02d", theTune.getInfo().getCurrentSong());
                }
                return basename;
            });
            if (this.isRecording() && this.defaultLength <= 0 && player.getSidDatabaseInfo(db -> db.getSongLength(tune), 0) == 0) {
                System.err.println("ERROR: unknown song length in record mode (please use option --defaultLength or configure song length database)");
                this.exit(1);
            }
            player.startC64();
        }
        catch (ParameterException | IOException | SidTuneError e) {
            System.err.println(e.getMessage());
            this.exit(1);
        }
    }

    private void setSIDDatabase(Player player) {
        String hvscRoot = player.getConfig().getSidplay2Section().getHvsc();
        if (hvscRoot != null) {
            File file = new File(hvscRoot, "DOCUMENTS/Songlengths.txt");
            try (FileInputStream input = new FileInputStream(file);){
                player.setSidDatabase(new SidDatabase(input));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private boolean isRecording() {
        return this.audio == Audio.WAV || this.audio == Audio.MP3 || this.audio == Audio.LIVE_WAV || this.audio == Audio.LIVE_MP3;
    }

    private void printSoundcardDevices() {
        int deviceIdx = 0;
        for (JavaSound.Device device : JavaSound.getDevices()) {
            System.out.printf("    --deviceIndex %d -> %s (%s)\n", deviceIdx++, device.getInfo().getName(), device.getInfo().getDescription());
        }
    }

    private void exit(int rc) {
        try {
            System.out.println("Press <enter> to exit the player!");
            System.in.read();
            System.exit(rc);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
    }

    public static void main(String[] args) {
        new ConsolePlayer(args);
    }
}

