/*
 * Decompiled with CFR 0.152.
 */
package resid_builder.residfp;

import libsidplay.common.ChipModel;

public final class WaveformGenerator {
    private float[][] wftable;
    private byte[][] wfdigital;
    private float[] dac;
    private int accumulator;
    private int accumulator_prev;
    private int noiseShiftRegister;
    private int noiseShiftRegisterTtl;
    private byte previous;
    private float previous_dac;
    private int freq;
    private int pw;
    private int waveform;
    private boolean test;
    private boolean ring;
    private boolean sync;

    protected void setWftable(float[][] newWftable, float[] newDac, byte[][] newWfdigital) {
        this.wftable = newWftable;
        this.wfdigital = newWfdigital;
        this.dac = newDac;
    }

    protected void clock() {
        if (this.test) {
            if (this.noiseShiftRegisterTtl != 0 && --this.noiseShiftRegisterTtl == 0) {
                this.noiseShiftRegister |= 0x7FFFFC;
                this.clockNoise(false);
            }
            return;
        }
        this.accumulator_prev = this.accumulator;
        this.accumulator = this.accumulator + this.freq & 0xFFFFFF;
        if ((~this.accumulator_prev & this.accumulator & 0x80000) != 0) {
            this.clockNoise(true);
        }
    }

    protected final void synchronize(WaveformGenerator syncDest, WaveformGenerator syncSource) {
        if (syncDest.sync && (~this.accumulator_prev & this.accumulator & 0x800000) != 0 && (!this.sync || (~syncSource.accumulator_prev & syncSource.accumulator & 0x800000) == 0)) {
            syncDest.accumulator = 0;
        }
    }

    public float output(WaveformGenerator ring_modulator) {
        if (this.waveform == 0 || this.waveform > 7) {
            return this.previous_dac;
        }
        int phase = this.accumulator >> 12;
        int variant = this.waveform >= 4 && (this.test || phase >= this.pw) ? 3 : -1;
        return this.wftable[this.waveform + variant][phase ^= this.ring && 0 != (ring_modulator.accumulator & 0x800000) ? 2048 : 0];
    }

    protected WaveformGenerator() {
    }

    protected void writeFREQ_LO(byte freq_lo) {
        this.freq = this.freq & 0xFF00 | freq_lo & 0xFF;
    }

    protected void writeFREQ_HI(byte freq_hi) {
        this.freq = freq_hi << 8 & 0xFF00 | this.freq & 0xFF;
    }

    protected void writePW_LO(byte pw_lo) {
        this.pw = this.pw & 0xF00 | pw_lo & 0xFF;
    }

    protected void writePW_HI(byte pw_hi) {
        this.pw = pw_hi << 8 & 0xF00 | this.pw & 0xFF;
    }

    protected void writeCONTROL_REG(WaveformGenerator ring_modulator, byte control) {
        boolean test_next;
        int waveform_next = control >> 4 & 0xF;
        if (waveform_next == 0 && this.waveform >= 1 && this.waveform <= 7) {
            this.previous = this.readOSC6581(ring_modulator);
            this.previous_dac = this.output(ring_modulator);
        }
        this.waveform = waveform_next;
        this.ring = (control & 4) != 0 && (this.waveform & 3) == 1;
        this.sync = (control & 2) != 0;
        boolean bl = test_next = (control & 8) != 0;
        if (test_next && !this.test) {
            this.accumulator = 0;
            this.accumulator_prev = 0;
            int bit19 = this.noiseShiftRegister >> 18 & 2;
            this.noiseShiftRegister = this.noiseShiftRegister & 0x7FFFFD | bit19 ^ 2;
            this.noiseShiftRegisterTtl = 200000;
        } else if (!test_next) {
            this.clockNoise(this.test);
        }
        this.test = test_next;
    }

    protected byte readOSC6581(WaveformGenerator ring_modulator) {
        return this.readOSC(ring_modulator.accumulator, this.accumulator);
    }

    protected byte readOSC8580(WaveformGenerator ring_modulator) {
        return this.readOSC(ring_modulator.accumulator_prev, this.accumulator_prev);
    }

    public byte readOSC(ChipModel model) {
        if (model == ChipModel.MOS6581) {
            return this.readOSC6581(this);
        }
        return this.readOSC8580(this);
    }

    private byte readOSC(int ringAccumulator, int myAccumulator) {
        if (this.waveform == 0 || this.waveform >= 8) {
            return this.previous;
        }
        int phase = myAccumulator >> 12;
        int variant = this.waveform >= 4 && (this.test || phase >= this.pw) ? 3 : -1;
        return this.wfdigital[this.waveform + variant][phase ^= this.ring && 0 != (ringAccumulator & 0x800000) ? 2048 : 0];
    }

    private void clockNoise(boolean clock) {
        if (clock) {
            int bit0 = (this.noiseShiftRegister >> 22 ^ this.noiseShiftRegister >> 17) & 1;
            this.noiseShiftRegister = this.noiseShiftRegister << 1 | bit0;
        }
        if (this.waveform > 8) {
            this.noiseShiftRegister &= 0x2ED76B;
        }
        if (this.waveform >= 8) {
            this.previous = this.calculateCurrentNoiseValue();
            this.previous_dac = this.getZeroLevel();
            for (int i = 0; i < 8; ++i) {
                if ((this.previous & 1 << i) == 0) continue;
                this.previous_dac += this.dac[i + 4];
            }
        }
    }

    private byte calculateCurrentNoiseValue() {
        return (byte)((this.noiseShiftRegister & 0x400000) >> 15 | (this.noiseShiftRegister & 0x100000) >> 14 | (this.noiseShiftRegister & 0x10000) >> 11 | (this.noiseShiftRegister & 0x2000) >> 9 | (this.noiseShiftRegister & 0x800) >> 8 | (this.noiseShiftRegister & 0x80) >> 5 | (this.noiseShiftRegister & 0x10) >> 3 | (this.noiseShiftRegister & 4) >> 2);
    }

    protected void reset() {
        this.accumulator = 0;
        this.accumulator_prev = 0;
        this.previous = 0;
        this.previous_dac = 0.0f;
        this.noiseShiftRegister = 0x7FFFFC;
        this.freq = 0;
        this.pw = 0;
        this.test = false;
        this.waveform = 0;
        this.writeCONTROL_REG(this, (byte)0);
    }

    public float getZeroLevel() {
        return this.wftable[0][0];
    }
}

