/*
 * Decompiled with CFR 0.152.
 */
package resid_builder.residfp;

import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.Map;
import libsidplay.common.ChipModel;
import resid_builder.residfp.SID;

public final class WaveformCalculator {
    private static final Map<String, float[][]> WFTABLE_CACHE = new HashMap<String, float[][]>();
    private static final Map<String, byte[][]> WFDIGITAL_CACHE = new HashMap<String, byte[][]>();
    private static final float sharpness = 512.0f;
    private static final CombinedWaveformConfig[][] wfconfig = new CombinedWaveformConfig[][]{{new CombinedWaveformConfig(0.880815f, 0.0f, 0.0f, 0.3279614f, 0.5999545f), new CombinedWaveformConfig(0.8924618f, 2.014781f, 1.003332f, 0.02992322f, 0.0f), new CombinedWaveformConfig(0.8646501f, 1.712586f, 1.137704f, 0.02845423f, 0.0f), new CombinedWaveformConfig(0.9527834f, 1.794777f, 0.0f, 0.09806272f, 0.7752482f), new CombinedWaveformConfig(0.5f, 0.0f, 1.0f, 0.0f, 0.0f)}, {new CombinedWaveformConfig(0.9781665f, 0.0f, 0.9899469f, 8.087667f, 0.8226412f), new CombinedWaveformConfig(0.9097769f, 2.039997f, 0.9584096f, 0.1765447f, 0.0f), new CombinedWaveformConfig(0.9231212f, 2.084788f, 0.9493895f, 0.1712518f, 0.0f), new CombinedWaveformConfig(0.9845552f, 1.415612f, 0.9703883f, 3.68829f, 0.8265008f), new CombinedWaveformConfig(0.5f, 0.0f, 1.0f, 0.0f, 0.0f)}};

    private static float makeSample(float[] dac, float[] o) {
        float out = 0.0f;
        for (int i = 0; i < 12; ++i) {
            out += o[i] * dac[i];
        }
        return out;
    }

    private static byte makeDigital(float[] o) {
        byte out = 0;
        for (int i = 11; i >= 4; --i) {
            out = (byte)(out << 1);
            if (!(o[i] > 0.5f)) continue;
            out = (byte)(out | 1);
        }
        return out;
    }

    protected static Object[] rebuildWftable(ChipModel model, float nonlinearity) {
        float[] dac = new float[12];
        for (int i = 0; i < 12; ++i) {
            dac[i] = SID.kinkedDac(1 << i, nonlinearity, 12);
        }
        String key = nonlinearity + "," + (Object)((Object)model);
        if (!WFTABLE_CACHE.containsKey(key)) {
            float wave_zero = model == ChipModel.MOS6581 ? -896.0f : -2048.0f;
            float[] o = new float[12];
            float[][] wftable = new float[11][4096];
            byte[][] wfdigital = new byte[11][4096];
            for (int waveform = 1; waveform < 8; ++waveform) {
                for (int accumulator = 0; accumulator < 0x1000000; accumulator += 4096) {
                    WaveformCalculator.fillInWaveformSample(o, model, waveform, accumulator, 4096);
                    wftable[waveform - 1][accumulator >> 12] = WaveformCalculator.makeSample(dac, o) + wave_zero;
                    wfdigital[waveform - 1][accumulator >> 12] = WaveformCalculator.makeDigital(o);
                    if (waveform < 4) continue;
                    WaveformCalculator.fillInWaveformSample(o, model, waveform, accumulator, 0);
                    wftable[waveform + 3][accumulator >> 12] = WaveformCalculator.makeSample(dac, o) + wave_zero;
                    wfdigital[waveform + 3][accumulator >> 12] = WaveformCalculator.makeDigital(o);
                }
            }
            WFTABLE_CACHE.put(key, wftable);
            WFDIGITAL_CACHE.put(key, wfdigital);
        }
        return new Object[]{WFTABLE_CACHE.get(key), dac, WFDIGITAL_CACHE.get(key)};
    }

    private static void populate(int v, float[] o) {
        int j = 1;
        for (int i = 0; i < 12; ++i) {
            o[i] = (v & j) != 0 ? 1.0f : 0.0f;
            j <<= 1;
        }
    }

    private static void fillInWaveformSample(float[] o, ChipModel model, int waveform, int accumulator, int pw) {
        int i;
        if (waveform == 4) {
            WaveformCalculator.populate(accumulator >> 12 >= pw ? 4095 : 0, o);
            return;
        }
        CombinedWaveformConfig config = wfconfig[model == ChipModel.MOS6581 ? 0 : 1][waveform == 3 ? 0 : (waveform == 5 ? 1 : (waveform == 6 ? 2 : (waveform == 7 ? 3 : 4)))];
        WaveformCalculator.populate(accumulator >> 12, o);
        if ((waveform & 3) == 1) {
            boolean top = (accumulator & 0x800000) != 0;
            for (i = 11; i > 0; --i) {
                o[i] = top ? 1.0f - o[i - 1] : o[i - 1];
            }
            o[0] = 0.0f;
        }
        if ((waveform & 3) == 3) {
            o[0] = o[0] * config.stmix;
            for (i = 1; i < 12; ++i) {
                o[i] = o[i - 1] * (1.0f - config.stmix) + o[i] * config.stmix;
            }
        }
        o[11] = o[11] * config.topbit;
        if (waveform == 3 || waveform > 4) {
            float[] distancetable = new float[25];
            for (i = 0; i <= 12; ++i) {
                float f = 1.0f / (1.0f + (float)(i * i) * config.distance);
                distancetable[12 - i] = f;
                distancetable[12 + i] = f;
            }
            float pulse = accumulator >> 12 >= pw ? 1.0f : -1.0f;
            pulse *= config.pulsestrength;
            float[] tmp = new float[12];
            for (i = 0; i < 12; ++i) {
                float avg = 0.0f;
                float n = 0.0f;
                for (int j = 0; j < 12; ++j) {
                    float weight = distancetable[i - j + 12];
                    avg += o[j] * weight;
                    n += weight;
                }
                if (waveform > 4) {
                    float weight = distancetable[i - 12 + 12];
                    avg += pulse * weight;
                    n += weight;
                }
                tmp[i] = (o[i] + avg / n) * 0.5f;
            }
            for (i = 0; i < 12; ++i) {
                o[i] = tmp[i];
            }
        }
        for (i = 0; i < 12; ++i) {
            o[i] = (o[i] - config.bias) * 512.0f;
            int n = i;
            o[n] = o[n] + 0.5f;
            if (o[i] > 1.0f) {
                o[i] = 1.0f;
            }
            if (!(o[i] < 0.0f)) continue;
            o[i] = 0.0f;
        }
    }

    public static void main(String[] args) {
        Object[] data6581 = WaveformCalculator.rebuildWftable(ChipModel.MOS6581, 0.96f);
        Object[] data8580 = WaveformCalculator.rebuildWftable(ChipModel.MOS8580, 1.0f);
        WaveformCalculator.dump("MOS6581", data6581);
        WaveformCalculator.dump("MOS8580", data8580);
    }

    private static void dump(String basename, Object[] data) {
        float[][] wftable = (float[][])data[0];
        float[] dac = (float[])data[1];
        byte[][] digitable = (byte[][])data[2];
        String dir = "c:/Users/AL/Desktop/";
        try {
            int j;
            int i;
            DataOutputStream output = new DataOutputStream(new FileOutputStream(dir + basename + "_wave.dat", false));
            for (i = 0; i < wftable.length; ++i) {
                for (j = 0; j < wftable[i].length; ++j) {
                    output.writeInt(Math.round(wftable[i][j]));
                }
            }
            output.close();
            output = new DataOutputStream(new FileOutputStream(dir + basename + "_dac.dat", false));
            for (i = 0; i < dac.length; ++i) {
                output.writeInt(Math.round(dac[i]));
            }
            output.close();
            output = new DataOutputStream(new FileOutputStream(dir + basename + "_digi.dat", false));
            for (i = 0; i < digitable.length; ++i) {
                for (j = 0; j < digitable[i].length; ++j) {
                    output.writeByte(digitable[i][j]);
                }
            }
            output.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class CombinedWaveformConfig {
        float bias;
        float pulsestrength;
        float topbit;
        float distance;
        float stmix;

        public CombinedWaveformConfig(float f, float g, float h, float i, float j) {
            this.bias = f;
            this.pulsestrength = g;
            this.topbit = h;
            this.distance = i;
            this.stmix = j;
        }
    }
}

