/*
 * Decompiled with CFR 0.152.
 */
package resid_builder.residfp;

import java.util.function.IntConsumer;
import libsidplay.common.ChipModel;
import libsidplay.common.Potentiometer;
import libsidplay.common.SIDChip;
import resid_builder.residfp.ExternalFilter;
import resid_builder.residfp.Filter;
import resid_builder.residfp.Filter6581;
import resid_builder.residfp.Filter8580;
import resid_builder.residfp.Voice;
import resid_builder.residfp.WaveformCalculator;

public class SID
implements SIDChip {
    private static final int INPUTDIGIBOOST = -38144;
    private static final float OUTPUT_LEVEL = 0.010462625f;
    public final Voice[] voice = new Voice[]{new Voice(), new Voice(), new Voice()};
    private Filter filter;
    private final Filter6581 filter6581 = new Filter6581();
    private final Filter8580 filter8580 = new Filter8580();
    private final ExternalFilter externalFilter = new ExternalFilter();
    private final Potentiometer potX = new Potentiometer(){};
    private final Potentiometer potY = new Potentiometer(){};
    private byte busValue;
    private int busValueTtl;
    private int databus_ttl;
    private ChipModel model;
    private float ext_in;
    private float nonLinearity6581;
    private boolean samplesMuted;

    public void set6581VoiceNonlinearity(float nonLinearity) {
        if (nonLinearity == this.nonLinearity6581) {
            return;
        }
        this.nonLinearity6581 = nonLinearity;
        if (this.model == ChipModel.MOS6581) {
            this.setChipModel(this.model);
        }
    }

    static float kinkedDac(int input, float nonLinearity, int maxBit) {
        float value = 0.0f;
        int currentBit = 1;
        float weight = 1.0f;
        float dir = 2.0f * nonLinearity;
        for (int i = 0; i < maxBit; ++i) {
            if ((input & currentBit) != 0) {
                value += weight;
            }
            currentBit <<= 1;
            weight *= dir;
        }
        return value / (weight / nonLinearity / nonLinearity) * (float)(1 << maxBit);
    }

    public SID() {
        this.set6581VoiceNonlinearity(0.96f);
        this.setChipModel(ChipModel.MOS8580);
        this.reset();
    }

    @Override
    public void setChipModel(ChipModel model) {
        float nonLinearity;
        this.model = model;
        int n = this.databus_ttl = model == ChipModel.MOS8580 ? 663552 : 7424;
        if (model == ChipModel.MOS6581) {
            this.filter6581.setNonLinearity(this.nonLinearity6581);
            this.filter = this.filter6581;
            nonLinearity = this.nonLinearity6581;
        } else if (model == ChipModel.MOS8580) {
            this.filter = this.filter8580;
            nonLinearity = 1.0f;
        } else {
            throw new RuntimeException("Don't know how to handle chip type " + (Object)((Object)model));
        }
        Object[] tables = WaveformCalculator.rebuildWftable(model, nonLinearity);
        for (int i = 0; i < 3; ++i) {
            this.voice[i].setChipModel(model);
            this.voice[i].envelope.setNonLinearity(nonLinearity);
            this.voice[i].wave.setWftable((float[][])tables[0], (float[])tables[1], (byte[][])tables[2]);
        }
    }

    @Override
    public ChipModel getChipModel() {
        return this.model;
    }

    @Override
    public void reset() {
        for (int i = 0; i < 3; ++i) {
            this.voice[i].reset();
        }
        this.filter6581.reset();
        this.filter8580.reset();
        this.externalFilter.reset();
        this.busValue = 0;
        this.busValueTtl = 0;
        this.samplesMuted = false;
    }

    @Override
    public void input(int value) {
        this.ext_in = (value << 4) * 3;
    }

    @Override
    public byte read(int offset) {
        byte value;
        switch (offset) {
            case 25: {
                value = this.potX.readPOT();
                this.busValueTtl = this.databus_ttl;
                break;
            }
            case 26: {
                value = this.potY.readPOT();
                this.busValueTtl = this.databus_ttl;
                break;
            }
            case 27: {
                value = this.model == ChipModel.MOS6581 ? this.voice[2].wave.readOSC6581(this.voice[0].wave) : this.voice[2].wave.readOSC8580(this.voice[0].wave);
                break;
            }
            case 28: {
                value = this.voice[2].envelope.readENV();
                this.busValueTtl = this.databus_ttl;
                break;
            }
            default: {
                value = this.busValue;
                this.busValueTtl /= 2;
            }
        }
        this.busValue = value;
        return value;
    }

    @Override
    public void write(int offset, byte value) {
        this.busValue = value;
        this.busValueTtl = this.databus_ttl;
        switch (offset) {
            case 0: {
                this.voice[0].wave.writeFREQ_LO(value);
                break;
            }
            case 1: {
                this.voice[0].wave.writeFREQ_HI(value);
                break;
            }
            case 2: {
                this.voice[0].wave.writePW_LO(value);
                break;
            }
            case 3: {
                this.voice[0].wave.writePW_HI(value);
                break;
            }
            case 4: {
                this.voice[0].writeCONTROL_REG(this.voice[1].wave, value);
                break;
            }
            case 5: {
                this.voice[0].envelope.writeATTACK_DECAY(value);
                break;
            }
            case 6: {
                this.voice[0].envelope.writeSUSTAIN_RELEASE(value);
                break;
            }
            case 7: {
                this.voice[1].wave.writeFREQ_LO(value);
                break;
            }
            case 8: {
                this.voice[1].wave.writeFREQ_HI(value);
                break;
            }
            case 9: {
                this.voice[1].wave.writePW_LO(value);
                break;
            }
            case 10: {
                this.voice[1].wave.writePW_HI(value);
                break;
            }
            case 11: {
                this.voice[1].writeCONTROL_REG(this.voice[2].wave, value);
                break;
            }
            case 12: {
                this.voice[1].envelope.writeATTACK_DECAY(value);
                break;
            }
            case 13: {
                this.voice[1].envelope.writeSUSTAIN_RELEASE(value);
                break;
            }
            case 14: {
                this.voice[2].wave.writeFREQ_LO(value);
                break;
            }
            case 15: {
                this.voice[2].wave.writeFREQ_HI(value);
                break;
            }
            case 16: {
                this.voice[2].wave.writePW_LO(value);
                break;
            }
            case 17: {
                this.voice[2].wave.writePW_HI(value);
                break;
            }
            case 18: {
                this.voice[2].writeCONTROL_REG(this.voice[0].wave, value);
                break;
            }
            case 19: {
                this.voice[2].envelope.writeATTACK_DECAY(value);
                break;
            }
            case 20: {
                this.voice[2].envelope.writeSUSTAIN_RELEASE(value);
                break;
            }
            case 21: {
                this.filter6581.writeFC_LO(value);
                this.filter8580.writeFC_LO(value);
                break;
            }
            case 22: {
                this.filter6581.writeFC_HI(value);
                this.filter8580.writeFC_HI(value);
                break;
            }
            case 23: {
                this.filter6581.writeRES_FILT(value);
                this.filter8580.writeRES_FILT(value);
                break;
            }
            case 24: {
                if (this.samplesMuted && !((float)(value & 0xF) / 15.0f >= this.filter6581.vol)) break;
                this.filter6581.writeMODE_VOL(value);
                this.filter8580.writeMODE_VOL(value);
                break;
            }
        }
    }

    @Override
    public void mute(int channel, boolean mute) {
        if (channel < 3) {
            this.voice[channel].mute(mute);
        } else {
            this.samplesMuted = mute;
        }
    }

    @Override
    public void setClockFrequency(double clockFrequency) {
        this.filter6581.setClockFrequency(clockFrequency);
        this.filter8580.setClockFrequency(clockFrequency);
        this.externalFilter.setClockFrequency(clockFrequency);
    }

    private void ageBusValue(int n) {
        if (this.busValueTtl != 0) {
            this.busValueTtl -= n;
            if (this.busValueTtl <= 0) {
                this.busValue = 0;
                this.busValueTtl = 0;
            }
        }
    }

    @Override
    public final void clock(int delta_t, IntConsumer sample) {
        this.ageBusValue(delta_t);
        for (int i = 0; i < delta_t; ++i) {
            sample.accept((int)(this.clock() * 0.010462625f));
        }
        this.filter.zeroDenormals();
        this.externalFilter.zeroDenormals();
    }

    private float clock() {
        this.voice[0].wave.clock();
        this.voice[1].wave.clock();
        this.voice[2].wave.clock();
        this.voice[0].wave.synchronize(this.voice[1].wave, this.voice[2].wave);
        this.voice[1].wave.synchronize(this.voice[2].wave, this.voice[0].wave);
        this.voice[2].wave.synchronize(this.voice[0].wave, this.voice[1].wave);
        this.voice[0].envelope.clock();
        this.voice[1].envelope.clock();
        this.voice[2].envelope.clock();
        return this.externalFilter.clock(this.filter.clock(this.voice[0].output(this.voice[2].wave), this.voice[1].output(this.voice[0].wave), this.voice[2].output(this.voice[1].wave), this.ext_in));
    }

    public Filter6581 getFilter6581() {
        return this.filter6581;
    }

    public Filter8580 getFilter8580() {
        return this.filter8580;
    }

    @Override
    public int getInputDigiBoost() {
        return this.model.equals((Object)ChipModel.MOS8580) ? -38144 : 0;
    }
}

