/*
 * Decompiled with CFR 0.152.
 */
package resid_builder.residfp;

import libsidplay.config.IFilterSection;
import resid_builder.residfp.SID;

public final class FilterModelConfig {
    private static final double sid_caps = 4.7E-10;
    private static final float dac_kinkiness = 0.96f;

    public static double estimateFrequency(IFilterSection filter, int fc) {
        if (filter.getK() == 0.0f) {
            double ik = SID.kinkedDac(fc, 0.96f, 11);
            double dynamic = (double)filter.getMinimumfetresistance() + (double)filter.getOffset() / Math.pow(filter.getSteepness(), ik);
            double R = (double)filter.getBaseresistance() * dynamic / ((double)filter.getBaseresistance() + dynamic);
            return 1.0 / (2.953097094374406E-9 * R);
        }
        return filter.getK() * (float)fc + filter.getB();
    }
}

