/*
 * Decompiled with CFR 0.152.
 */
package resid_builder.residfp;

import resid_builder.residfp.SID;

public final class EnvelopeGenerator {
    boolean hold;
    private int rateCounter;
    private int rateCounterPeriod;
    private int exponentialCounter;
    private int exponentialCounterPeriod;
    private byte envelopeValue;
    private float envelopeValueDac;
    private boolean muted;
    private int attack;
    private int decay;
    private int sustain;
    private int release;
    private boolean gate;
    private State state;
    private static final int[] ENVELOPE_PERIOD = new int[]{9, 32, 63, 95, 149, 220, 267, 313, 392, 977, 1954, 3126, 3907, 11720, 19532, 31251};
    private final float[] dac = new float[256];

    protected void clock() {
        if (++this.rateCounter != this.rateCounterPeriod) {
            return;
        }
        this.rateCounter = 0;
        if (this.state == State.ATTACK || ++this.exponentialCounter == this.exponentialCounterPeriod) {
            this.exponentialCounter = 0;
            if (this.hold) {
                return;
            }
            if (this.state == State.ATTACK) {
                this.envelopeValue = (byte)(this.envelopeValue + 1);
                if (this.envelopeValue == -1) {
                    this.state = State.DECAY_SUSTAIN;
                    this.rateCounterPeriod = ENVELOPE_PERIOD[this.decay];
                }
            } else if (this.state == State.DECAY_SUSTAIN) {
                if (this.envelopeValue != (byte)(this.sustain << 4 | this.sustain)) {
                    this.envelopeValue = (byte)(this.envelopeValue - 1);
                }
            } else if (this.state == State.RELEASE) {
                this.envelopeValue = (byte)(this.envelopeValue - 1);
            }
            switch (this.envelopeValue) {
                case -1: {
                    this.exponentialCounterPeriod = 1;
                    break;
                }
                case 93: {
                    this.exponentialCounterPeriod = 2;
                    break;
                }
                case 54: {
                    this.exponentialCounterPeriod = 4;
                    break;
                }
                case 26: {
                    this.exponentialCounterPeriod = 8;
                    break;
                }
                case 14: {
                    this.exponentialCounterPeriod = 16;
                    break;
                }
                case 6: {
                    this.exponentialCounterPeriod = 30;
                    break;
                }
                case 0: {
                    this.exponentialCounterPeriod = 1;
                    this.hold = true;
                }
            }
            this.envelopeValueDac = this.muted ? 0.0f : this.dac[this.envelopeValue & 0xFF];
        }
    }

    protected void setNonLinearity(float nonLinearity) {
        for (int i = 0; i < 256; ++i) {
            this.dac[i] = SID.kinkedDac(i, nonLinearity, 8);
        }
    }

    protected EnvelopeGenerator() {
    }

    protected void reset() {
        this.envelopeValue = 0;
        this.envelopeValueDac = 0.0f;
        this.attack = 0;
        this.decay = 0;
        this.sustain = 0;
        this.release = 0;
        this.gate = false;
        this.rateCounter = 0;
        this.exponentialCounter = 0;
        this.exponentialCounterPeriod = 1;
        this.state = State.RELEASE;
        this.hold = false;
        this.rateCounterPeriod = ENVELOPE_PERIOD[this.release];
    }

    protected void mute(boolean enable) {
        this.muted = enable;
    }

    protected void writeCONTROL_REG(byte control) {
        boolean gate_next;
        boolean bl = gate_next = (control & 1) != 0;
        if (!this.gate && gate_next) {
            this.state = State.ATTACK;
            this.cpuUpdateRatePeriod(ENVELOPE_PERIOD[this.attack]);
            this.hold = false;
        } else if (this.gate && !gate_next) {
            this.state = State.RELEASE;
            this.cpuUpdateRatePeriod(ENVELOPE_PERIOD[this.release]);
        }
        this.gate = gate_next;
    }

    protected void writeATTACK_DECAY(byte attack_decay) {
        this.attack = attack_decay >> 4 & 0xF;
        this.decay = attack_decay & 0xF;
        if (this.state == State.ATTACK) {
            this.cpuUpdateRatePeriod(ENVELOPE_PERIOD[this.attack]);
        } else if (this.state == State.DECAY_SUSTAIN) {
            this.cpuUpdateRatePeriod(ENVELOPE_PERIOD[this.decay]);
        }
    }

    protected void writeSUSTAIN_RELEASE(byte sustain_release) {
        this.sustain = sustain_release >> 4 & 0xF;
        this.release = sustain_release & 0xF;
        if (this.state == State.RELEASE) {
            this.cpuUpdateRatePeriod(ENVELOPE_PERIOD[this.release]);
        }
    }

    public byte readENV() {
        return this.envelopeValue;
    }

    public float output() {
        return this.envelopeValueDac;
    }

    private void cpuUpdateRatePeriod(int newRateCounterPeriod) {
        if (this.rateCounterPeriod == newRateCounterPeriod) {
            return;
        }
        this.rateCounterPeriod = newRateCounterPeriod;
        if (this.rateCounterPeriod - this.rateCounter > Short.MAX_VALUE) {
            this.rateCounter += Short.MAX_VALUE;
        }
        if (this.rateCounterPeriod <= this.rateCounter) {
            this.rateCounter -= Short.MAX_VALUE;
        }
    }

    private static enum State {
        ATTACK,
        DECAY_SUSTAIN,
        RELEASE;

    }
}

