/*
 * Decompiled with CFR 0.152.
 */
package resid_builder.resid;

import libsidplay.common.ChipModel;
import resid_builder.resid.SID;

public final class WaveformGenerator {
    private final short[][] model_wave = new short[8][4096];
    private final short[] dac = new short[4096];
    protected int accumulator;
    protected int accumulator_prev;
    private boolean msb_rising;
    protected int freq;
    private int pw;
    private int shift_register;
    private int shift_register_reset;
    private int shift_pipeline;
    private int ring_msb_mask;
    private int no_noise;
    private int noise_output;
    private int no_noise_or_noise_output;
    private int no_pulse;
    private int pulse_output;
    private int waveform;
    protected boolean test;
    protected boolean sync;
    private int floating_output_ttl;
    private short[] wave;
    private int waveform_output;

    protected void setWaveformModels(short[][] models) {
        for (int i = 0; i < 8; ++i) {
            System.arraycopy(models[i], 0, this.model_wave[i], 0, 4096);
        }
    }

    protected void setChipModel(ChipModel chipModel) {
        double[] dacBits = new double[12];
        SID.kinkedDac(dacBits, chipModel == ChipModel.MOS6581 ? 2.2 : 2.0, chipModel == ChipModel.MOS8580);
        for (int i = 0; i < 4096; ++i) {
            double dacValue = 0.0;
            for (int j = 0; j < 12; ++j) {
                if ((i & 1 << j) == 0) continue;
                dacValue += dacBits[j];
            }
            this.dac[i] = (short)(dacValue + 0.5);
        }
        short offset = this.dac[chipModel == ChipModel.MOS6581 ? 896 : 2048];
        int i = 0;
        while (i < 4096) {
            int n = i++;
            this.dac[n] = (short)(this.dac[n] - offset);
        }
    }

    protected void clock() {
        if (this.test) {
            if (this.shift_register_reset != 0 && --this.shift_register_reset == 0) {
                this.reset_shift_register();
            }
            this.pulse_output = 4095;
        } else {
            this.accumulator_prev = this.accumulator;
            int accumulator_next = this.accumulator + this.freq & 0xFFFFFF;
            int accumulator_bits_set = ~this.accumulator & accumulator_next;
            this.accumulator = accumulator_next;
            boolean bl = this.msb_rising = (accumulator_bits_set & 0x800000) != 0;
            if ((accumulator_bits_set & 0x80000) != 0) {
                this.shift_pipeline = 2;
            } else if (this.shift_pipeline != 0 && --this.shift_pipeline == 0) {
                this.clock_shift_register();
            }
        }
    }

    protected final void synchronize(WaveformGenerator syncDest, WaveformGenerator syncSource) {
        if (this.msb_rising && syncDest.sync && (!this.sync || !syncSource.msb_rising)) {
            syncDest.accumulator = 0;
        }
    }

    private void clock_shift_register() {
        int bit0 = (this.shift_register >> 22 ^ this.shift_register >> 17) & 1;
        this.shift_register = (this.shift_register << 1 | bit0) & 0x7FFFFF;
        this.set_noise_output();
    }

    private void write_shift_register() {
        this.shift_register &= 0xFFEBB5DA | (this.waveform_output & 0x800) << 9 | (this.waveform_output & 0x400) << 8 | (this.waveform_output & 0x200) << 5 | (this.waveform_output & 0x100) << 3 | (this.waveform_output & 0x80) << 2 | (this.waveform_output & 0x40) >> 1 | (this.waveform_output & 0x20) >> 3 | (this.waveform_output & 0x10) >> 4;
        this.noise_output &= this.waveform_output;
        this.no_noise_or_noise_output = this.no_noise | this.noise_output;
    }

    private void reset_shift_register() {
        this.shift_register = 0x7FFFFF;
        this.shift_register_reset = 0;
        this.set_noise_output();
    }

    private void set_noise_output() {
        this.noise_output = (this.shift_register & 0x100000) >> 9 | (this.shift_register & 0x40000) >> 8 | (this.shift_register & 0x4000) >> 5 | (this.shift_register & 0x800) >> 3 | (this.shift_register & 0x200) >> 2 | (this.shift_register & 0x20) << 1 | (this.shift_register & 4) << 3 | (this.shift_register & 1) << 4;
        this.no_noise_or_noise_output = this.no_noise | this.noise_output;
    }

    public short output(WaveformGenerator ringModulator) {
        if (this.waveform != 0) {
            int ix = (this.accumulator ^ ~ringModulator.accumulator & this.ring_msb_mask) >> 12;
            this.waveform_output = this.wave[ix] & (this.no_pulse | this.pulse_output) & this.no_noise_or_noise_output;
            if (this.waveform > 8 && !this.test && this.shift_pipeline != 1) {
                this.write_shift_register();
            }
        } else if (this.floating_output_ttl != 0 && --this.floating_output_ttl == 0) {
            this.waveform_output = 0;
        }
        this.pulse_output = this.accumulator >> 12 >= this.pw ? 4095 : 0;
        return this.dac[this.waveform_output];
    }

    public byte readOSC(int ringAccumulator, int myAccumulator) {
        if (this.waveform != 0) {
            int ix = (myAccumulator ^ ~ringAccumulator & this.ring_msb_mask) >> 12;
            this.waveform_output = this.wave[ix] & (this.no_pulse | this.pulse_output) & this.no_noise_or_noise_output;
            if (this.waveform > 8 && !this.test && this.shift_pipeline != 1) {
                this.write_shift_register();
            }
        } else if (this.floating_output_ttl != 0 && --this.floating_output_ttl == 0) {
            this.waveform_output = 0;
        }
        this.pulse_output = this.accumulator >> 12 >= this.pw ? 4095 : 0;
        return (byte)(this.waveform_output >> 4);
    }

    protected byte readOSC6581(WaveformGenerator ring_modulator) {
        return this.readOSC(ring_modulator.accumulator, this.accumulator);
    }

    protected byte readOSC8580(WaveformGenerator ring_modulator) {
        return this.readOSC(ring_modulator.accumulator_prev, this.accumulator_prev);
    }

    public byte readOSC(ChipModel model) {
        if (model == ChipModel.MOS6581) {
            return this.readOSC8580(this);
        }
        return this.readOSC6581(this);
    }

    protected WaveformGenerator() {
    }

    protected void writeFREQ_LO(byte freq_lo) {
        this.freq = this.freq & 0xFF00 | freq_lo & 0xFF;
    }

    protected void writeFREQ_HI(byte freq_hi) {
        this.freq = freq_hi << 8 & 0xFF00 | this.freq & 0xFF;
    }

    protected void writePW_LO(byte pw_lo) {
        this.pw = this.pw & 0xF00 | pw_lo & 0xFF;
    }

    protected void writePW_HI(byte pw_hi) {
        this.pw = pw_hi << 8 & 0xF00 | this.pw & 0xFF;
    }

    protected void writeCONTROL_REG(byte control) {
        int waveform_prev = this.waveform;
        boolean test_prev = this.test;
        this.waveform = control >> 4 & 0xF;
        this.test = (control & 8) != 0;
        this.sync = (control & 2) != 0;
        this.wave = this.model_wave[this.waveform & 7];
        this.ring_msb_mask = (~control >> 5 & control >> 2 & 1) << 23;
        this.no_noise = (this.waveform & 8) != 0 ? 0 : 4095;
        this.no_noise_or_noise_output = this.no_noise | this.noise_output;
        int n = this.no_pulse = (this.waveform & 4) != 0 ? 0 : 4095;
        if (!test_prev && this.test) {
            this.accumulator = 0;
            this.accumulator_prev = 0;
            this.shift_pipeline = 0;
            this.shift_register_reset = 32768;
        } else if (test_prev && !this.test) {
            int bit0 = ~this.shift_register >> 17 & 1;
            this.shift_register = (this.shift_register << 1 | bit0) & 0x7FFFFF;
            this.set_noise_output();
        }
        if (this.waveform == 0 && waveform_prev != 0) {
            this.floating_output_ttl = 16384;
        }
    }

    protected void reset() {
        this.accumulator_prev = 0x555555;
        this.accumulator = 0x555555;
        this.freq = 0;
        this.pw = 0;
        this.msb_rising = false;
        this.waveform = 0;
        this.test = false;
        this.sync = false;
        this.wave = this.model_wave[0];
        this.ring_msb_mask = 0;
        this.no_noise = 4095;
        this.no_pulse = 4095;
        this.pulse_output = 4095;
        this.reset_shift_register();
        this.shift_pipeline = 0;
        this.waveform_output = 0;
        this.floating_output_ttl = 0;
    }
}

