/*
 * Decompiled with CFR 0.152.
 */
package resid_builder.resid;

final class Spline {
    private final double[][] params;
    private double[] c;

    protected Spline(double[][] input) {
        this.params = new double[input.length - 1][];
        for (int i = 0; i < input.length - 1; ++i) {
            double k1;
            double k2;
            double[] p3;
            double[] p0 = i != 0 ? input[i - 1] : null;
            double[] p1 = input[i];
            double[] p2 = input[i + 1];
            double[] dArray = p3 = i != input.length - 2 ? input[i + 2] : null;
            if (p0 == null) {
                k2 = (p3[1] - p1[1]) / (p3[0] - p1[0]);
                k1 = (3.0 * (p2[1] - p1[1]) / (p2[0] - p1[0]) - k2) / 2.0;
            } else if (p3 == null) {
                k1 = (p2[1] - p0[1]) / (p2[0] - p0[0]);
                k2 = (3.0 * (p2[1] - p1[1]) / (p2[0] - p1[0]) - k1) / 2.0;
            } else {
                k1 = (p2[1] - p0[1]) / (p2[0] - p0[0]);
                k2 = (p3[1] - p1[1]) / (p3[0] - p1[0]);
            }
            double x1 = p1[0];
            double y1 = p1[1];
            double x2 = p2[0];
            double y2 = p2[1];
            double dx = x2 - x1;
            double dy = y2 - y1;
            double a = (k1 + k2 - 2.0 * dy / dx) / (dx * dx);
            double b = ((k2 - k1) / dx - 3.0 * (x1 + x2) * a) / 2.0;
            double c = k1 - (3.0 * x1 * a + 2.0 * b) * x1;
            double d = y1 - ((x1 * a + b) * x1 + c) * x1;
            this.params[i] = new double[]{x1, x2, a, b, c, d};
        }
        this.params[0][0] = Double.MIN_VALUE;
        this.params[this.params.length - 1][1] = Double.MAX_VALUE;
        this.c = this.params[0];
    }

    protected void evaluate(double x, double[] out) {
        if (x < this.c[0] || x > this.c[1]) {
            for (int i = 0; i < this.params.length; ++i) {
                if (this.params[i][1] < x) continue;
                this.c = this.params[i];
                break;
            }
        }
        double y = ((this.c[2] * x + this.c[3]) * x + this.c[4]) * x + this.c[5];
        double yd = (3.0 * this.c[2] * x + 2.0 * this.c[3]) * x + this.c[4];
        out[0] = y;
        out[1] = yd;
    }
}

