/*
 * Decompiled with CFR 0.152.
 */
package resid_builder.resid;

import libsidplay.config.IFilterSection;
import resid_builder.resid.Integrator;
import resid_builder.resid.OpAmp;
import resid_builder.resid.SID;
import resid_builder.resid.Spline;

public final class FilterModelConfig {
    private static final double[][] opamp_voltage;
    private static final double voice_voltage_range = 1.5;
    private static final double voice_DC_voltage = 5.0;
    private static final double C = 4.7E-10;
    private static final double Vdd = 12.18;
    private static final double Vth = 1.31;
    private static final double uCox_vcr = 2.0E-5;
    private static final double WL_vcr = 9.0;
    private static final double uCox_snake = 2.0E-5;
    private static final double WL_snake = 0.008695652173913044;
    private static final double dac_zero = 6.65;
    private static final double dac_scale = 2.63;
    private static final double dac_2R_div_R = 2.2;
    private static final boolean dac_term = false;
    private static final double vmin;
    private static final double norm;
    private static final double opamp_working_point;
    private static final double[] dac;
    private static final char[] vcr_Vg;
    private static final char[] vcr_n_Ids_term;
    private static final char[] opamp_rev;
    private static final char[][] mixer;
    private static final char[][] summer;
    private static final char[][] gain;

    public static double getDacZero(double adjustment) {
        return 6.65 - (adjustment - 0.5) * 2.0;
    }

    public static int getVO_T16() {
        return (int)(norm * 65535.0 * vmin);
    }

    public static int getVoiceScaleS14() {
        return (int)(norm * 16383.0 * 1.5);
    }

    public static int getVoiceDC() {
        return (int)(norm * 65535.0 * (5.0 - vmin));
    }

    public static char[][] getGain() {
        return gain;
    }

    public static char[][] getSummer() {
        return summer;
    }

    public static char[][] getMixer() {
        return mixer;
    }

    public static char[] getDAC(double dac_zero) {
        double N16 = norm * 65535.0;
        int bits = 11;
        char[] f0_dac = new char[2048];
        for (int i = 0; i < 2048; ++i) {
            double fcd = 0.0;
            for (int j = 0; j < 11; ++j) {
                if ((i & 1 << j) == 0) continue;
                fcd += dac[j];
            }
            f0_dac[i] = (char)(N16 * (dac_zero + fcd * 2.63 / 2048.0) + 0.5);
        }
        return f0_dac;
    }

    public static Integrator buildIntegrator() {
        double N16 = norm * 65535.0;
        int Vddt = (int)(N16 * 10.87 + 0.5);
        int n_snake = (int)(8192.0 / norm * 1.8501387604070305E-4 + 0.5);
        return new Integrator(vcr_Vg, vcr_n_Ids_term, opamp_rev, Vddt, n_snake);
    }

    private static double evaluateTransistor(double Vw, double vi, double vx) {
        double Vgst = 10.87 - vx;
        double Vgdt = 10.87 - vi;
        double n_snake = 8.695652173913044E-8;
        double n_I_snake = n_snake * (Vgst * Vgst - Vgdt * Vgdt);
        double Vg = 10.87 - Math.sqrt(Math.pow(10.87 - Vw, 2.0) / 2.0 + Math.pow(Vgdt, 2.0) / 2.0);
        double Vgs = Vg - vx;
        double Vgd = Vg - vi;
        double Ut = 0.026;
        double k = 1.0;
        double Is = 4.0E-5 * Ut * Ut / k * 9.0;
        double log_term_f = Math.log(1.0 + Math.exp((Vgs - k * 1.31) / (2.0 * Ut)));
        double n_I_vcr_f = Is * log_term_f * log_term_f;
        double log_term_r = Math.log(1.0 + Math.exp((Vgd - k * 1.31) / (2.0 * Ut)));
        double n_I_vcr_r = Is * log_term_r * log_term_r;
        double n_I_vcr = n_I_vcr_f - n_I_vcr_r;
        return n_I_snake + n_I_vcr;
    }

    public static double estimateFrequency(IFilterSection filter, int fc) {
        if (filter.isReSIDFilter6581()) {
            double dacZero = FilterModelConfig.getDacZero(filter.getFilter6581CurvePosition());
            int bits = 11;
            double Vw = 0.0;
            for (int j = 0; j < bits; ++j) {
                if ((fc & 1 << j) == 0) continue;
                Vw += dac[j];
            }
            Vw = dacZero + 2.63 * Vw / (double)(1 << bits);
            double vx = opamp_working_point;
            double diff = 0.2;
            double n_I = 0.0;
            n_I -= FilterModelConfig.evaluateTransistor(Vw, vx - diff, vx);
            n_I += FilterModelConfig.evaluateTransistor(Vw, vx + diff, vx);
            return (n_I /= 2.0) / (2.953097094374406E-9 * diff);
        }
        return (float)fc * filter.getFilter8580CurvePosition() / 2047.0f;
    }

    static {
        int i;
        opamp_voltage = new double[][]{{0.75, 10.02}, {2.5, 10.13}, {2.75, 10.12}, {2.9, 10.04}, {3.0, 9.92}, {3.1, 9.74}, {3.25, 9.4}, {3.5, 8.68}, {4.0, 6.9}, {4.25, 5.88}, {4.53, 4.53}, {4.75, 3.2}, {4.9, 2.3}, {4.95, 2.05}, {5.0, 1.9}, {5.1, 1.71}, {5.25, 1.57}, {5.5, 1.41}, {6.0, 1.23}, {7.5, 1.02}, {9.0, 0.93}, {10.25, 0.91}};
        dac = new double[11];
        vcr_Vg = new char[65536];
        vcr_n_Ids_term = new char[65536];
        opamp_rev = new char[65536];
        vmin = opamp_voltage[0][0];
        double vmax = 10.87;
        norm = 1.0 / (vmax - vmin);
        double wp = 0.0;
        for (int i2 = 0; i2 < opamp_voltage.length; ++i2) {
            if (opamp_voltage[i2][0] != opamp_voltage[i2][1]) continue;
            wp = opamp_voltage[i2][0];
        }
        opamp_working_point = wp;
        SID.kinkedDac(dac, 2.2, false);
        double N16 = norm * 65535.0;
        double N15 = norm * 32767.0;
        double[][] scaled_voltage = new double[opamp_voltage.length][2];
        for (int i3 = 0; i3 < opamp_voltage.length; ++i3) {
            scaled_voltage[i3][0] = (N16 * (opamp_voltage[i3][0] - opamp_voltage[i3][1]) + 65536.0) / 2.0;
            scaled_voltage[i3][1] = N16 * opamp_voltage[i3][0];
        }
        Spline s = new Spline(scaled_voltage);
        double[] out = new double[2];
        for (int x = 0; x < 65536; ++x) {
            s.evaluate(x, out);
            FilterModelConfig.opamp_rev[x] = (char)(out[0] + 0.5);
        }
        OpAmp opampModel = new OpAmp(opamp_voltage, 10.87);
        summer = new char[7][];
        for (i = 0; i < summer.length; ++i) {
            int idiv = 2 + i;
            int size = idiv << 16;
            opampModel.reset();
            FilterModelConfig.summer[i] = new char[size];
            for (int vi = 0; vi < summer[i].length; ++vi) {
                double vin = vmin + (double)vi / N16 / (double)idiv;
                FilterModelConfig.summer[i][vi] = (char)((opampModel.solve(idiv, vin) - vmin) * N16 + 0.5);
            }
        }
        mixer = new char[8][];
        for (i = 0; i < mixer.length; ++i) {
            int size = i == 0 ? 1 : i << 16;
            opampModel.reset();
            FilterModelConfig.mixer[i] = new char[size];
            for (int vi = 0; vi < mixer[i].length; ++vi) {
                double vin = vmin + (double)vi / N16 / (double)(i == 0 ? 1 : i);
                FilterModelConfig.mixer[i][vi] = (char)((opampModel.solve((double)i * 8.0 / 6.0, vin) - vmin) * N16 + 0.5);
            }
        }
        gain = new char[16][65536];
        for (int n8 = 0; n8 < gain.length; ++n8) {
            opampModel.reset();
            for (int vi = 0; vi < gain[n8].length; ++vi) {
                double vin = vmin + (double)vi / N16;
                FilterModelConfig.gain[n8][vi] = (char)((opampModel.solve((double)n8 / 8.0, vin) - vmin) * N16 + 0.5);
            }
        }
        int Vddt = (int)(N16 * 10.87 + 0.5);
        for (int i4 = 0; i4 < 65536; ++i4) {
            int Vg = Vddt - (int)(Math.sqrt((double)i4 * 65536.0) + 0.5);
            if (Vg >= 65536) {
                Vg = 65535;
            }
            FilterModelConfig.vcr_Vg[i4] = (char)Vg;
        }
        double Ut = 0.026;
        double k = 1.0;
        double Is = 4.0E-5 * Ut * Ut / k * 9.0;
        double n_Is = N15 * 1.0E-6 / 4.7E-10 * Is;
        FilterModelConfig.vcr_n_Ids_term[0] = '\u0000';
        for (int Vgx = 1; Vgx < 65536; ++Vgx) {
            double log_term = Math.log(1.0 + Math.exp(((double)Vgx / N16 - k * 1.31) / (2.0 * Ut)));
            FilterModelConfig.vcr_n_Ids_term[Vgx] = (char)(n_Is * log_term * log_term + 0.5);
        }
    }
}

