/*
 * Decompiled with CFR 0.152.
 */
package resid_builder.resample;

import resid_builder.resample.Resampler;
import resid_builder.resample.SincResampler;

public class TwoPassSincResampler
implements Resampler {
    private final SincResampler s1;
    private final SincResampler s2;

    public TwoPassSincResampler(double clockFrequency, double samplingFrequency, double highestAccurateFrequency) {
        double intermediateFrequency = 2.0 * highestAccurateFrequency + Math.sqrt(2.0 * highestAccurateFrequency * clockFrequency * (samplingFrequency - 2.0 * highestAccurateFrequency) / samplingFrequency);
        this.s1 = new SincResampler(clockFrequency, intermediateFrequency, highestAccurateFrequency);
        this.s2 = new SincResampler(intermediateFrequency, samplingFrequency, highestAccurateFrequency);
        this.reset();
    }

    @Override
    public boolean input(int sample) {
        return this.s1.input(sample) && this.s2.input(this.s1.output());
    }

    @Override
    public int output() {
        return this.s2.output();
    }

    @Override
    public void reset() {
        this.s1.reset();
        this.s2.reset();
    }
}

