/*
 * Decompiled with CFR 0.152.
 */
package resid_builder;

import java.nio.IntBuffer;
import java.util.function.IntConsumer;

class SampleMixer
implements IntConsumer {
    private IntBuffer bufferL;
    private IntBuffer bufferR;
    protected int volumeL;
    protected int volumeR;

    SampleMixer(IntBuffer audioBufferL, IntBuffer audioBufferR) {
        this.bufferL = audioBufferL;
        this.bufferR = audioBufferR;
    }

    public void setVolume(int volumeL, int volumeR) {
        this.volumeL = volumeL;
        this.volumeR = volumeR;
    }

    @Override
    public void accept(int sample) {
        this.bufferL.put(this.bufferL.get(this.bufferL.position()) + sample * this.volumeL);
        this.bufferR.put(this.bufferR.get(this.bufferR.position()) + sample * this.volumeR);
    }

    void clear() {
        this.bufferL.clear();
        this.bufferR.clear();
    }

    static class LinearFadingSampleMixer
    extends SampleMixer {
        private long fadeInClocks;
        private long fadeOutClocks;
        private int maxVolL;
        private int maxVolR;
        private long fadeInStepL;
        private long fadeInStepR;
        private long fadeOutStepL;
        private long fadeOutStepR;
        private long fadeInValL;
        private long fadeInValR;
        private long fadeOutValL;
        private long fadeOutValR;

        LinearFadingSampleMixer(IntBuffer audioBufferL, IntBuffer audioBufferR) {
            super(audioBufferL, audioBufferR);
        }

        public void setFadeIn(long fadeIn) {
            this.fadeInClocks = fadeIn;
            super.setVolume(0, 0);
            this.fadeInStepL = this.maxVolL != 0 ? this.fadeInClocks / (long)this.maxVolL : 0L;
            this.fadeInValL = this.fadeInStepL;
            this.fadeInStepR = this.maxVolR != 0 ? this.fadeInClocks / (long)this.maxVolR : 0L;
            this.fadeInValR = this.fadeInStepR;
        }

        public void setFadeOut(long fadeOut) {
            this.fadeOutClocks = fadeOut;
            super.setVolume(this.maxVolL, this.maxVolR);
            this.fadeOutStepL = this.maxVolL != 0 ? this.fadeOutClocks / (long)this.maxVolL : 0L;
            this.fadeOutValL = this.fadeOutStepL;
            this.fadeOutStepR = this.maxVolR != 0 ? this.fadeOutClocks / (long)this.maxVolR : 0L;
            this.fadeOutValR = this.fadeOutStepR;
        }

        @Override
        public void setVolume(int volumeL, int volumeR) {
            super.setVolume(volumeL, volumeR);
            this.maxVolL = volumeL;
            this.maxVolR = volumeR;
        }

        @Override
        public void accept(int sample) {
            if (this.fadeInClocks > 0L) {
                --this.fadeInClocks;
                if (--this.fadeInValL == 0L) {
                    this.fadeInValL = this.fadeInStepL;
                    ++this.volumeL;
                }
                if (--this.fadeInValR == 0L) {
                    this.fadeInValR = this.fadeInStepR;
                    ++this.volumeR;
                }
            } else if (this.fadeOutClocks > 0L) {
                --this.fadeOutClocks;
                if (--this.fadeOutValL == 0L) {
                    this.fadeOutValL = this.fadeOutStepL;
                    --this.volumeL;
                }
                if (--this.fadeOutValR == 0L) {
                    this.fadeOutValR = this.fadeOutStepR;
                    --this.volumeR;
                }
            }
            super.accept(sample);
        }
    }
}

