/*
 * Decompiled with CFR 0.152.
 */
package resid_builder;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import libsidplay.common.CPUClock;
import libsidplay.common.Event;
import libsidplay.common.EventScheduler;
import libsidplay.common.Mixer;
import libsidplay.common.SamplingMethod;
import libsidplay.config.IAudioSection;
import libsidplay.config.IConfig;
import libsidplay.config.ISidPlay2Section;
import resid_builder.ReSIDBase;
import resid_builder.SampleMixer;
import resid_builder.resample.Resampler;
import sidplay.audio.AudioDriver;

public class SIDMixer
implements Mixer {
    private static final int VOLUME_SCALER = 10;
    protected final EventScheduler context;
    protected final IConfig config;
    protected final CPUClock cpuClock;
    protected final List<ReSIDBase> sids = new ArrayList<ReSIDBase>(3);
    private final MixerEvent mixerAudio = new MixerEvent("MixerAudio");
    private final IntBuffer audioBufferL;
    private final IntBuffer audioBufferR;
    private final int bufferSize;
    private final Resampler resamplerL;
    private final Resampler resamplerR;
    private final AudioDriver driver;
    private final int[] volume = new int[3];
    private final float[] positionL = new float[3];
    private final float[] positionR = new float[3];
    private final boolean fadeInFadeOutEnabled;
    private final ByteBuffer buffer;

    public SIDMixer(EventScheduler context, IConfig config, CPUClock cpuClock, AudioDriver audioDriver) {
        this.context = context;
        this.config = config;
        this.cpuClock = cpuClock;
        this.driver = audioDriver;
        IAudioSection audioSection = config.getAudioSection();
        this.buffer = this.driver.buffer();
        this.bufferSize = audioSection.getBufferSize();
        this.audioBufferL = ByteBuffer.allocateDirect(4 * this.bufferSize).order(ByteOrder.nativeOrder()).asIntBuffer();
        this.audioBufferR = ByteBuffer.allocateDirect(4 * this.bufferSize).order(ByteOrder.nativeOrder()).asIntBuffer();
        SamplingMethod samplingMethod = audioSection.getSampling();
        int samplingFrequency = audioSection.getSamplingRate().getFrequency();
        this.resamplerL = Resampler.createResampler(cpuClock.getCpuFrequency(), samplingMethod, samplingFrequency, 20000.0);
        this.resamplerR = Resampler.createResampler(cpuClock.getCpuFrequency(), samplingMethod, samplingFrequency, 20000.0);
        ISidPlay2Section sidplay2Section = config.getSidplay2Section();
        this.fadeInFadeOutEnabled = sidplay2Section.getFadeInTime() != 0 || sidplay2Section.getFadeOutTime() != 0;
        this.normalSpeed();
    }

    @Override
    public void start() {
        this.context.schedule(this.mixerAudio, 0L, Event.Phase.PHI2);
    }

    @Override
    public void fadeIn(int fadeIn) {
        for (ReSIDBase sid : this.sids) {
            SampleMixer.LinearFadingSampleMixer sampler = (SampleMixer.LinearFadingSampleMixer)sid.getSampler();
            sampler.setFadeIn((long)((double)fadeIn * this.cpuClock.getCpuFrequency()));
        }
    }

    @Override
    public void fadeOut(int fadeOut) {
        for (ReSIDBase sid : this.sids) {
            SampleMixer.LinearFadingSampleMixer sampler = (SampleMixer.LinearFadingSampleMixer)sid.getSampler();
            sampler.setFadeOut((long)((double)fadeOut * this.cpuClock.getCpuFrequency()));
        }
    }

    public void add(int sidNum, ReSIDBase sid) {
        if (sidNum < this.sids.size()) {
            this.sids.set(sidNum, sid);
        } else {
            this.sids.add(sid);
        }
        this.createSampleMixer(sid);
        this.setVolume(sidNum, this.config.getAudioSection().getVolume(sidNum));
        this.setBalance(sidNum, this.config.getAudioSection().getBalance(sidNum));
    }

    public void remove(ReSIDBase sid) {
        this.sids.remove(sid);
        sid.setSampler(null);
        this.updateSampleMixerVolume();
    }

    @Override
    public void setVolume(int sidNum, float volumeInDB) {
        assert (volumeInDB >= -6.0f && volumeInDB <= 6.0f);
        this.volume[sidNum] = (int)(SIDMixer.DECIBEL_TO_LINEAR(volumeInDB) * 1024.0);
        this.updateSampleMixerVolume();
    }

    private static double DECIBEL_TO_LINEAR(float decibel) {
        return Math.pow(10.0, (double)decibel / 20.0);
    }

    @Override
    public void setBalance(int sidNum, float balance) {
        assert (balance >= 0.0f && balance <= 1.0f);
        this.positionL[sidNum] = 1.0f - balance;
        this.positionR[sidNum] = balance;
        this.updateSampleMixerVolume();
    }

    private void createSampleMixer(ReSIDBase sid) {
        IntBuffer intBufferL = this.audioBufferL.duplicate();
        IntBuffer intBufferR = this.audioBufferR.duplicate();
        if (this.fadeInFadeOutEnabled) {
            sid.setSampler(new SampleMixer.LinearFadingSampleMixer(intBufferL, intBufferR));
        } else {
            sid.setSampler(new SampleMixer(intBufferL, intBufferR));
        }
    }

    private void updateSampleMixerVolume() {
        boolean mono = this.sids.size() == 1;
        int sidNum = 0;
        for (ReSIDBase sid : this.sids) {
            SampleMixer sampler = (SampleMixer)sid.getSampler();
            if (mono) {
                sampler.setVolume(this.volume[sidNum], this.volume[sidNum]);
            } else {
                float leftFraction = this.positionL[sidNum];
                float rightFraction = this.positionR[sidNum];
                int volumeL = (int)((float)this.volume[sidNum] * leftFraction);
                int volumeR = (int)((float)this.volume[sidNum] * rightFraction);
                sampler.setVolume(volumeL, volumeR);
            }
            ++sidNum;
        }
    }

    @Override
    public void fastForward() {
        this.mixerAudio.fastForwardShift = Math.min(this.mixerAudio.fastForwardShift + 1, 15);
        this.mixerAudio.fastForwardBitMask = (1 << this.mixerAudio.fastForwardShift - 10) - 1;
    }

    @Override
    public void normalSpeed() {
        this.mixerAudio.fastForwardShift = 10;
        this.mixerAudio.fastForwardBitMask = 0;
    }

    @Override
    public boolean isFastForward() {
        return this.mixerAudio.fastForwardShift - 10 != 0;
    }

    @Override
    public int getFastForwardBitMask() {
        return this.mixerAudio.fastForwardBitMask;
    }

    private final class MixerEvent
    extends Event {
        private final Random RANDOM;
        private int oldRandomValue;
        private int fastForwardShift;
        private int fastForwardBitMask;

        private MixerEvent(String name) {
            super(name);
            this.RANDOM = new Random();
        }

        @Override
        public void event() throws InterruptedException {
            int i;
            for (ReSIDBase sid : SIDMixer.this.sids) {
                SampleMixer sampler = (SampleMixer)sid.getSampler();
                sid.clock();
                sampler.clear();
            }
            int valL = 0;
            int valR = 0;
            for (i = 0; i < SIDMixer.this.bufferSize; ++i) {
                valL += SIDMixer.this.audioBufferL.get();
                valR += SIDMixer.this.audioBufferR.get();
                if ((i & this.fastForwardBitMask) != this.fastForwardBitMask) continue;
                int dither = this.triangularDithering();
                if (SIDMixer.this.resamplerL.input(valL >> this.fastForwardShift)) {
                    SIDMixer.this.buffer.putShort((short)Math.max(Math.min(SIDMixer.this.resamplerL.output() + dither, Short.MAX_VALUE), Short.MIN_VALUE));
                }
                if (SIDMixer.this.resamplerR.input(valR >> this.fastForwardShift) && !SIDMixer.this.buffer.putShort((short)Math.max(Math.min(SIDMixer.this.resamplerR.output() + dither, Short.MAX_VALUE), Short.MIN_VALUE)).hasRemaining()) {
                    SIDMixer.this.driver.write();
                    SIDMixer.this.buffer.clear();
                }
                valR = 0;
                valL = 0;
            }
            SIDMixer.this.audioBufferL.flip();
            SIDMixer.this.audioBufferR.flip();
            for (i = 0; i < SIDMixer.this.bufferSize; ++i) {
                SIDMixer.this.audioBufferL.put(0);
                SIDMixer.this.audioBufferR.put(0);
            }
            SIDMixer.this.audioBufferL.clear();
            SIDMixer.this.audioBufferR.clear();
            SIDMixer.this.context.schedule(this, SIDMixer.this.bufferSize);
        }

        private int triangularDithering() {
            int prevValue = this.oldRandomValue;
            this.oldRandomValue = this.RANDOM.nextInt() & 1;
            return this.oldRandomValue - prevValue;
        }
    }
}

