/*
 * Decompiled with CFR 0.152.
 */
package netsiddev_builder.commands;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.util.Pair;
import libsidplay.common.ChipModel;
import netsiddev.Command;
import netsiddev_builder.commands.NetSIDPkg;

public class TrySetSidModel
implements NetSIDPkg {
    private final byte sidNum;
    private final byte config;
    private static Map<Pair<ChipModel, String>, Byte> FILTER_TO_SID_MODEL = new HashMap<Pair<ChipModel, String>, Byte>();

    public TrySetSidModel(byte sidNum, ChipModel chipModel, String filterName) {
        this.sidNum = sidNum;
        Optional<Pair> configuration = FILTER_TO_SID_MODEL.keySet().stream().filter(p -> ((String)p.getValue()).equals(filterName) && ((ChipModel)((Object)((Object)p.getKey()))).equals((Object)chipModel)).findFirst();
        if (configuration.isPresent()) {
            this.config = FILTER_TO_SID_MODEL.get(configuration.get());
        } else {
            System.err.printf("TrySetSidModel: Filter name %s not found!", filterName);
            Optional filter = TrySetSidModel.getFilterNames(chipModel).stream().findFirst();
            if (filter.isPresent()) {
                this.config = FILTER_TO_SID_MODEL.get(new Pair((Object)chipModel, filter.get()));
                System.err.printf("  TrySetSidModel: Use first configuration of chip model=%s, instead!\n", new Object[]{chipModel});
            } else {
                System.err.println("  TrySetSidModel: Use first avalable configuration, instead!");
                this.config = 0;
            }
        }
    }

    public TrySetSidModel(byte sidNum, byte config) {
        this.sidNum = sidNum;
        this.config = config;
    }

    public static Map<Pair<ChipModel, String>, Byte> getFilterToSidModel() {
        return FILTER_TO_SID_MODEL;
    }

    public static List<String> getFilterNames(ChipModel model) {
        return FILTER_TO_SID_MODEL.keySet().stream().filter(p -> p.getKey() == model).map(p -> (String)p.getValue()).sorted((s1, s2) -> s1.compareToIgnoreCase((String)s2)).collect(Collectors.toList());
    }

    @Override
    public byte[] toByteArray() {
        return new byte[]{(byte)Command.TRY_SET_SID_MODEL.ordinal(), this.sidNum, 0, 0, this.config};
    }
}

