/*
 * Decompiled with CFR 0.152.
 */
package netsiddev_builder.commands;

import netsiddev.Command;
import netsiddev_builder.commands.TryWrite;
import netsiddev_builder.commands.Write;

public class TryRead
extends TryWrite {
    private final byte sidNumToRead;
    private final int readCycles;
    private final byte readAddr;

    public TryRead(TryWrite tryWrite, byte sidNum, int cycles, byte addr) {
        this(sidNum, cycles, addr);
        for (Write write : tryWrite.writes) {
            this.addWrite(write.getCycles(), write.getReg(), write.getData());
        }
    }

    public TryRead(byte sidNum, int cycles, byte addr) {
        this.sidNumToRead = sidNum;
        this.readCycles = cycles;
        this.readAddr = addr;
        this.cyclesSendToServer = cycles;
    }

    @Override
    public byte[] toByteArray() {
        int i = 0;
        byte[] cmd = new byte[4 + (this.writes.size() << 2) + 3];
        cmd[i++] = (byte)Command.TRY_READ.ordinal();
        cmd[i++] = this.sidNumToRead;
        cmd[i++] = 0;
        cmd[i++] = 0;
        for (Write write : this.writes) {
            cmd[i++] = (byte)(write.getCycles() >> 8 & 0xFF);
            cmd[i++] = (byte)(write.getCycles() & 0xFF);
            cmd[i++] = write.getReg();
            cmd[i++] = write.getData();
        }
        cmd[i++] = (byte)(this.readCycles >> 8 & 0xFF);
        cmd[i++] = (byte)(this.readCycles & 0xFF);
        cmd[i++] = this.readAddr;
        return cmd;
    }
}

