/*
 * Decompiled with CFR 0.152.
 */
package netsiddev_builder;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.Charset;

public class NetSIDDevConnection {
    private static final int SOCKET_CONNECT_TIMEOUT = 5000;
    private static final int MAX_STRING_LENGTH = 255;
    private static final Charset ISO_8859_1 = Charset.forName("ISO-8859-1");
    private boolean invalidated;
    private Socket connectedSocket;
    private byte[] stringBytes = new byte[255];
    private static NetSIDDevConnection connection;

    private NetSIDDevConnection() {
    }

    public static final NetSIDDevConnection getInstance() {
        if (connection == null) {
            connection = new NetSIDDevConnection();
        }
        return connection;
    }

    public void open(String hostname, int port) throws IOException {
        if (connection.isInvalidated()) {
            connection.close();
        }
        if (connection.isClosed()) {
            connection.connect(hostname, port);
        }
    }

    private void connect(String hostname, int port) throws IOException {
        this.connectedSocket = new Socket();
        System.out.printf("Try to connect to NetworkSIDDevice: %s (%d)\n", hostname, port);
        this.connectedSocket.connect(new InetSocketAddress(hostname, port), 5000);
        System.out.printf("Connected to NetworkSIDDevice: %s (%d)\n", hostname, port);
    }

    public void close() {
        if (!this.isClosed()) {
            try {
                this.connectedSocket.close();
                System.out.println("Disconnected from NetworkSIDDevice");
            }
            catch (IOException e) {
                System.err.println("NetworkSIDDevice socket cannot be closed!");
            }
        }
        this.invalidated = false;
    }

    private boolean isClosed() {
        return this.connectedSocket == null || this.connectedSocket.isClosed();
    }

    public void invalidate() {
        this.invalidated = true;
    }

    public boolean isInvalidated() {
        return this.invalidated;
    }

    public void send(byte[] cmd) throws IOException {
        this.connectedSocket.getOutputStream().write(cmd);
    }

    public int receive() throws IOException {
        return this.connectedSocket.getInputStream().read();
    }

    public String receiveString() throws IOException {
        int chIdx;
        for (chIdx = 0; chIdx < this.stringBytes.length; ++chIdx) {
            this.connectedSocket.getInputStream().read(this.stringBytes, chIdx, 1);
            if (this.stringBytes[chIdx] <= 0) break;
        }
        return new String(this.stringBytes, 0, chIdx, ISO_8859_1);
    }

    public boolean isDisconnected() {
        return connection.isInvalidated() || connection.isClosed();
    }
}

