/*
 * Decompiled with CFR 0.152.
 */
package netsiddev_builder;

import java.util.ArrayList;
import java.util.List;
import libsidplay.common.CPUClock;
import libsidplay.common.ChipModel;
import libsidplay.common.Emulation;
import libsidplay.common.Engine;
import libsidplay.common.EventScheduler;
import libsidplay.common.Mixer;
import libsidplay.common.SIDBuilder;
import libsidplay.common.SIDEmu;
import libsidplay.config.IAudioSection;
import libsidplay.config.IConfig;
import libsidplay.config.IEmulationSection;
import libsidplay.sidtune.SidTune;
import netsiddev_builder.NetSIDClient;
import netsiddev_builder.NetSIDDev;
import netsiddev_builder.commands.Flush;
import netsiddev_builder.commands.Mute;
import netsiddev_builder.commands.SetClocking;
import netsiddev_builder.commands.SetSidLevel;
import netsiddev_builder.commands.SetSidPosition;
import netsiddev_builder.commands.TrySetSampling;
import netsiddev_builder.commands.TrySetSidModel;

public class NetSIDDevBuilder
implements SIDBuilder,
Mixer {
    private final IConfig config;
    private final CPUClock cpuClock;
    private final NetSIDClient client;
    private final List<NetSIDDev> sids = new ArrayList<NetSIDDev>();

    public NetSIDDevBuilder(EventScheduler context, IConfig config, SidTune tune, CPUClock cpuClock) {
        this.config = config;
        this.cpuClock = cpuClock;
        this.client = new NetSIDClient(context, config.getEmulationSection());
    }

    @Override
    public SIDEmu lock(SIDEmu sidEmu, int sidNum, SidTune tune) {
        IAudioSection audioSection = this.config.getAudioSection();
        IEmulationSection emulationSection = this.config.getEmulationSection();
        ChipModel chipModel = ChipModel.getChipModel(emulationSection, tune, sidNum);
        String filterName = emulationSection.getFilterName(sidNum, Engine.NETSID, Emulation.DEFAULT, chipModel);
        NetSIDDev sid = this.createSID(emulationSection, chipModel, sidEmu, tune, sidNum);
        this.client.init((byte)15);
        this.client.add(new TrySetSampling(audioSection.getSampling()));
        this.client.add(new TrySetSidModel((byte)sidNum, chipModel, filterName));
        this.client.add(new SetClocking(this.cpuClock.getCpuFrequency()));
        for (byte sidNum2 = 0; sidNum2 < 3; sidNum2 = (byte)((byte)(sidNum2 + 1))) {
            for (byte voice = 0; voice < (this.client.getVersion() < 3 ? (byte)3 : 4); voice = (byte)(voice + 1)) {
                this.client.add(new Mute(sidNum2, voice, emulationSection.isMuteVoice(sidNum2, voice)));
            }
        }
        this.client.softFlush();
        for (int addr = 0; sidEmu != null && addr < 32; addr = (int)((byte)(addr + 1))) {
            sid.write(addr, sidEmu.readInternalRegister(addr));
        }
        if (sidNum < this.sids.size()) {
            this.sids.set(sidNum, sid);
        } else {
            this.sids.add(sid);
        }
        this.updateMixer(audioSection);
        return sid;
    }

    @Override
    public void unlock(SIDEmu device) {
        this.client.init((byte)0);
        this.sids.remove(device);
        this.updateMixer(this.config.getAudioSection());
    }

    private NetSIDDev createSID(IEmulationSection emulationSection, ChipModel chipModel, SIDEmu sidEmu, SidTune tune, int sidNum) {
        if (SidTune.isFakeStereoSid(emulationSection, tune, sidNum)) {
            return new NetSIDDev.FakeStereo(this.client, sidNum, chipModel, this.config, this.sids);
        }
        return new NetSIDDev(this.client, sidNum, chipModel);
    }

    private void updateMixer(IAudioSection audioSection) {
        for (int sidNum = 0; sidNum < this.sids.size(); ++sidNum) {
            this.setVolume(sidNum, audioSection.getVolume(sidNum));
            this.setBalance(sidNum, audioSection.getBalance(sidNum));
        }
        this.client.softFlush();
    }

    @Override
    public void start() {
        this.client.start();
    }

    @Override
    public void fadeIn(int fadeIn) {
        System.err.println("Fade-in unsupported by network SID client");
    }

    @Override
    public void fadeOut(int fadeOut) {
        System.err.println("Fade-out unsupported by network SID client");
    }

    @Override
    public void setVolume(int sidNum, float volume) {
        float level = -50.0f + (volume + 6.0f) / 12.0f * 100.0f;
        this.client.add(new SetSidLevel((byte)sidNum, (byte)level));
    }

    @Override
    public void setBalance(int sidNum, float balance) {
        boolean isMono;
        boolean bl = isMono = this.sids.size() == 1;
        if (isMono) {
            this.client.add(new SetSidPosition((byte)sidNum, 0));
        } else {
            float position = -100.0f + balance * 200.0f;
            this.client.add(new SetSidPosition((byte)sidNum, (byte)position));
        }
    }

    @Override
    public void fastForward() {
        this.client.fastForward();
    }

    @Override
    public void normalSpeed() {
        this.client.normalSpeed();
    }

    @Override
    public boolean isFastForward() {
        return this.client.isFastForward();
    }

    @Override
    public int getFastForwardBitMask() {
        return this.client.getFastForwardBitMask();
    }

    @Override
    public void pause() {
        this.client.addAndSend(new Flush());
    }
}

