/*
 * Decompiled with CFR 0.152.
 */
package netsiddev;

import java.io.IOException;
import java.util.Collections;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.stage.Stage;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Line;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import netsiddev.AudioDevice;
import netsiddev.AudioDeviceCompare;
import netsiddev.ClientContext;
import netsiddev.SIDDeviceSettings;
import netsiddev.SIDDeviceStage;

public class Settings
extends SIDDeviceStage {
    @FXML
    private ComboBox<AudioDevice> audioDevice;
    @FXML
    private CheckBox allowExternalConnections;
    @FXML
    private CheckBox digiBoost;
    @FXML
    private Button okButton;
    private ObservableList<AudioDevice> audioDevices;
    private SIDDeviceSettings settings;

    @FXML
    private void initialize() {
        this.audioDevices = FXCollections.observableArrayList();
        this.audioDevice.setItems(this.audioDevices);
        this.settings = SIDDeviceSettings.getInstance();
        AudioDeviceCompare cmp = new AudioDeviceCompare();
        AudioDevice selectedAudioDeviceItem = null;
        int deviceIndex = 0;
        for (Mixer.Info info : AudioSystem.getMixerInfo()) {
            Line.Info lineInfo;
            Mixer mixer = AudioSystem.getMixer(info);
            if (mixer.isLineSupported(lineInfo = new Line.Info(SourceDataLine.class))) {
                AudioDevice audioDeviceItem = new AudioDevice(deviceIndex, info);
                this.audioDevices.add((Object)audioDeviceItem);
                if (deviceIndex == 0) {
                    cmp.setPrimaryDeviceName(info.getName());
                }
                if (audioDeviceItem.getIndex().intValue() == this.settings.getDeviceIndex()) {
                    selectedAudioDeviceItem = audioDeviceItem;
                }
            }
            ++deviceIndex;
        }
        Collections.sort(this.audioDevices, cmp);
        this.audioDevice.getSelectionModel().select(selectedAudioDeviceItem);
        this.allowExternalConnections.setSelected(this.settings.getAllowExternalConnections());
        this.digiBoost.setSelected(this.settings.getDigiBoostEnabled());
    }

    @Override
    public void open() throws IOException {
        this.okButton.requestFocus();
        super.open();
    }

    @FXML
    private void setAudioDevice() {
        AudioDevice device = (AudioDevice)this.audioDevice.getSelectionModel().getSelectedItem();
        ClientContext.changeDevice(device.getInfo());
        this.settings.saveDeviceIndex(device.getIndex());
    }

    @FXML
    private void setAllowExternalConnections() {
        boolean isAllowExternalConnections = this.allowExternalConnections.isSelected();
        this.settings.saveAllowExternalConnections(isAllowExternalConnections);
        ClientContext.applyConnectionConfigChanges();
    }

    @FXML
    private void setDigiBoost() {
        boolean isDigiBoost = this.digiBoost.isSelected();
        ClientContext.setDigiBoost(isDigiBoost);
        this.settings.saveDigiBoost(isDigiBoost);
    }

    @FXML
    private void okPressed() {
        this.settings.saveDeviceIndex(this.settings.getDeviceIndex());
        ((Stage)this.audioDevice.getScene().getWindow()).close();
    }
}

