/*
 * Decompiled with CFR 0.152.
 */
package netsiddev;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class SIDDeviceSettings {
    private static final String FILE_NAME_PROPERTIES = "jsiddevice.properties";
    private static final String PROPERTY_DEVICE_INDEX = "deviceIndex";
    private static final String PROPERTY_DIGI_BOOST = "digiBoost";
    private static final String ALLOW_EXTERNAL_CONNECTIONS = "allowExternalConnections";
    private static final String PROPERTY_DEVICE_INDEX_COMMENT = "JSIDDevice settings";
    private static final SIDDeviceSettings instance = new SIDDeviceSettings();
    private Properties props = new Properties();

    private SIDDeviceSettings() {
        this.load();
    }

    public static SIDDeviceSettings getInstance() {
        return instance;
    }

    public synchronized int getDeviceIndex() {
        try {
            return Integer.valueOf(this.props.getProperty(PROPERTY_DEVICE_INDEX));
        }
        catch (NumberFormatException nfe) {
            return 0;
        }
    }

    public synchronized boolean getDigiBoostEnabled() {
        return Boolean.TRUE.equals(Boolean.valueOf(this.props.getProperty(PROPERTY_DIGI_BOOST)));
    }

    public synchronized boolean getAllowExternalConnections() {
        return Boolean.TRUE.equals(Boolean.valueOf(this.props.getProperty(ALLOW_EXTERNAL_CONNECTIONS)));
    }

    public synchronized void saveDeviceIndex(Integer deviceIndex) {
        this.props.setProperty(PROPERTY_DEVICE_INDEX, String.valueOf(deviceIndex));
        this.save();
    }

    public synchronized void saveDigiBoost(boolean digiBoost) {
        this.props.setProperty(PROPERTY_DIGI_BOOST, String.valueOf(digiBoost));
        this.save();
    }

    public synchronized void saveAllowExternalConnections(boolean allowExternalConnections) {
        this.props.setProperty(ALLOW_EXTERNAL_CONNECTIONS, String.valueOf(allowExternalConnections));
        this.save();
    }

    public void load() {
        try (FileInputStream fis = new FileInputStream(FILE_NAME_PROPERTIES);){
            this.props.load(fis);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void save() {
        try (FileOutputStream os = new FileOutputStream(FILE_NAME_PROPERTIES);){
            this.props.store(os, PROPERTY_DEVICE_INDEX_COMMENT);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

