/*
 * Decompiled with CFR 0.152.
 */
package netsiddev;

import java.awt.AWTException;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.stage.Stage;
import libsidplay.common.ChipModel;
import libsidplay.common.SIDChip;
import libsidplay.config.IFilterSection;
import netsiddev.About;
import netsiddev.Alert;
import netsiddev.ClientContext;
import netsiddev.Settings;
import netsiddev.ini.JSIDDeviceConfig;
import resid_builder.residfp.Filter6581;
import resid_builder.residfp.Filter8580;
import resid_builder.residfp.SID;

public class NetworkSIDDevice
extends Application {
    private static final String TRAY_ICON = "jsidplay2.png";
    private static final String TRAY_TOOLTIP = "SID Network Device";
    private static final String MENU_ABOUT = "About";
    private static final String MENU_SETTINGS = "Settings...";
    private static final String MENU_EXIT = "Exit";
    private static JSIDDeviceConfig config;
    private About aboutDialog = null;
    private Settings settingsDialog = null;

    public static byte getSidCount() {
        String[] sid = config.getFilterList();
        return (byte)sid.length;
    }

    protected static String getSidName(int sidNum) {
        String[] sid = config.getFilterList();
        return sid[sidNum];
    }

    protected static SIDChip getSidConfig(int sidNumber) {
        IFilterSection iniFilter = config.getFilter(config.getFilterList()[sidNumber]);
        SIDChip sid = null;
        if (iniFilter.isReSIDFilter6581()) {
            sid = new resid_builder.resid.SID();
            sid.setChipModel(ChipModel.MOS6581);
            sid.getFilter6581().setFilterCurve(iniFilter.getFilter6581CurvePosition());
        } else if (iniFilter.isReSIDFilter8580()) {
            sid = new resid_builder.resid.SID();
            sid.setChipModel(ChipModel.MOS8580);
            sid.getFilter8580().setFilterCurve(iniFilter.getFilter8580CurvePosition());
        } else if (iniFilter.isReSIDfpFilter6581()) {
            sid = new SID();
            ((SID)sid).setChipModel(ChipModel.MOS6581);
            Filter6581 filter6581 = ((SID)sid).getFilter6581();
            filter6581.setCurveProperties(iniFilter.getBaseresistance(), iniFilter.getOffset(), iniFilter.getSteepness(), iniFilter.getMinimumfetresistance());
            filter6581.setDistortionProperties(iniFilter.getAttenuation(), iniFilter.getNonlinearity(), iniFilter.getResonanceFactor());
            ((SID)sid).set6581VoiceNonlinearity(iniFilter.getVoiceNonlinearity());
            filter6581.setNonLinearity(iniFilter.getVoiceNonlinearity());
        } else if (iniFilter.isReSIDfpFilter8580()) {
            sid = new SID();
            ((SID)sid).setChipModel(ChipModel.MOS8580);
            Filter8580 filter8580 = ((SID)sid).getFilter8580();
            filter8580.setCurveProperties(iniFilter.getK(), iniFilter.getB(), 0.0f, 0.0f);
            filter8580.setDistortionProperties(0.0f, 0.0f, iniFilter.getResonanceFactor());
        }
        return sid;
    }

    public static final void main(String[] args) {
        NetworkSIDDevice.launch((String[])args);
    }

    public void start(Stage primaryStage) throws Exception {
        if (!SystemTray.isSupported()) {
            this.printErrorAndExit("Sorry, System Tray is not yet supported on your platform!");
        }
        Platform.setImplicitExit((boolean)false);
        config = new JSIDDeviceConfig();
        this.createSystemTrayMenu();
        new Thread(() -> {
            try {
                ClientContext.listenForClients(config);
            }
            catch (Exception e) {
                Platform.runLater(() -> this.printErrorAndExit(this.exceptionToString(e)));
            }
        }).start();
    }

    private void createSystemTrayMenu() {
        SystemTray tray = SystemTray.getSystemTray();
        PopupMenu popup = new PopupMenu();
        Image image = Toolkit.getDefaultToolkit().getImage(((Object)((Object)this)).getClass().getResource(TRAY_ICON));
        TrayIcon trayIcon = new TrayIcon(image, TRAY_TOOLTIP, popup);
        trayIcon.setImageAutoSize(true);
        MenuItem aboutItem = new MenuItem(MENU_ABOUT);
        aboutItem.addActionListener(e -> Platform.runLater(() -> {
            try {
                if (this.aboutDialog == null) {
                    this.aboutDialog = new About();
                }
                this.aboutDialog.requestFocus();
                if (!this.aboutDialog.isShowing()) {
                    this.aboutDialog.open();
                }
            }
            catch (IOException e1) {
                this.printErrorAndExit(this.exceptionToString(e1));
            }
        }));
        popup.add(aboutItem);
        MenuItem settingsItem = new MenuItem(MENU_SETTINGS);
        settingsItem.addActionListener(e -> Platform.runLater(() -> {
            try {
                if (this.settingsDialog == null) {
                    this.settingsDialog = new Settings();
                }
                this.settingsDialog.requestFocus();
                if (!this.settingsDialog.isShowing()) {
                    this.settingsDialog.open();
                }
            }
            catch (IOException e1) {
                this.printErrorAndExit(this.exceptionToString(e1));
            }
        }));
        popup.add(settingsItem);
        popup.addSeparator();
        MenuItem exitItem = new MenuItem(MENU_EXIT);
        exitItem.addActionListener(e -> System.exit(0));
        popup.add(exitItem);
        try {
            tray.add(trayIcon);
        }
        catch (AWTException e2) {
            this.printErrorAndExit(this.exceptionToString(e2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printErrorAndExit(String msg) {
        Alert alert = new Alert();
        alert.setText(msg);
        try {
            alert.open();
        }
        catch (IOException iOException) {
        }
        finally {
            System.exit(0);
        }
    }

    private String exceptionToString(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }
}

