/*
 * Decompiled with CFR 0.152.
 */
package netsiddev;

import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import javafx.application.Platform;
import javax.sound.sampled.Mixer;
import libsidplay.common.CPUClock;
import libsidplay.common.ChipModel;
import libsidplay.common.SIDChip;
import libsidplay.common.SamplingMethod;
import netsiddev.Alert;
import netsiddev.AudioGeneratorThread;
import netsiddev.Command;
import netsiddev.InvalidCommandException;
import netsiddev.NetworkSIDDevice;
import netsiddev.Response;
import netsiddev.SIDDeviceSettings;
import netsiddev.SIDWrite;
import netsiddev.ini.IniJSIDDeviceAudioSection;
import netsiddev.ini.JSIDDeviceConfig;
import sidplay.audio.AudioConfig;

class ClientContext {
    private static final Charset ISO_8859 = Charset.forName("ISO-8859-1");
    private static final byte SID_NETWORK_PROTOCOL_VERSION = 3;
    private static final long MAX_TIME_TO_WAIT_FOR_QUEUE = 20L;
    private final int latency;
    private final Command[] commands = Command.values();
    private final AudioGeneratorThread eventConsumerThread;
    private SIDChip[] sidRead;
    private final ByteBuffer dataRead = ByteBuffer.allocateDirect(81924);
    private final ByteBuffer dataWrite = ByteBuffer.allocateDirect(260);
    private static ServerSocketChannel ssc = null;
    private static Selector selector;
    private Command command;
    private int sidNumber;
    private int dataLength;
    private long inputClock;
    private static boolean openNewConnection;
    private static Map<SocketChannel, ClientContext> clientContextMap;

    private ClientContext(AudioConfig config, int latency) {
        this.latency = latency;
        this.dataWrite.position(this.dataWrite.capacity());
        this.eventConsumerThread = new AudioGeneratorThread(config);
        this.eventConsumerThread.start();
        this.dataRead.limit(4);
    }

    private void processReadBuffer() throws InvalidCommandException {
        long clientTimeDifference;
        if (this.dataRead.position() < this.dataRead.limit()) {
            return;
        }
        if (this.command == null) {
            int commandByte = this.dataRead.get(0) & 0xFF;
            if (commandByte >= this.commands.length) {
                throw new InvalidCommandException("Unknown command number: " + commandByte, 4);
            }
            this.command = this.commands[commandByte];
            this.sidNumber = this.dataRead.get(1) & 0xFF;
            this.dataLength = this.dataRead.getShort(2) & 0xFFFF;
            this.dataRead.limit(4 + this.dataLength);
            if (this.dataRead.position() < this.dataRead.limit()) {
                return;
            }
        }
        boolean isBufferFull = (clientTimeDifference = this.inputClock - this.eventConsumerThread.getPlaybackClock()) > (long)this.latency;
        boolean isBufferHalfFull = clientTimeDifference > (long)(this.latency / 2);
        BlockingQueue<SIDWrite> sidCommandQueue = this.eventConsumerThread.getSidCommandQueue();
        this.dataWrite.clear();
        switch (this.command) {
            case FLUSH: {
                if (this.dataLength != 0) {
                    throw new InvalidCommandException("FLUSH needs no data", this.dataLength);
                }
                sidCommandQueue.clear();
                this.inputClock = this.eventConsumerThread.getPlaybackClock();
                this.dataWrite.put((byte)Response.OK.ordinal());
                break;
            }
            case TRY_SET_SID_COUNT: {
                if (this.dataLength != 0) {
                    throw new InvalidCommandException("TRY_SET_SID_COUNT needs no data", this.dataLength);
                }
                if (!this.eventConsumerThread.waitUntilQueueReady(20L)) {
                    this.dataWrite.put((byte)Response.BUSY.ordinal());
                    break;
                }
                SIDChip[] sid = new SIDChip[this.sidNumber];
                this.sidRead = new SIDChip[this.sidNumber];
                this.eventConsumerThread.setSidArray(sid);
                this.dataWrite.put((byte)Response.OK.ordinal());
                break;
            }
            case MUTE: {
                if (this.dataLength != 2) {
                    throw new InvalidCommandException("MUTE needs 2 bytes (voice and channel to mute)", this.dataLength);
                }
                byte voiceNo = this.dataRead.get(4);
                boolean mute = this.dataRead.get(5) != 0;
                this.eventConsumerThread.mute(this.sidNumber, voiceNo, mute);
                this.dataWrite.put((byte)Response.OK.ordinal());
                break;
            }
            case TRY_RESET: {
                if (this.dataLength != 1) {
                    throw new InvalidCommandException("RESET needs 1 byte (volume after reset)", this.dataLength);
                }
                if (!this.eventConsumerThread.waitUntilQueueReady(20L)) {
                    this.dataWrite.put((byte)Response.BUSY.ordinal());
                    break;
                }
                byte volume = this.dataRead.get(4);
                for (int i = 0; i < this.sidRead.length; ++i) {
                    this.eventConsumerThread.reset(i, volume);
                    this.sidRead[i].reset();
                    this.sidRead[i].write(24, volume);
                }
                this.dataWrite.put((byte)Response.OK.ordinal());
                break;
            }
            case TRY_DELAY: {
                if (this.dataLength != 2) {
                    throw new InvalidCommandException("TRY_DELAY needs 2 bytes (16-bit delay value)", this.dataLength);
                }
                if (isBufferHalfFull) {
                    this.eventConsumerThread.ensureDraining();
                }
                if (isBufferFull) {
                    this.dataWrite.put((byte)Response.BUSY.ordinal());
                    break;
                }
                int cycles = this.dataRead.getShort(4) & 0xFFFF;
                this.handleDelayPacket(this.sidNumber, cycles);
                this.dataWrite.put((byte)Response.OK.ordinal());
                break;
            }
            case TRY_WRITE: {
                if (this.dataLength < 4 && this.dataLength % 4 != 0) {
                    throw new InvalidCommandException("TRY_WRITE needs 4*n bytes, with n > 1 (hardsid protocol)", this.dataLength);
                }
                if (isBufferHalfFull) {
                    this.eventConsumerThread.ensureDraining();
                }
                if (isBufferFull) {
                    this.dataWrite.put((byte)Response.BUSY.ordinal());
                    break;
                }
                this.handleWritePacket(this.dataLength);
                this.dataWrite.put((byte)Response.OK.ordinal());
                break;
            }
            case TRY_READ: {
                if ((this.dataLength - 3) % 4 != 0) {
                    throw new InvalidCommandException("READ needs 4*n+3 bytes (4*n hardsid protocol + 16-bit delay + register to read)", this.dataLength);
                }
                if (isBufferHalfFull) {
                    this.eventConsumerThread.ensureDraining();
                }
                if (isBufferFull) {
                    this.dataWrite.put((byte)Response.BUSY.ordinal());
                    break;
                }
                this.handleWritePacket(this.dataLength - 3);
                int readCycles = this.dataRead.getShort(4 + this.dataLength - 3) & 0xFFFF;
                byte register = this.dataRead.get(4 + this.dataLength - 1);
                if (readCycles > 0) {
                    this.handleDelayPacket(this.sidNumber, readCycles);
                }
                this.dataWrite.put((byte)Response.READ.ordinal());
                this.dataWrite.put(this.sidRead[this.sidNumber].read(register & 0x1F));
                break;
            }
            case GET_VERSION: {
                if (this.dataLength != 0) {
                    throw new InvalidCommandException("GET_VERSION needs no data", this.dataLength);
                }
                this.dataWrite.put((byte)Response.VERSION.ordinal());
                this.dataWrite.put((byte)3);
                break;
            }
            case TRY_SET_SAMPLING: {
                if (this.dataLength != 1) {
                    throw new InvalidCommandException("SET_SAMPLING needs 1 byte (method to use: 0=bad quality but fast, 1=good quality but slow)", this.dataLength);
                }
                if (!this.eventConsumerThread.waitUntilQueueReady(20L)) {
                    this.dataWrite.put((byte)Response.BUSY.ordinal());
                    break;
                }
                this.eventConsumerThread.setSampling(SamplingMethod.values()[this.dataRead.get(4)]);
                this.dataWrite.put((byte)Response.OK.ordinal());
                break;
            }
            case TRY_SET_CLOCKING: {
                if (this.dataLength != 1) {
                    throw new InvalidCommandException("SET_CLOCKING needs 1 byte (0=PAL, 1=NTSC)", this.dataLength);
                }
                if (!this.eventConsumerThread.waitUntilQueueReady(20L)) {
                    this.dataWrite.put((byte)Response.BUSY.ordinal());
                    break;
                }
                this.eventConsumerThread.setClocking(CPUClock.values()[this.dataRead.get(4)]);
                this.dataWrite.put((byte)Response.OK.ordinal());
                break;
            }
            case GET_CONFIG_COUNT: {
                if (this.dataLength != 0) {
                    throw new InvalidCommandException("GET_COUNT needs no data", this.dataLength);
                }
                this.dataWrite.put((byte)Response.COUNT.ordinal());
                this.dataWrite.put(NetworkSIDDevice.getSidCount());
                break;
            }
            case GET_CONFIG_INFO: {
                if (this.dataLength != 0) {
                    throw new InvalidCommandException("GET_INFO needs no data", this.dataLength);
                }
                this.dataWrite.put((byte)Response.INFO.ordinal());
                this.dataWrite.put((byte)(NetworkSIDDevice.getSidConfig(this.sidNumber).getChipModel() == ChipModel.MOS8580 ? 1 : 0));
                byte[] name = NetworkSIDDevice.getSidName(this.sidNumber).getBytes(ISO_8859);
                this.dataWrite.put(name, 0, Math.min(name.length, 255));
                this.dataWrite.put((byte)0);
                break;
            }
            case SET_SID_POSITION: {
                if (this.dataLength != 1) {
                    throw new InvalidCommandException("SET_SID_POSITION needs 1 byte", this.dataLength);
                }
                this.eventConsumerThread.setPosition(this.sidNumber, this.dataRead.get(4));
                this.dataWrite.put((byte)Response.OK.ordinal());
                break;
            }
            case SET_SID_LEVEL: {
                if (this.dataLength != 1) {
                    throw new InvalidCommandException("SET_SID_LEVEL needs 1 byte", this.dataLength);
                }
                this.eventConsumerThread.setLevelAdjustment(this.sidNumber, this.dataRead.get(4));
                this.dataWrite.put((byte)Response.OK.ordinal());
                break;
            }
            case TRY_SET_SID_MODEL: {
                if (this.dataLength != 1) {
                    throw new InvalidCommandException("SET_SID_LEVEL needs 1 byte", this.dataLength);
                }
                if (!this.eventConsumerThread.waitUntilQueueReady(20L)) {
                    this.dataWrite.put((byte)Response.BUSY.ordinal());
                    break;
                }
                int config = this.dataRead.get(4) & 0xFF;
                this.sidRead[this.sidNumber] = NetworkSIDDevice.getSidConfig(config);
                this.eventConsumerThread.setSID(this.sidNumber, NetworkSIDDevice.getSidConfig(config));
                this.dataWrite.put((byte)Response.OK.ordinal());
                break;
            }
            default: {
                throw new InvalidCommandException("Unsupported command: " + (Object)((Object)this.command));
            }
        }
        this.dataWrite.limit(this.dataWrite.position());
        this.dataWrite.rewind();
        this.dataRead.position(4 + this.dataLength);
        this.dataRead.compact();
        this.command = null;
        this.dataRead.limit(4);
    }

    private void handleDelayPacket(int sidNumber, int cycles) throws InvalidCommandException {
        BlockingQueue<SIDWrite> q = this.eventConsumerThread.getSidCommandQueue();
        this.inputClock += (long)cycles;
        q.add(SIDWrite.makePureDelay(sidNumber, cycles));
        this.sidRead[sidNumber].clock(cycles, sample -> {});
    }

    private void handleWritePacket(int dataLength) throws InvalidCommandException {
        BlockingQueue<SIDWrite> q = this.eventConsumerThread.getSidCommandQueue();
        for (int i = 0; i < dataLength; i += 4) {
            int writeCycles = this.dataRead.getShort(4 + i) & 0xFFFF;
            byte reg = this.dataRead.get(4 + i + 2);
            byte sid = (byte)((reg & 0xE0) >> 5);
            reg = (byte)(reg & 0x1F);
            byte value = this.dataRead.get(4 + i + 3);
            this.inputClock += (long)writeCycles;
            q.add(new SIDWrite(sid, reg, value, writeCycles));
            this.sidRead[sid].clock(writeCycles, sample -> {});
            this.sidRead[sid].write(reg & 0x1F, value);
        }
    }

    protected void dispose() {
        if (!this.eventConsumerThread.waitUntilQueueReady(20L)) {
            this.eventConsumerThread.interrupt();
            return;
        }
        this.eventConsumerThread.getSidCommandQueue().add(SIDWrite.makeEnd());
        this.eventConsumerThread.ensureDraining();
    }

    protected void disposeWait() {
        try {
            this.eventConsumerThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private ByteBuffer getReadBuffer() {
        return this.dataRead;
    }

    private ByteBuffer getWriteBuffer() {
        return this.dataWrite;
    }

    public static void changeDevice(Mixer.Info deviceInfo) {
        for (ClientContext clientContext : clientContextMap.values()) {
            clientContext.eventConsumerThread.changeDevice(deviceInfo);
        }
    }

    public static void setDigiBoost(boolean enabled) {
        for (ClientContext clientContext : clientContextMap.values()) {
            clientContext.eventConsumerThread.setDigiBoost(enabled);
        }
    }

    public static void applyConnectionConfigChanges() {
        openNewConnection = true;
        if (selector != null) {
            selector.wakeup();
        }
    }

    public static void listenForClients(JSIDDeviceConfig config) {
        try {
            openNewConnection = true;
            while (openNewConnection) {
                ssc = ServerSocketChannel.open();
                ssc.configureBlocking(false);
                SIDDeviceSettings settings = SIDDeviceSettings.getInstance();
                boolean allowExternalIpConnections = settings.getAllowExternalConnections();
                String ipAddress = allowExternalIpConnections ? "0.0.0.0" : config.jsiddevice().getHostname();
                ssc.socket().bind(new InetSocketAddress(ipAddress, config.jsiddevice().getPort()));
                System.out.println("Opening listening socket on ip address " + ipAddress);
                selector = Selector.open();
                ssc.register(selector, 16);
                clientContextMap.clear();
                openNewConnection = false;
                while (selector.select() > 0 && !openNewConnection) {
                    for (SelectionKey sk : selector.selectedKeys()) {
                        ByteBuffer data;
                        ClientContext cc;
                        SocketChannel sc;
                        if (sk.isAcceptable()) {
                            sc = ((ServerSocketChannel)sk.channel()).accept();
                            sc.socket().setReceiveBufferSize(16384);
                            sc.socket().setSendBufferSize(1024);
                            sc.configureBlocking(false);
                            sc.register(selector, 1);
                            IniJSIDDeviceAudioSection audio = config.audio();
                            AudioConfig audioConfig = new AudioConfig(audio.getSamplingRate().getFrequency(), 2, audio.getDevice());
                            ClientContext cc2 = new ClientContext(audioConfig, config.jsiddevice().getLatency());
                            clientContextMap.put(sc, cc2);
                            System.out.println("New client: " + cc2);
                        }
                        if (sk.isReadable()) {
                            sc = (SocketChannel)sk.channel();
                            cc = clientContextMap.get(sc);
                            try {
                                int length = sc.read(cc.getReadBuffer());
                                if (length == -1) {
                                    throw new EOFException();
                                }
                                cc.processReadBuffer();
                            }
                            catch (Exception e) {
                                System.out.println("Read: closing client " + cc + " due to exception: " + e);
                                cc.dispose();
                                clientContextMap.remove(sc);
                                sk.cancel();
                                sc.close();
                                if (e instanceof IOException) continue;
                                StringWriter sw = new StringWriter();
                                e.printStackTrace(new PrintWriter(sw));
                                Platform.runLater(() -> {
                                    Alert alert = new Alert();
                                    alert.setText(sw.toString());
                                    try {
                                        alert.open();
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    System.exit(0);
                                });
                                continue;
                            }
                            data = cc.getWriteBuffer();
                            if (data.remaining() != 0) {
                                sc.register(selector, 4);
                            }
                        }
                        if (!sk.isWritable()) continue;
                        sc = (SocketChannel)sk.channel();
                        cc = clientContextMap.get(sc);
                        try {
                            data = cc.getWriteBuffer();
                            sc.write(data);
                            if (data.remaining() != 0) continue;
                            sc.register(selector, 1);
                        }
                        catch (IOException ioe) {
                            System.out.println("Write: closing client " + cc + " due to exception: " + ioe);
                            cc.dispose();
                            clientContextMap.remove(sc);
                            sk.cancel();
                            sc.close();
                        }
                    }
                    selector.selectedKeys().clear();
                }
                ClientContext.closeClientConnections();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void closeClientConnections() throws IOException {
        for (ClientContext cc : clientContextMap.values()) {
            System.out.println("Cleaning up client: " + cc);
            cc.dispose();
        }
        for (SocketChannel sc : clientContextMap.keySet()) {
            sc.close();
        }
        for (ClientContext cc : clientContextMap.values()) {
            cc.disposeWait();
        }
        if (ssc.socket().isBound()) {
            ssc.socket().close();
        }
        if (selector.isOpen()) {
            selector.close();
        }
        ssc.close();
        System.out.println("Listening socket closed.");
    }

    static {
        openNewConnection = true;
        clientContextMap = new ConcurrentHashMap<SocketChannel, ClientContext>();
    }
}

