/*
 * Decompiled with CFR 0.152.
 */
package netsiddev;

import java.nio.ByteBuffer;
import java.util.Random;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Mixer;
import libsidplay.common.CPUClock;
import libsidplay.common.SIDChip;
import libsidplay.common.SamplingMethod;
import netsiddev.SIDDeviceSettings;
import netsiddev.SIDWrite;
import resid_builder.resample.Resampler;
import sidplay.audio.AudioConfig;
import sidplay.audio.JavaSound;

public class AudioGeneratorThread
extends Thread {
    private static final Random RANDOM = new Random();
    private final AtomicLong playbackClock = new AtomicLong(0L);
    private final BlockingQueue<SIDWrite> sidCommandQueue;
    private boolean digiBoostEnabled = false;
    private SIDChip[] sids;
    private Resampler resamplerL;
    private Resampler resamplerR;
    private CPUClock sidClocking;
    private SamplingMethod sidSampling;
    private final AudioConfig audioConfig;
    private int oldRandomValue;
    private int[] sidLevel;
    private int deviceIndex;
    private int[] sidPositionL;
    private int[] sidPositionR;
    private int[] audioBufferPos;
    private Mixer.Info mixerInfo;
    private boolean deviceChanged = false;
    private final AtomicBoolean audioWait = new AtomicBoolean(true);
    private final AtomicBoolean quicklyDiscardAudio = new AtomicBoolean(false);

    protected int triangularDithering() {
        int prevValue = this.oldRandomValue;
        this.oldRandomValue = RANDOM.nextInt() & 1;
        return this.oldRandomValue - prevValue;
    }

    public AudioGeneratorThread(AudioConfig config) {
        this.setPriority(10);
        this.sidCommandQueue = new LinkedBlockingQueue<SIDWrite>();
        this.audioConfig = config;
        SIDDeviceSettings settings = SIDDeviceSettings.getInstance();
        this.deviceIndex = settings.getDeviceIndex();
        this.digiBoostEnabled = settings.getDigiBoostEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Mixer.Info[] aInfos = AudioSystem.getMixerInfo();
        try (JavaSound driver = new JavaSound();){
            if (this.deviceIndex >= 0 && this.deviceIndex < aInfos.length) {
                this.mixerInfo = aInfos[this.deviceIndex];
                driver.open(this.audioConfig, this.mixerInfo);
            } else {
                driver.open(this.audioConfig, (Mixer.Info)null);
            }
            int audioLength = 10000;
            int[] outAudioBuffer = new int[20000];
            BlockingQueue<SIDWrite> blockingQueue = this.sidCommandQueue;
            synchronized (blockingQueue) {
                this.sidCommandQueue.wait();
                this.audioWait.set(false);
            }
            this.refreshParams();
            while (!AudioGeneratorThread.interrupted()) {
                int piece;
                SIDWrite write = (SIDWrite)this.sidCommandQueue.poll();
                if (write == null) {
                    long predictedExhaustionTime = System.currentTimeMillis() + (long)driver.getRemainingPlayTime();
                    while (!this.quicklyDiscardAudio.get() && System.currentTimeMillis() < predictedExhaustionTime && (write = this.sidCommandQueue.poll(1L, TimeUnit.MILLISECONDS)) == null) {
                    }
                    this.quicklyDiscardAudio.getAndSet(false);
                    if (write == null) {
                        Object object = this.audioWait;
                        synchronized (object) {
                            this.audioWait.set(true);
                            this.audioWait.notify();
                        }
                        driver.pause();
                        object = this.sidCommandQueue;
                        synchronized (object) {
                            this.sidCommandQueue.wait();
                            this.audioWait.set(false);
                            continue;
                        }
                    }
                }
                for (int cycles = write.getCycles(); cycles != 0; cycles -= piece) {
                    piece = Math.min(cycles, 10000);
                    for (int sidNum = 0; sidNum < this.sids.length; ++sidNum) {
                        int sid = sidNum;
                        this.audioBufferPos[sid] = 0;
                        this.sids[sidNum].clock(piece, sample -> {
                            sample = sample * this.sidLevel[sid] >> 10;
                            int n = this.audioBufferPos[sid] << 1 | 0;
                            outAudioBuffer[n] = outAudioBuffer[n] + (sample * this.sidPositionL[sid] >> 10);
                            int n2 = sid;
                            int n3 = this.audioBufferPos[n2];
                            this.audioBufferPos[n2] = n3 + 1;
                            int n4 = n3 << 1 | 1;
                            outAudioBuffer[n4] = outAudioBuffer[n4] + (sample * this.sidPositionR[sid] >> 10);
                        });
                    }
                    ByteBuffer output = driver.buffer();
                    for (int i = 0; i < piece; ++i) {
                        int dithering = this.triangularDithering();
                        int value = outAudioBuffer[i << 1 | 0];
                        if (this.resamplerL.input(value)) {
                            value = this.resamplerL.output() + dithering;
                            if (value > Short.MAX_VALUE) {
                                value = Short.MAX_VALUE;
                            }
                            if (value < Short.MIN_VALUE) {
                                value = Short.MIN_VALUE;
                            }
                            output.putShort((short)value);
                        }
                        outAudioBuffer[i << 1 | 0] = 0;
                        value = outAudioBuffer[i << 1 | 1];
                        if (this.resamplerR.input(value)) {
                            value = this.resamplerR.output() + dithering;
                            if (value > Short.MAX_VALUE) {
                                value = Short.MAX_VALUE;
                            }
                            if (value < Short.MIN_VALUE) {
                                value = Short.MIN_VALUE;
                            }
                            output.putShort((short)value);
                        }
                        outAudioBuffer[i << 1 | 1] = 0;
                        if (output.hasRemaining()) continue;
                        driver.write();
                        output.clear();
                    }
                    this.playbackClock.addAndGet(piece);
                }
                if (write.isEnd()) {
                    ByteBuffer output = driver.buffer();
                    if (output.position() != 0) {
                        while (output.hasRemaining()) {
                            output.putShort((short)0);
                            output.putShort((short)0);
                        }
                        driver.write();
                    }
                    break;
                }
                if (!write.isPureDelay()) {
                    this.sids[write.getChip()].write(write.getRegister(), write.getValue());
                }
                if (!this.deviceChanged) continue;
                driver.setAudioDevice(this.mixerInfo);
                this.deviceChanged = false;
            }
        }
    }

    public void reset(int sidNumber, byte volume) {
        this.sids[sidNumber].reset();
        this.sids[sidNumber].write(24, volume);
    }

    public void mute(int sidNumber, int voiceNo, boolean mute) {
        this.sids[sidNumber].mute(voiceNo, mute);
    }

    public void changeDevice(Mixer.Info deviceInfo) {
        this.mixerInfo = deviceInfo;
        this.deviceChanged = true;
    }

    public void setClocking(CPUClock clock) {
        this.sidClocking = clock;
        this.refreshParams();
    }

    public void setSampling(SamplingMethod samplingMethod) {
        this.sidSampling = samplingMethod;
        this.refreshParams();
    }

    private void refreshParams() {
        for (int i = 0; i < this.sids.length; ++i) {
            this.sids[i].setClockFrequency(this.sidClocking.getCpuFrequency());
        }
        this.resamplerL = Resampler.createResampler(this.sidClocking.getCpuFrequency(), this.sidSampling, this.audioConfig.getFrameRate(), 20000.0);
        this.resamplerR = Resampler.createResampler(this.sidClocking.getCpuFrequency(), this.sidSampling, this.audioConfig.getFrameRate(), 20000.0);
    }

    public void setPosition(int sidNumber, int position) {
        if (this.sids.length > 1) {
            float leftFraction = position <= 0 ? 1.0f : (float)(100 - position) / 100.0f;
            float rightFraction = position >= 0 ? 1.0f : (float)(100 + position) / 100.0f;
            this.sidPositionL[sidNumber] = (int)(1024.0f * leftFraction);
            this.sidPositionR[sidNumber] = (int)(1024.0f * rightFraction);
        } else {
            this.sidPositionL[sidNumber] = 1024;
            this.sidPositionR[sidNumber] = 1024;
        }
    }

    public void setLevelAdjustment(int sid, int level) {
        this.sidLevel[sid] = (int)(1024.0 * Math.pow(10.0, (double)level / 100.0));
    }

    public BlockingQueue<SIDWrite> getSidCommandQueue() {
        return this.sidCommandQueue;
    }

    public long getPlaybackClock() {
        return this.playbackClock.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureDraining() {
        BlockingQueue<SIDWrite> blockingQueue = this.sidCommandQueue;
        synchronized (blockingQueue) {
            this.sidCommandQueue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureQuickDraining() {
        BlockingQueue<SIDWrite> blockingQueue = this.sidCommandQueue;
        synchronized (blockingQueue) {
            this.quicklyDiscardAudio.getAndSet(true);
            this.sidCommandQueue.notify();
        }
    }

    public boolean isWaitingForCommands() {
        return this.audioWait.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitUntilQueueReady(long timeout) {
        boolean isQueueReady = this.audioWait.get();
        if (!isQueueReady) {
            this.ensureQuickDraining();
            try {
                AtomicBoolean atomicBoolean = this.audioWait;
                synchronized (atomicBoolean) {
                    this.audioWait.wait(timeout);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            isQueueReady = this.audioWait.get();
        }
        return isQueueReady;
    }

    public void setSidArray(SIDChip[] sid) {
        this.sids = sid;
        this.sidClocking = CPUClock.PAL;
        this.sidSampling = SamplingMethod.DECIMATE;
        this.sidLevel = new int[sid.length];
        this.sidPositionL = new int[sid.length];
        this.sidPositionR = new int[sid.length];
        this.audioBufferPos = new int[sid.length];
        for (int i = 0; i < sid.length; ++i) {
            this.setLevelAdjustment(i, 0);
            if (sid.length > 1) {
                this.setPosition(i, -100 + 200 * i / (sid.length - 1));
                continue;
            }
            this.setPosition(i, 0);
        }
    }

    public void setSID(int sidNumber, SIDChip sidConfig) {
        this.sids[sidNumber] = sidConfig;
        this.setDigiBoost(this.digiBoostEnabled);
    }

    public void setDigiBoost(boolean selected) {
        this.digiBoostEnabled = selected;
        for (SIDChip sidChip : this.sids) {
            if (sidChip == null) continue;
            sidChip.input(this.digiBoostEnabled ? sidChip.getInputDigiBoost() : 0);
        }
    }
}

