/*
 * Decompiled with CFR 0.152.
 */
package libsidutils.vicesync;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Scanner;

public class ViceSync {
    private ServerSocket serverSocket;
    private BufferedReader in;
    private PrintWriter out;

    public void connect(int port) throws IOException {
        int portNumber = port;
        this.serverSocket = new ServerSocket(portNumber);
        Socket clientSocket = this.serverSocket.accept();
        this.in = new BufferedReader(new InputStreamReader(clientSocket.getInputStream()));
        this.out = new PrintWriter(clientSocket.getOutputStream(), true);
    }

    public String receive() throws IOException {
        return this.in.readLine();
    }

    public void send(String answer) throws IOException {
        this.out.println(answer);
    }

    public MOS6510State getState(String viceState) {
        MOS6510State state = new MOS6510State();
        try (Scanner sc = new Scanner(viceState);){
            sc.useDelimiter(",");
            while (sc.hasNext()) {
                String reg;
                String tk = sc.next().trim();
                int del = tk.indexOf(61);
                if (del == -1) continue;
                switch (reg = tk.substring(0, del)) {
                    case "clk": {
                        state.clk = Long.parseLong(tk.substring(del + 1, tk.length()));
                        break;
                    }
                    case "syncClk": {
                        state.syncClk = Long.parseLong(tk.substring(del + 1, tk.length()));
                        break;
                    }
                    case "pc": {
                        state.pc = Integer.parseInt(tk.substring(del + 1, tk.length()), 16);
                        break;
                    }
                    case "a": {
                        state.a = Integer.parseInt(tk.substring(del + 1, tk.length()), 16);
                        break;
                    }
                    case "x": {
                        state.x = Integer.parseInt(tk.substring(del + 1, tk.length()), 16);
                        break;
                    }
                    case "y": {
                        state.y = Integer.parseInt(tk.substring(del + 1, tk.length()), 16);
                        break;
                    }
                    case "sp": {
                        state.sp = Integer.parseInt(tk.substring(del + 1, tk.length()), 16);
                        break;
                    }
                }
            }
        }
        return state;
    }

    public static class MOS6510State {
        long clk;
        long syncClk;
        int pc;
        int a;
        int x;
        int y;
        int sp;

        public MOS6510State() {
        }

        public MOS6510State(long syncClk, int register_ProgramCounter, byte register_Accumulator, byte register_X, byte register_Y, byte register_StackPointer) {
            this.syncClk = syncClk;
            this.pc = register_ProgramCounter;
            this.a = register_Accumulator & 0xFF;
            this.x = register_X & 0xFF;
            this.y = register_Y & 0xFF;
            this.sp = register_StackPointer & 0xFF;
        }

        public long getClk() {
            return this.clk;
        }

        public boolean equals(Object obj) {
            boolean ok;
            MOS6510State other = (MOS6510State)obj;
            boolean bl = ok = other != null && other.pc == this.pc && other.a == this.a && other.x == this.x && other.y == this.y && other.sp == this.sp;
            if (!ok) {
                System.err.println("Difference detected!");
            }
            return ok;
        }

        public String toString() {
            return String.format("%d - %d: pc=%04x, a=%02x, x=%02x, y=%02x, sp=%02x", this.clk, this.syncClk, this.pc, (byte)this.a, (byte)this.x, (byte)this.y, (byte)this.sp);
        }
    }
}

