/*
 * Decompiled with CFR 0.152.
 */
package libsidutils.vicesync;

import java.io.IOException;
import libsidplay.common.Event;
import libsidplay.common.EventScheduler;
import libsidutils.debug.MOS6510Debug;
import libsidutils.vicesync.ViceSync;

public class MOS6510ViceSync
extends MOS6510Debug {
    private ViceSync sync;
    private long syncClk;
    private boolean connectedToJava = false;

    public MOS6510ViceSync(EventScheduler context) {
        super(context);
    }

    @Override
    protected void fetchNextOpcode() {
        if (!this.connectedToJava && this.Register_ProgramCounter == 3746 && this.Register_Accumulator == 25 && this.Register_X == 126 && this.Register_Y == 1 && this.Register_StackPointer == -24) {
            this.sync = new ViceSync();
            try {
                this.sync.connect(6510);
                this.connectedToJava = true;
                String received = this.sync.receive();
                ViceSync.MOS6510State viceState = this.sync.getState(received);
                System.out.println(viceState);
                this.sync.send("start\n");
                this.syncClk = this.context.getTime(Event.Phase.PHI2);
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(0);
            }
        } else if (this.connectedToJava) {
            try {
                String received = this.sync.receive();
                ViceSync.MOS6510State jsidplay2State = new ViceSync.MOS6510State(this.context.getTime(Event.Phase.PHI2) - this.syncClk, this.Register_ProgramCounter, this.Register_Accumulator, this.Register_X, this.Register_Y, this.Register_StackPointer);
                ViceSync.MOS6510State viceState = this.sync.getState(received);
                if (viceState.getClk() == 55292330L || viceState.getClk() == 55288505L) {
                    this.sync.send("break\n");
                    System.out.println("Until here we have exactly the same state!!!");
                }
                if (!jsidplay2State.equals(viceState)) {
                    System.out.println("This is the first point where they differ, do some analysis here!!!");
                    System.err.println("Differs: " + jsidplay2State.equals(viceState));
                }
                this.sync.send("thanks!\n");
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(0);
            }
        }
        super.fetchNextOpcode();
    }
}

