/*
 * Decompiled with CFR 0.152.
 */
package libsidutils.sidid;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessControlException;

public class SidIdBase {
    protected byte[] load(String name) throws IOException {
        try (DataInputStream in = new DataInputStream(new FileInputStream(name));){
            int length = (int)new File(name).length();
            byte[] buffer = new byte[length];
            in.readFully(buffer);
            byte[] byArray = buffer;
            return byArray;
        }
    }

    protected byte[] readConfiguration(String fname, String pkg) {
        File iniFilename = this.getLocation(fname);
        if (iniFilename != null) {
            try {
                return this.load(iniFilename.getAbsolutePath());
            }
            catch (IOException e) {
                System.err.println("Read error: " + iniFilename);
                return this.readInternal(fname, pkg);
            }
        }
        return this.readInternal(fname, pkg);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] readInternal(String fname, String pkg) {
        try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(pkg + fname);){
            int pos;
            int count;
            if (inputStream == null) {
                throw new RuntimeException("Internal SIDID not found: " + pkg + fname);
            }
            int length = inputStream.available();
            byte[] data = new byte[length];
            for (pos = 0; pos < length && (count = inputStream.read(data, pos, length - pos)) >= 0; pos += count) {
            }
            if (pos != length) {
                System.err.println("Internal SIDID was not loaded completely!");
            }
            byte[] byArray = data;
            return byArray;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Internal SIDID not found: " + pkg + fname);
        }
    }

    private File getLocation(String fname) {
        try {
            String[] paths;
            for (String path : paths = new String[]{"user.dir", "user.home"}) {
                File sidIdFile = this.locate(path, fname);
                if (!sidIdFile.exists()) continue;
                return sidIdFile;
            }
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        return null;
    }

    private File locate(String location, String fname) {
        String path = System.getProperty(location);
        if (path != null) {
            return new File(path, fname);
        }
        return new File("", fname);
    }
}

