/*
 * Decompiled with CFR 0.152.
 */
package libsidutils.siddatabase;

import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import libsidplay.sidtune.SidTune;
import libsidutils.siddatabase.TimeConverter;
import sidplay.ini.IniReader;

public class SidDatabase {
    public static final String SONGLENGTHS_FILE = "DOCUMENTS/Songlengths.txt";
    private final IniReader database;
    protected Random random = new Random();

    public SidDatabase(InputStream input) throws IOException {
        this.database = new IniReader(input);
    }

    public int getTuneLength(SidTune tune) {
        int length = 0;
        String md5 = tune.getMD5Digest();
        for (int songNum = 1; songNum <= tune.getInfo().getSongs(); ++songNum) {
            length += this.getLength(md5, songNum);
        }
        return length;
    }

    public int getSongLength(SidTune tune) {
        int songNum = tune.getInfo().getCurrentSong();
        String md5 = tune.getMD5Digest();
        return songNum == 0 || md5 == null ? 0 : this.getLength(md5, songNum);
    }

    public String getPath(SidTune tune) {
        String md5 = tune.getMD5Digest();
        String comment = md5 != null ? this.database.getPropertyString("Database", "_" + md5, null) : null;
        return comment != null ? comment.substring(1).trim() : "";
    }

    public String getRandomPath() {
        int rndIndex;
        String[] sectionProperties = this.database.sectionProperties("Database");
        String md5Comment = sectionProperties[rndIndex = Math.abs(this.random.nextInt(Integer.MAX_VALUE)) % sectionProperties.length & 0x7FFFFFFE];
        String comment = md5Comment != null ? this.database.getPropertyString("Database", "_" + md5Comment, null) : null;
        return comment != null ? comment.substring(1).trim() : null;
    }

    private int getLength(String md5, int songNum) {
        String times = this.database.getPropertyString("Database", md5, null);
        return times != null ? new TimeConverter().fromString(times.split(" ")[songNum - 1]) : 0;
    }
}

