/*
 * Decompiled with CFR 0.152.
 */
package libsidutils.prg2tap;

import java.nio.charset.Charset;
import libsidplay.sidtune.SidTune;

public class PRG2TAPProgram {
    private static final Charset ISO88591 = Charset.forName("ISO-8859-1");
    private static final int MAX_MEM_SIZE = 65536;
    private final byte[] name = new byte[16];
    private final int startAddr;
    private final int length;
    private final byte[] mem = new byte[65536];

    public PRG2TAPProgram(SidTune sidTune, String name) {
        sidTune.placeProgramInMemory(this.mem);
        this.startAddr = sidTune.getInfo().getLoadAddr();
        this.length = sidTune.getInfo().getC64dataLen();
        byte[] petscii = PRG2TAPProgram.filenameTopetscii(name, 16);
        System.arraycopy(petscii, 0, this.name, 0, petscii.length);
    }

    public static final byte[] filenameTopetscii(String str, int maxLen) {
        return str.substring(0, Math.min(maxLen, str.length())).toUpperCase().replace('_', '-').getBytes(ISO88591);
    }

    public byte[] getName() {
        return this.name;
    }

    public int getStartAddr() {
        return this.startAddr;
    }

    public int getLength() {
        return this.length;
    }

    public byte[] getMem() {
        return this.mem;
    }
}

