/*
 * Decompiled with CFR 0.152.
 */
package libsidutils.prg2tap;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.HashMap;
import libsidutils.assembler.KickAssembler;
import libsidutils.prg2tap.PRG2TAPProgram;

public class PRG2TAP {
    private static final String TURBO_HEADER_ASM = "/libsidutils/prg2tap/PRG2TAP_TurboHeader.asm";
    private static final String TURBO_DATA_ASM = "/libsidutils/prg2tap/PRG2TAP_TurboData.asm";
    private static final String SLOW_HEADER_ASM = "/libsidutils/prg2tap/PRG2TAP_SlowHeader.asm";
    static final int MAX_NAME_LENGTH = 16;
    private static final int TAP_HEADER_SIZE = 20;
    private static final int[] PULSE_LENGTH = new int[]{384, 536, 680};
    private byte tapVersion = 1;
    private int threshold = 263;
    private boolean turboTape = true;
    private final KickAssembler assembler = new KickAssembler();
    private BufferedOutputStream out;

    public final void setTapVersion(byte tapVersion) {
        assert (tapVersion != 0 && tapVersion != 1);
        this.tapVersion = tapVersion;
    }

    public final void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    public final void setTurboTape(boolean turboTape) {
        this.turboTape = turboTape;
    }

    public void add(PRG2TAPProgram program) throws IOException {
        assert (this.out != null);
        if (this.turboTape) {
            HashMap<String, String> globals = new HashMap<String, String>();
            globals.put("name", this.getName(program));
            globals.put("threshold", String.valueOf(this.threshold));
            InputStream asm = PRG2TAP.class.getResourceAsStream(TURBO_HEADER_ASM);
            byte[] header = this.assembler.assemble(TURBO_HEADER_ASM, asm, globals);
            globals = new HashMap();
            asm = PRG2TAP.class.getResourceAsStream(TURBO_DATA_ASM);
            byte[] data = this.assembler.assemble(TURBO_DATA_ASM, asm, globals);
            this.slowConvert(header, 2, header.length - 2, 20000);
            this.addSilence(200000);
            this.slowConvert(data, 2, data.length - 2, 5000);
            this.addSilence(1000000);
            this.turbotapeConvert(program);
        } else {
            byte[] data = program.getMem();
            int start = program.getStartAddr();
            int end = start + program.getLength();
            HashMap<String, String> globals = new HashMap<String, String>();
            globals.put("name", this.getName(program));
            globals.put("start", String.valueOf(start));
            globals.put("end", String.valueOf(end));
            InputStream asm = PRG2TAP.class.getResourceAsStream(SLOW_HEADER_ASM);
            byte[] header = this.assembler.assemble(SLOW_HEADER_ASM, asm, globals);
            this.slowConvert(header, 2, header.length - 2, 20000);
            this.addSilence(200000);
            this.slowConvert(data, start, end - start, 5000);
        }
    }

    private String getName(PRG2TAPProgram program) {
        String name = "";
        for (int i = 0; i < 16; ++i) {
            name = name + (char)program.getName()[i];
        }
        return name;
    }

    public void addSilence(int ncycles) throws IOException {
        if (ncycles < 2048) {
            this.out.write((byte)(ncycles / 8));
        } else {
            this.out.write(0);
            if (this.tapVersion == 0) {
                return;
            }
            this.out.write((byte)(ncycles & 0xFF));
            this.out.write((byte)(ncycles >> 8 & 0xFF));
            this.out.write((byte)(ncycles >> 16 & 0xFF));
        }
    }

    public void open(File outputFile) throws IOException {
        this.out = new BufferedOutputStream(new FileOutputStream(outputFile));
        byte[] header = "C64-TAPE-RAW".getBytes("ISO-8859-1");
        this.out.write(header);
        this.out.write(this.tapVersion);
        for (int i = 0; i < 20 - header.length; ++i) {
            this.out.write(0);
        }
    }

    public void close(File outputFile) throws IOException {
        assert (this.out != null);
        this.out.close();
        long size = outputFile.length() - 20L;
        try (RandomAccessFile rnd = new RandomAccessFile(outputFile, "rw");){
            rnd.seek(16L);
            rnd.write((byte)(size & 0xFFL));
            rnd.write((byte)(size >> 8 & 0xFFL));
            rnd.write((byte)(size >> 16 & 0xFFL));
            rnd.write((byte)(size >> 24 & 0xFFL));
        }
    }

    private void slowConvert(byte[] data, int startAddr, int length, int leadinLen) throws IOException {
        int i;
        int i2;
        for (i2 = 0; i2 < leadinLen; ++i2) {
            this.addSilence(PULSE_LENGTH[0]);
        }
        for (i2 = 137; i2 > 128; --i2) {
            this.slowWriteByte((byte)i2);
        }
        byte checksum = 0;
        for (i = 0; i < length; ++i) {
            this.slowWriteByte(data[startAddr + i]);
            checksum = (byte)(checksum ^ data[startAddr + i]);
        }
        this.slowWriteByte(checksum);
        this.addSilence(PULSE_LENGTH[2]);
        this.addSilence(PULSE_LENGTH[0]);
        for (i = 0; i < 79; ++i) {
            this.addSilence(PULSE_LENGTH[0]);
        }
        for (i = 9; i > 0; --i) {
            this.slowWriteByte((byte)i);
        }
        for (i = 0; i < length; ++i) {
            this.slowWriteByte(data[startAddr + i]);
        }
        this.slowWriteByte(checksum);
        this.addSilence(PULSE_LENGTH[2]);
        this.addSilence(PULSE_LENGTH[0]);
        for (i = 0; i < 200; ++i) {
            this.addSilence(PULSE_LENGTH[0]);
        }
    }

    private void slowWriteByte(byte byt) throws IOException {
        this.addSilence(PULSE_LENGTH[2]);
        this.addSilence(PULSE_LENGTH[1]);
        boolean parity = true;
        byte count = 1;
        do {
            if ((byt & count) != 0) {
                parity ^= true;
                this.addSilence(PULSE_LENGTH[1]);
                this.addSilence(PULSE_LENGTH[0]);
                continue;
            }
            this.addSilence(PULSE_LENGTH[0]);
            this.addSilence(PULSE_LENGTH[1]);
        } while ((count = (byte)(count << 1)) != 0);
        if (parity) {
            this.addSilence(PULSE_LENGTH[1]);
            this.addSilence(PULSE_LENGTH[0]);
        } else {
            this.addSilence(PULSE_LENGTH[0]);
            this.addSilence(PULSE_LENGTH[1]);
        }
    }

    private void turbotapeConvert(PRG2TAPProgram program) throws IOException {
        int i;
        int i2;
        for (i2 = 0; i2 < 630; ++i2) {
            this.turbotapeWriteByte((byte)2);
        }
        for (i2 = 9; i2 >= 1; --i2) {
            this.turbotapeWriteByte((byte)i2);
        }
        this.turbotapeWriteByte((byte)1);
        this.turbotapeWriteByte((byte)(program.getStartAddr() & 0xFF));
        this.turbotapeWriteByte((byte)(program.getStartAddr() >> 8 & 0xFF));
        this.turbotapeWriteByte((byte)(program.getStartAddr() + program.getLength() & 0xFF));
        this.turbotapeWriteByte((byte)(program.getStartAddr() + program.getLength() >> 8 & 0xFF));
        this.turbotapeWriteByte((byte)0);
        for (i2 = 0; i2 < 16; ++i2) {
            this.turbotapeWriteByte(program.getName()[i2]);
        }
        for (i2 = 0; i2 < 171; ++i2) {
            this.turbotapeWriteByte((byte)32);
        }
        for (i2 = 0; i2 < 630; ++i2) {
            this.turbotapeWriteByte((byte)2);
        }
        for (i2 = 9; i2 >= 1; --i2) {
            this.turbotapeWriteByte((byte)i2);
        }
        this.turbotapeWriteByte((byte)0);
        byte checksum = 0;
        for (i = 0; i < program.getLength(); ++i) {
            this.turbotapeWriteByte(program.getMem()[program.getStartAddr() + i]);
            checksum = (byte)(checksum ^ program.getMem()[program.getStartAddr() + i]);
        }
        this.turbotapeWriteByte(checksum);
        for (i = 0; i < 630; ++i) {
            this.turbotapeWriteByte((byte)0);
        }
    }

    private void turbotapeWriteByte(byte byt) throws IOException {
        int zeroBit = this.threshold * 4 / 5;
        int oneBit = this.threshold * 13 / 10;
        int count = 128;
        do {
            if ((byt & count) != 0) {
                this.addSilence(oneBit);
                continue;
            }
            this.addSilence(zeroBit);
        } while ((count >>= 1) != 0);
    }
}

