/*
 * Decompiled with CFR 0.152.
 */
package libsidutils.directory;

import java.util.ArrayList;
import java.util.Collection;
import libsidutils.directory.DirEntry;

public class Directory {
    private boolean singleSided = true;
    private byte[] title;
    private byte[] id;
    private Collection<DirEntry> dirEntries = new ArrayList<DirEntry>();
    private String statusLine;

    public void setTitle(byte[] diskName) {
        this.title = diskName;
    }

    public void setId(byte[] diskID) {
        this.id = diskID;
    }

    public void setSingleSided(boolean single) {
        this.singleSided = single;
    }

    public Collection<DirEntry> getDirEntries() {
        return this.dirEntries;
    }

    public String getStatusLine() {
        return this.statusLine;
    }

    public void setFreeBlocks(int blocks) {
        this.statusLine = String.format("%-3d BLOCKS FREE.", blocks);
    }

    public void setStatusLine(String line) {
        this.statusLine = line;
    }

    public String toString() {
        StringBuilder header = new StringBuilder();
        header.append(this.singleSided ? "0 " : "1 ");
        header.append(DirEntry.convertFilename(this.title, -1));
        if (this.id != null) {
            header.append(" ");
            for (int i = 0; i < this.id.length; ++i) {
                header.append((char)(this.id[i] & 0xFF));
            }
        }
        return header.toString();
    }
}

