/*
 * Decompiled with CFR 0.152.
 */
package libsidutils.directory;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;

public abstract class DirEntry {
    private static final Charset ISO88591 = Charset.forName("ISO-8859-1");
    public static final byte BITMASK_FILETYPE = 7;
    public static final byte FILETYPE_DEL = 0;
    public static final byte FILETYPE_SEQ = 1;
    public static final byte FILETYPE_PRG = 2;
    public static final byte FILETYPE_USR = 3;
    public static final byte FILETYPE_REL = 4;
    private static final String[] FILETYPES = new String[]{"DEL", "SEQ", "PRG", "USR", "REL"};
    private int blocks;
    private byte[] filename;
    private byte fileType;

    public DirEntry(int nrSectors, byte[] fn, byte fType) {
        this.blocks = nrSectors;
        this.filename = fn;
        this.fileType = fType;
    }

    public static final String convertFilename(byte[] fileName, int fileType) {
        StringBuffer fn = new StringBuffer();
        fn.append("\"");
        for (byte c : fileName) {
            if (c == 13 || c == 0) break;
            fn.append((char)(c & 0xFF));
        }
        fn.append("\"");
        if (fileType != -1) {
            int ft = fileType & 7;
            fn.append(" ").append(FILETYPES[ft - 0]);
        }
        return fn.toString();
    }

    public static final byte[] asciiTopetscii(String str, int maxLen) {
        return str.substring(0, Math.min(maxLen, str.length())).toUpperCase().replace('_', '-').getBytes(ISO88591);
    }

    public String toString() {
        return String.format("%-3d  %s", this.blocks, DirEntry.convertFilename(this.filename, this.fileType));
    }

    public final String getValidFilename() {
        String convertFilename = DirEntry.convertFilename(this.filename, -1);
        return convertFilename.substring(1, convertFilename.length() - 1).replace('/', '_');
    }

    public abstract void save(File var1) throws IOException;
}

