/*
 * Decompiled with CFR 0.152.
 */
package libsidutils.directory;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import libsidplay.components.cart.Cartridge;
import libsidutils.directory.Directory;

public class CartridgeDirectory {
    private static final Charset ISO88591 = Charset.forName("ISO-8859-1");

    public static Directory getDirectory(File file) throws IOException {
        Directory dir = new Directory();
        try (DataInputStream dis = new DataInputStream(new FileInputStream(file));){
            byte[] header = new byte[64];
            dis.readFully(header);
            Cartridge.CRTType type = Cartridge.CRTType.getType(header);
            dir.setTitle(type.toString().replace('_', '-').getBytes(ISO88591));
            dir.setId(String.valueOf(file.length() >> 10).getBytes(ISO88591));
        }
        return dir;
    }
}

