/*
 * Decompiled with CFR 0.152.
 */
package libsidutils.assembler;

import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kickass.AssemblerToolbox;
import kickass.asmnode.AsmNode;
import kickass.asmnode.metanodes.AsmNodeList;
import kickass.asmnode.metanodes.NamespaceNode;
import kickass.asmnode.metanodes.ScopeAndSymbolPageNode;
import kickass.asmnode.output.reciever.MainOutputReciever;
import kickass.misc.MemoryBlock;
import kickass.state.EvaluationState;
import kickass.state.scope.symboltable.SymbolStatus;
import kickass.tools.tuples.Pair;
import kickass.valueholder.ConstantValueHolder;
import kickass.values.HashtableValue;
import kickassu.errors.AsmError;
import kickassu.errors.printers.OneLineErrorPrinter;
import kickassu.exceptions.AsmErrorException;

public class KickAssembler {
    private EvaluationState evaluationState;

    public byte[] assemble(String resource, InputStream asm, Map<String, String> globals) {
        try {
            this.evaluationState = new EvaluationState();
            this.evaluationState.setMaxMemoryAddress(65635);
            HashtableValue hashtableValue = new HashtableValue().addStringValues(globals);
            hashtableValue.lock(null);
            this.evaluationState.getSystemNamespace().getScope().defineErrorIfExist("cmdLineVars", arrReferenceValue -> new ConstantValueHolder(hashtableValue), this.evaluationState, "ERROR! cmdLineVars is already defined", null).setStatus(SymbolStatus.defined);
            AsmNode asmNode = AssemblerToolbox.loadAndLexOrError(asm, resource, this.evaluationState, null);
            if (asmNode == null) {
                throw new RuntimeException("Parse error for assembler resource: " + resource);
            }
            asmNode = new NamespaceNode(asmNode, this.evaluationState.getRootNamespace());
            AsmNodeList asmNodeList = new AsmNodeList(asmNode);
            ScopeAndSymbolPageNode scopeAndSymbolPageNode = new ScopeAndSymbolPageNode(asmNodeList, this.evaluationState.getSystemNamespace().getScope());
            this.evaluationState.prepareNewParse();
            AsmNode asmNode2 = scopeAndSymbolPageNode.executeMetaRegistrations(this.evaluationState);
            asmNode2 = asmNode2.executePrepass(this.evaluationState);
            this.printErrorsAndTerminate(this.evaluationState);
            do {
                this.evaluationState.prepareNewParse();
                asmNode2 = asmNode2.executePass(this.evaluationState);
                if (this.evaluationState.getMadeMetaProgress() || asmNode2.isFinished()) continue;
                this.evaluationState.prepareNewParse();
                this.evaluationState.setFailOnInvalidValue(true);
                asmNode2 = asmNode2.executePass(this.evaluationState);
                throw new AsmErrorException("Made no progress and cant solve the program.. You should have gotten an error. Contact the author!", null);
            } while (!asmNode2.isFinished());
            MainOutputReciever mainOutputReciever = new MainOutputReciever(8192, false, this.evaluationState.getMaxMemoryAddress(), null);
            asmNode2.deliverOutput(mainOutputReciever);
            mainOutputReciever.finish();
            return new Assembly(mainOutputReciever.getMemoryBlocks()).getData();
        }
        catch (AsmErrorException e) {
            AsmError asmError = e.getError();
            asmError.setCallStack(this.evaluationState.getCallStack());
            System.err.println(OneLineErrorPrinter.instance.printError(asmError, this.evaluationState));
            throw new AsmErrorException(asmError);
        }
        catch (Exception e) {
            throw new RuntimeException("Internal Error!");
        }
    }

    private void printErrorsAndTerminate(EvaluationState evaluationState) {
        if (!evaluationState.getErrors().isEmpty()) {
            int n = evaluationState.getErrors().size();
            System.err.println("Got " + n + " errors while parsing:");
            for (int i = 0; i < n; ++i) {
                AsmError asmError = evaluationState.getErrors().get(i);
                System.err.println("  " + OneLineErrorPrinter.instance.printError(asmError, evaluationState));
            }
            throw new AsmErrorException(evaluationState.getErrors().get(0));
        }
    }

    public Map<String, Integer> getLabels() {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        List<Pair<String, Integer>> localDefines = this.evaluationState.getResolvedSymbols();
        for (Pair<String, Integer> entry : localDefines) {
            result.put(entry.getA(), entry.getB());
        }
        return result;
    }

    private static class Assembly {
        private ByteBuffer data;

        public Assembly(List<MemoryBlock> memBlocks) throws AsmErrorException {
            memBlocks.removeIf(mem -> mem.isVirtual());
            Collections.sort(memBlocks, (mem1, mem2) -> mem1.getStartAdress() - mem2.getStartAdress());
            if (memBlocks.isEmpty()) {
                throw new AsmErrorException("Error: No data in memory!", null);
            }
            MemoryBlock memoryblock = memBlocks.get(0);
            int start = memoryblock.getStartAdress();
            int end = start + memoryblock.getSize();
            for (int curBlock = 1; curBlock < memBlocks.size(); ++curBlock) {
                memoryblock = memBlocks.get(curBlock);
                if (memoryblock.getStartAdress() < end) {
                    throw new AsmErrorException("Error: Memoryblock starting at $" + Integer.toHexString(memoryblock.getStartAdress()) + " overlaps the previous block", null);
                }
                int nextEnd = memoryblock.getStartAdress() + memoryblock.getSize();
                if (nextEnd <= end) continue;
                end = nextEnd;
            }
            this.data = ByteBuffer.allocate(2 + end - start).order(ByteOrder.LITTLE_ENDIAN);
            this.data.asShortBuffer().put((short)start);
            for (MemoryBlock memoryBlock : memBlocks) {
                int offset = 2 + memoryBlock.getStartAdress() - start;
                this.data.position(offset);
                this.data.put(memoryBlock.getMemory(), 0, memoryblock.getMemory().length);
            }
        }

        public byte[] getData() {
            return this.data.array();
        }
    }
}

