/*
 * Decompiled with CFR 0.152.
 */
package libsidutils;

public class Petscii {
    private static final int[] ISO8859_1_TO_PETSCII = new int[]{128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 0, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 27, 191, 29, 30, 100, 39, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 93, 29, 31, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 33, 3, 28, 191, 89, 93, 191, 34, 67, 1, 60, 191, 45, 82, 99, 15, 191, 50, 51, 39, 21, 191, 191, 44, 49, 15, 62, 191, 191, 191, 63, 65, 65, 65, 65, 65, 65, 65, 67, 69, 69, 69, 69, 73, 73, 73, 73, 191, 78, 79, 79, 79, 79, 79, 24, 79, 85, 85, 85, 85, 89, 191, 191, 1, 1, 1, 1, 1, 1, 1, 3, 5, 5, 5, 5, 9, 9, 9, 9, 191, 14, 15, 15, 15, 15, 15, 191, 15, 21, 21, 21, 21, 25, 191, 25};
    private static final int[] PETSCII_TO_ISO8859_1 = new int[]{0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 13, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 32, 33, 1, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 36, 93, 32, 32, 45, 35, 124, 45, 45, 45, 45, 124, 124, 92, 92, 47, 92, 92, 47, 47, 92, 35, 95, 35, 124, 47, 88, 79, 35, 124, 35, 43, 124, 124, 38, 92, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 32, 124, 35, 45, 45, 124, 35, 124, 35, 47, 124, 124, 47, 92, 92, 45, 47, 45, 45, 124, 124, 124, 124, 45, 45, 45, 47, 92, 92, 47, 47, 35, 45, 35, 124, 45, 45, 45, 45, 124, 124, 92, 92, 47, 92, 92, 47, 47, 92, 35, 95, 35, 124, 47, 88, 79, 35, 124, 35, 43, 124, 124, 38, 92, 32, 124, 35, 45, 45, 124, 35, 124, 35, 47, 124, 124, 47, 92, 92, 45, 47, 45, 45, 124, 124, 124, 124, 45, 45, 45, 47, 92, 92, 47, 47, 35};

    public static byte iso88591ToPetscii(char c) {
        return (byte)ISO8859_1_TO_PETSCII[c & 0xFF];
    }

    public static char petsciiToIso88591(byte c) {
        byte b = (byte)PETSCII_TO_ISO8859_1[c & 0xFF];
        return b != 1 ? (char)(b & 0xFF) : (char)' ';
    }

    public static final String petsciiToIso88591(byte[] petscii) {
        StringBuilder result = new StringBuilder();
        for (int idx = 0; idx < petscii.length; ++idx) {
            result.append(Petscii.petsciiToIso88591(petscii[idx]));
        }
        return result.toString();
    }
}

