/*
 * Decompiled with CFR 0.152.
 */
package libsidutils;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Pattern;

public class PathUtils {
    private static final Pattern SEPARATOR = Pattern.compile("[/\\\\]");

    public static final String getCollectionName(File collectionRoot, File file) {
        return PathUtils.createFilename(PathUtils.getFiles(file.getPath(), collectionRoot, null));
    }

    private static final String createFilename(List<File> files) {
        StringBuilder result = new StringBuilder();
        for (File file : files) {
            result.append("/").append(file.getName());
        }
        return result.toString();
    }

    public static final File getFile(String path, File hvscRoot, File cgscRoot) {
        List<File> files = PathUtils.getFiles(path, hvscRoot, null);
        if (files.size() > 0) {
            return files.get(files.size() - 1);
        }
        files = PathUtils.getFiles(path, cgscRoot, null);
        if (files.size() > 0) {
            return files.get(files.size() - 1);
        }
        return new File(path);
    }

    public static final List<File> getFiles(String path, File rootFile, FileFilter fileFilter) {
        if (rootFile == null) {
            return Collections.emptyList();
        }
        String rootPath = rootFile.getPath();
        if (path.startsWith(rootPath) && (path = path.substring(rootPath.length())).length() > 0) {
            path = path.substring(1);
        }
        ArrayList<File> pathSegs = new ArrayList<File>();
        try (Scanner scanner = new Scanner(path);){
            scanner.useDelimiter(SEPARATOR);
            block12: while (scanner.hasNext()) {
                String pathSeg = scanner.next();
                File[] childFiles = rootFile.listFiles(fileFilter);
                if (childFiles != null) {
                    for (File childFile : childFiles) {
                        if (!childFile.getName().equalsIgnoreCase(pathSeg)) continue;
                        rootFile = childFile;
                        pathSegs.add(rootFile);
                        continue block12;
                    }
                }
                List<File> list = Collections.emptyList();
                return list;
            }
            ArrayList<File> arrayList = pathSegs;
            return arrayList;
        }
    }

    public static final String getFilenameWithoutSuffix(String filename) {
        return filename.substring(0, filename.length() - PathUtils.getFilenameSuffix(filename).length());
    }

    public static final String getFilenameSuffix(String filename) {
        int lastIndexOf = filename.lastIndexOf(46);
        return lastIndexOf != -1 ? filename.substring(lastIndexOf) : "";
    }
}

