/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.sidtune;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import libsidplay.common.CPUClock;
import libsidplay.common.ChipModel;
import libsidplay.config.IEmulationSection;
import libsidplay.sidtune.MP3Tune;
import libsidplay.sidtune.Mus;
import libsidplay.sidtune.P00;
import libsidplay.sidtune.PSid;
import libsidplay.sidtune.Prg;
import libsidplay.sidtune.SidTuneError;
import libsidplay.sidtune.SidTuneInfo;
import libsidplay.sidtune.T64;
import libsidutils.sidid.SidIdInfo;

public abstract class SidTune {
    public static final SidTune RESET = null;
    protected static final int RESET_INIT_DELAY = 2500000;
    private static Constructor<?> TFILE_IS = null;
    private static final int MAX_MEM_64K = 65536;
    protected SidTuneInfo info = new SidTuneInfo();

    public static SidTune load(File file) throws IOException, SidTuneError {
        try {
            return MP3Tune.load(file);
        }
        catch (SidTuneError e1) {
            byte[] fileBuffer = SidTune.getFileContents(file);
            try {
                return SidTune.loadCommon(file.getName(), fileBuffer);
            }
            catch (SidTuneError e2) {
                return Mus.load(file, fileBuffer);
            }
        }
    }

    public static SidTune load(String url, InputStream stream) throws IOException, SidTuneError {
        return SidTune.loadCommon(url, SidTune.getFileContents(stream));
    }

    private static SidTune loadCommon(String name, byte[] fileBuffer) throws SidTuneError {
        try {
            return PSid.load(name, fileBuffer);
        }
        catch (SidTuneError e1) {
            try {
                return Prg.load(name, fileBuffer);
            }
            catch (SidTuneError e2) {
                try {
                    return P00.load(name, fileBuffer);
                }
                catch (SidTuneError e3) {
                    return T64.load(name, fileBuffer);
                }
            }
        }
    }

    public final SidTuneInfo getInfo() {
        return this.info;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static final byte[] getFileContents(File file) throws IOException {
        try (FileInputStream is = TFILE_IS != null ? (InputStream)TFILE_IS.newInstance(file) : new FileInputStream(file);){
            byte[] byArray = SidTune.getFileContents(is);
            return byArray;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new IOException(file.getAbsolutePath());
        }
    }

    private static byte[] getFileContents(InputStream stream) throws IOException {
        int len;
        int count;
        byte[] fileBuf = new byte[65536];
        for (len = 0; len < 65536 && (count = stream.read(fileBuf, len, 65536 - len)) >= 0; len += count) {
        }
        return Arrays.copyOf(fileBuf, len);
    }

    public Speed getSongSpeed(int selected) {
        return Speed.CIA_1A;
    }

    public int getSongSpeedWord() {
        return -1;
    }

    public static boolean isSIDUsed(IEmulationSection emulation, SidTune tune, int sidNum) {
        return SidTune.getSIDAddress(emulation, tune, sidNum) != 0;
    }

    public static int getSIDAddress(IEmulationSection emulation, SidTune tune, int sidNum) {
        int tuneChipBase;
        int forcedSidBase;
        boolean forcedStereoTune;
        switch (sidNum) {
            case 0: {
                return 54272;
            }
            case 1: {
                forcedStereoTune = emulation.isForceStereoTune();
                forcedSidBase = emulation.getDualSidBase();
                int n = tuneChipBase = tune != RESET ? tune.getInfo().getSIDChipBase(sidNum) : 0;
                if (tuneChipBase != 0 || forcedStereoTune || !emulation.isFakeStereo()) break;
                return 54272;
            }
            case 2: {
                forcedStereoTune = emulation.isForce3SIDTune();
                forcedSidBase = emulation.getThirdSIDBase();
                tuneChipBase = tune != RESET ? tune.getInfo().getSIDChipBase(sidNum) : 0;
                break;
            }
            default: {
                throw new RuntimeException("Maximum supported SIDS exceeded!");
            }
        }
        if (forcedStereoTune) {
            return forcedSidBase;
        }
        return tuneChipBase;
    }

    public static boolean isFakeStereoSid(IEmulationSection emulation, SidTune tune, int sidNum) {
        return sidNum > 0 && SidTune.getSIDAddress(emulation, tune, sidNum - 1) == SidTune.getSIDAddress(emulation, tune, sidNum);
    }

    public abstract Integer placeProgramInMemory(byte[] var1);

    public abstract void save(String var1) throws IOException;

    public abstract Collection<String> identify();

    public abstract SidIdInfo.PlayerInfoSection getPlayerInfo(String var1);

    public abstract String getMD5Digest();

    protected abstract long getInitDelay();

    public static long getInitDelay(SidTune tune) {
        return tune != RESET ? tune.getInitDelay() : 2500000L;
    }

    static {
        try {
            TFILE_IS = Class.forName("de.schlichtherle.truezip.file.TFileInputStream").getConstructor(File.class);
        }
        catch (ClassNotFoundException | NoSuchMethodException | SecurityException exception) {
            // empty catch block
        }
    }

    public static enum Compatibility {
        PSIDv1,
        PSIDv2,
        PSIDv3,
        PSIDv4,
        RSID_BASIC,
        RSIDv2,
        RSIDv3;

    }

    public static enum Model {
        UNKNOWN(ChipModel.MOS6581),
        MOS6581(ChipModel.MOS6581),
        MOS8580(ChipModel.MOS8580),
        ANY(ChipModel.MOS6581);

        private ChipModel chipModel;

        private Model(ChipModel chipModel) {
            this.chipModel = chipModel;
        }

        public ChipModel asChipModel() {
            return this.chipModel;
        }
    }

    public static enum Clock {
        UNKNOWN(CPUClock.PAL),
        PAL(CPUClock.PAL),
        NTSC(CPUClock.NTSC),
        ANY(CPUClock.PAL);

        private CPUClock cpuClock;

        private Clock(CPUClock cpuClock) {
            this.cpuClock = cpuClock;
        }

        public CPUClock asCPUClock() {
            return this.cpuClock;
        }
    }

    public static enum Speed {
        VBI(0),
        CIA_1A(60);

        private int speed;

        private Speed(int speed) {
            this.speed = speed;
        }

        public int speedValue() {
            return this.speed;
        }
    }
}

